package com.sap.idm.vds.connector.samplefile.impl;

import java.util.*;

/**
 * Class that contains a set of useful methods of general use
 * @author I054742
 *
 */
public class GenericOperations {

	
	public GenericOperations () {}
	
	
	/**
	 * Checks if 'object' is an element of 'list'
	 * @param list -> A list of strings
	 * @param object -> A string
	 * @return -> The index where 'object' is in 'list',
	 * 			  -1 otherwise
	 */
	static int contains (String []list, String object) {
		
		for (int i=0; i<list.length; i++) {
			
			if (object.equalsIgnoreCase(list[i])) return i;
		}
		return -1;
	}
	
	
	/**
	 * Checks if 'object' exists in 'map'
	 * @param map -> A HashMap
	 * @param object -> A string
	 * @return -> The integer value related with the key 'object' if this exists in 'map',
	 * 			  or -1 otherwise
	 */
	static int contains (HashMap map, String object) {
		
		Integer res = (Integer)map.get(object.toLowerCase());
		if (res==null) return -1;
		return res.intValue();
	}
	
	
	/**
     * Removes the trailing and leading spaces of a string
     * @param str -> The string to be treated
     * @return -> 'str' without trailing and leading spaces
     */
    static public String cleanTrailingAndLeadingSpaces (String str) {
    	
    	/* If the string is null or has no chars then the result is the same string */
    	if (str==null) return null;
    	if (str.length()==0) return str;
    	int i=0, j=str.length()-1;
    	/* Removes the trailing and leading spaces */
    	while (i<str.length() && str.charAt(i)==' ') i++;
    	while (j>i && str.charAt(j)==' ') j--;
    	return str.substring(i, Math.min(j+1, str.length()));
    }
    
    
    /**
     * Removes parenthesis in the beginning and end of a String
     * @param str -> The string to be treated
     * @return -> 'str' without trailing and leading spaces
     */
    static String cleanParenthesis (String str) {
    	
    	/* If the string is null or has no chars then the result is the same string */
    	if (str==null) return null;
    	if (str.length()==0) return str;
    	/* Removes the parenthesis */
    	if (str.charAt(0)=='(') str=str.substring(1);
    	if (str.length()==0) return str;
    	if (str.charAt(str.length()-1)==')') str=str.substring(0, str.length()-1);
    	return str;
    }
    
    
    /**
     * Gets the strings of a vector of vectors which index is 'index' in the secondary vectors
     * @param v -> Vector
     * @param index -> Index
     * @return -> A set of strings in an array of strings
     */
    static String[] getIndexes (Vector v, int index) {
		
		String []res = new String[v.size()];
		
		for (int i=0; i<v.size(); i++) res[i]=(String)(((Vector)v.get(i)).get(index));
		
		return res;
	}
    
    
    /**
     * Removes the null strings of a vector of vectors which index is 'index' in the secondary vectors
     * @param v -> Vector
     * @param index -> Index
     */
    static void removeNull (Vector v, int index) {
    	
		for (int i=0; i<v.size(); i++) {
			Vector vaux = (Vector)v.get(i);
			if (vaux.get(index)==null) {
				vaux.add(index,"");
			}
		}
	}
    
    
    /**
     * Creates a string joining each element of 'pieces' and using as joining element 'joiningSymbol'
     * @param pieces -> Set of strings to be joined
     * @param joiningSymbol -> Element used for joining
     * @return -> The result string
     */
    static String createString (String []pieces, String joiningSymbol) {
    	
    	String res = new String();
    	for (int i=0; i<pieces.length; i++) {
    		if (i>0) res+=joiningSymbol;
    		res+=pieces[i];
    	}
    	return res;
    }
    
    
    /**
     * Creates a map which keys will the the values of 'strs' and values the index of them
     * @param strs -> Set of values that will be used as keys
     * @return -> A HashMap object
     */
    static HashMap createMap (String []strs) {
    	
    	HashMap res = new HashMap();
    	for (int i=0; i<strs.length; i++) res.put(strs[i].toLowerCase(),new Integer(i));
    	return res;
    }
    
    
    /**
	 * Splits 'str' taking as separator 'spliter'
	 * @param str -> The string to be split
	 * @param spliter -> Separator
	 * @return -> An array of String with the strings result of the splitting operation
	 */
	static String[] split (String str, String spliter) {
		
		Vector v = new Vector();
		int index;
		while ((index=str.indexOf(spliter))>=0) {
			v.add(str.substring(0,index));
			str=str.substring(index+spliter.length());
		}
		v.add(str);
		String []res = new String[v.size()];
		for (int i=0; i<res.length; i++) res[i]=(String)v.get(i);
		return res;
	}
	
	
	/**
	 * Transform a HashMap<String,String> to HashMap<String,Vector>. The vector value will contains 
	 * the string value of the original map
	 * @param hm -> HashMap<String,String>
	 * @return -> HashMap<String,Vector>
	 */
	static HashMap fromStringToVector (HashMap hm) {
		
		HashMap res = new HashMap();
		for (Iterator it = hm.keySet().iterator(); it.hasNext(); ) {
			String key = (String)it.next();
			String value = (String)hm.get(key);
			Vector v = new Vector();
			v.add(value);
			res.put(key,v);
		}
		return res;
	}
	
	
	/**
	 * Creates a string joining the set of string of 'attr' from the position 'init' on.
	 * The set of string will be joined using 'separator' as joining string
	 * @param attr -> Set of string
	 * @param init -> Position where to read the set of string from
	 * @param separator -> Joining char
	 * @return -> The result string
	 */
	static String makeString (Vector attr, int init, String separator) {
		
		String res = new String();
		for (int i=init; i<attr.size(); i++) {
			if (i>init) res+=separator;
			res+=(String)attr.get(i);
		}
		return res;
	}
	
	
	/**
	 * Transforms a vector of attributes with the format "attrName=attrVal1|...|attrValn" to a HashMap with 
	 * the form: key->name, where name is a string, value->values, where values is a vector of string
	 * @param v -> The vector of attributes
	 * @param spliter -> The splitter string for the attribute values
	 * @return -> The result HashMap
	 */
	static HashMap fromVectorAttributesToHashMap (Vector v, String splitter) {
		
		HashMap res = new HashMap();
		for (int i=0; i<v.size(); i++) {
			String attrib = (String)v.get(i);
			String name = attrib.substring(0,attrib.indexOf('='));
			String values = attrib.substring(attrib.indexOf('=')+1,attrib.length());
			Vector vals = GenericOperations.fromStringValuesToVector(values,splitter);
			res.put(name,vals);
		}
		return res;
	}
	
	
	/**
	 * Transforms a string of attribute values to a vector of string, where each string is a value of the attribute
	 * @param str -> String of attribute values
	 * @param splitter -> The splitter string that separates the attribute values
	 * @return -> A vector of string, where each string is an attribute value
	 */
	static Vector fromStringValuesToVector (String str, String splitter) {
		
		Vector res = new Vector();
		String []pieces = GenericOperations.split(str,splitter);
		for (int i=0; i<pieces.length; i++) {
			res.add(pieces[i]);
		}
		return res;
	}
}
