
/**
 * Decided which test must be executed
 * 
 * @author I054742
 *
 */
public class Tester {
	
	static final String FUNCTIONALITY = "functionality";
	static final String EXHAUSTIVE = "exhaustive";
	static final String PERFORMANCE = "performance";
	static final String INSTRUCTIONS = "instructions";
	static final String MEMORY = "memory";
	static final String EXPECTEDS = "expecteds";
	static private Testing testing = null;
	
	static boolean execute () {
		
		Loggin.Log(Globals.indent()+"Starting testing process...");
		Globals.incIndent();
		
		try {
			String testType = GeneralConfiguration.getTestType();
			
			if (testType.equalsIgnoreCase(FUNCTIONALITY)) {
				return (testing = new RandomTesting()).execute();
			}
			/*else if (testType.equalsIgnoreCase(EXHAUSTIVE)) {
				//return (testing = new RandomTesting()).execute();
				//return (testing = new ExhaustiveTesting()).execute();
			}*/
			else if (testType.equalsIgnoreCase(PERFORMANCE)) {
				return (testing = new PerformanceTesting()).execute();
			}
			else if (testType.equalsIgnoreCase(INSTRUCTIONS)) {
				return (testing = new InstructionsTesting()).execute();
			}
			/*else if (testType.equalsIgnoreCase(MEMORY)) {
				
			}*/
			else if (testType.equalsIgnoreCase(EXPECTEDS)) {
				return (testing = new InstructionsAndExpectedsTesting()).execute();
			}
			else {
				// -- Controlled when parsing the general configuration file
			}
			return true;
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in Tester.execute");
			return false;
		}
		finally {
			Globals.decIndent();
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"Testing process finished");
		}
	}
	
	
	static void report () {
		
		testing.writeReport();
	}
}
