import java.util.Vector;


public class TestCase_MDA_DELETE extends TestCase_M {

	
	final private String TEST_CASE_ID = Globals.TC_MDA_DELETE;
	String getTestCaseId () {return this.TEST_CASE_ID;}
	
	final private int PRIORITY = 500;
	int getPriority () {return this.PRIORITY;}
	
	final private MyHashMap PROPS = new MyHashMap () {{
		put(Globals.PROP_MODIFIABLE,"yes");
		put(Globals.PROP_MAY,"yes");
	}};
	MyHashMap getProps () {return this.PROPS;}
	
	/* We give the option of adding extra values to be added. In this case it is responsibility of the caller to add at least all the values of the attribute */
	private Vector valsToDel = null;
	
	
	public TestCase_MDA_DELETE (MyAttribute att, Entry ent, EntrySet modified) {
		super(att,ent,modified);
		this.modif_opt = Globals.MODIF_DEL_ATTRS;
	}
	
	
	public TestCase_MDA_DELETE (MyAttribute att, Entry ent, EntrySet modified, Vector aValsToDel) {
		super(att,ent,modified);
		this.modif_opt = Globals.MODIF_DEL_ATTRS;
		this.valsToDel = aValsToDel;
	}
	
	
	void calculateVals () {
		super.calculateVals();
		if (this.valsToDel!=null) this.vals.addAll(this.valsToDel);
		else this.vals.addAll(this.att.getValues());
	}
	
	
	void calculateExpected () {
	
		this.ent.removeAttribute(this.att);
	}
	
	
	boolean checkEquality () {
		return this.checkEqOfEntry();
	}
}