import java.util.Vector;


public class TestCase_MA_NORMAL_CASE extends TestCase_MA {
	
	
	final private String TEST_CASE_ID = Globals.TC_MA_NORMAL_CASE;
	String getTestCaseId () {return this.TEST_CASE_ID;}
	
	final private int PRIORITY = 1000;
	int getPriority () {return this.PRIORITY;}
	
	final private MyHashMap PROPS = new MyHashMap () {{
		put(Globals.PROP_MODIFIABLE,"yes");
	}};
	MyHashMap getProps () {return this.PROPS;}
	
	private Vector valsToAdd = null;
	
	
	public TestCase_MA_NORMAL_CASE (MyAttribute att, Entry ent, EntrySet modified) {
		super(att,ent,modified);
	}
	
	
	public TestCase_MA_NORMAL_CASE (MyAttribute att, Entry ent, EntrySet modified, Vector aValsToAdd) {
		super(att,ent,modified);
		this.valsToAdd = aValsToAdd;
	}
	
	
	void calculateVals () {
		
		if (this.valsToAdd!=null) {
			this.vals = this.valsToAdd;
		}
		else {
			try {
				if (Globals.hasPropertyByRdnId(ent.getRdnId(),att.getName(),Globals.PROP_APPENDABLE) || 
					this.att.getNumbOfValues()== 0 ||
					(Globals.hasPropertyByRdnId(ent.getRdnId(),att.getName(),Globals.PROP_MULTIVALUE))) {
					
					int nVals = Globals.randGen.nextInt(MAX_NUMB_VALS_FOR_MA);
					for (int i=0; i<nVals; i++) {
						this.vals.add(Globals.getLegalValue(ent.getRdnId(),att.getName()));
					}
					if (Globals.hasPropertyByRdnId(ent.getRdnId(),att.getName(),Globals.PROP_APPENDABLE)) {
						String allInOne = "";
						for (int i=0; i<this.vals.size(); i++) allInOne+=(String)this.vals.elementAt(i);
						this.vals = new Vector();
						this.vals.add(allInOne);
					}
				}
				else {
					this.vals = new Vector();
				}
			}
			catch (Exception exc) {
				if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in TestCase_MA_NORMAL_CASE.calculateVals");
			}
		}
	}
	
	
	void calculateExpected () {
		super.calculateVals();
		this.att.addValue(this.vals);
	}
}
