import java.util.Iterator;
import java.util.Vector;


public class TestCase_MAA_ADD extends TestCase_M {

	
	final private String TEST_CASE_ID = Globals.TC_MAA_ADD;
	String getTestCaseId () {return this.TEST_CASE_ID;}
	
	final private int PRIORITY = 500;
	int getPriority () {return this.PRIORITY;}
	
	final private MyHashMap PROPS = new MyHashMap () {{
	}};
	MyHashMap getProps () {return this.PROPS;}

	private Vector valsToAdd = null;
	
	
	public TestCase_MAA_ADD (MyAttribute att, Entry ent, EntrySet modified) {
		super(att,ent,modified);
		this.modif_opt = Globals.MODIF_ADD_ATTRS;
	}
	
	
	public TestCase_MAA_ADD (MyAttribute att, Entry ent, EntrySet modified, Vector aVals) {
		super(att,ent,modified);
		this.modif_opt = Globals.MODIF_ADD_ATTRS;
		this.valsToAdd = aVals;
	}
	
	
	void calculateVals () {
		super.calculateVals();
		try {
			
			if (this.valsToAdd==null) {
				
				MyHashMap attList = Globals.getAttListByRdnId(this.ent.getRdnId());
				Vector possAtts = new Vector();
				
				for (Iterator it=attList.keySet().iterator(); it.hasNext(); ) {
					String attName = (String)it.next();
					if (Globals.hasPropertyByRdnId(this.ent.getRdnId(),attName,Globals.PROP_MAY) && 
						this.ent.containsAttributeByName(attName)==null) {
						possAtts.add(attName);
					}
				}
				
				String pickedAttName = null;
				if (possAtts.size()>0) pickedAttName = (String)possAtts.elementAt(Globals.randGen.nextInt(possAtts.size()));
				
				this.att = (pickedAttName==null?null:this.createLegalAtt(this.ent,this.ent.getRdnId(),pickedAttName,4));
				if (this.att!=null) this.vals = this.att.getValues();
			}
			else {
				this.vals = this.valsToAdd;
			}
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in TestCase_MAA_ADD.calculateVals");
		}
	}
	
	
	void calculateExpected () {
		this.ent.addAttribute(this.att);
	}
	
	
	boolean checkEquality () {
		if (this.att==null) return true;
		return (this.checkEqOfEntry() && super.checkEquality());
	}
}
