import java.util.HashMap;
import java.util.Vector;

import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDSearchResults;


public class TestCase_EXPECTED extends TestCase {

	
	final private String TEST_CASE_ID = Globals.TC_EXPECTED;
	String getTestCaseId () {return this.TEST_CASE_ID;}
	
	final private int PRIORITY = 100;
	int getPriority () {return this.PRIORITY;}
	
	final private MyHashMap PROPS = new MyHashMap () {{
	}};
	MyHashMap getProps () {return this.PROPS;}
	
	
	static TestCase createTestCase (MyAttribute att, Entry ent, EntrySet modified, Instruction inst, Expected expect) {
		return new TestCase_EXPECTED(att,ent,modified,inst,expect);
	};
	
	
	private Instruction inst = null;
	private Expected expect = null;
	
	
	public TestCase_EXPECTED (MyAttribute att, Entry ent, EntrySet modified, Instruction inst, Expected expect) {
		super(att,ent,modified);
		this.inst = inst;
		this.expect = expect;
	}
	
	
	void calculateVals () {}
	
	
	void calculateExpected () {}

	
	MVDOperationResult executeCase () {
		
		if (inst.getType().equalsIgnoreCase(Instruction.ADD)) {
			if (this.inst.getEntry()==null) return new MVDOperationResult();
			HashMap atts = GenericMethods.fromAttVectorToHashMap(this.inst.getEntry().getAttributes());
			return Globals.ldapm.add(this.inst.getDn(),atts);
		}
		else if (inst.getType().equalsIgnoreCase(Instruction.DEL)) {
			return Globals.ldapm.delete(this.inst.getDn());
		}
		else {
			if (this.inst.getAttributes().size()==0) this.att = null;
			else this.att = (MyAttribute)(this.inst.getAttributes().firstElement());
			if (this.att==null) return new MVDOperationResult();
			int modif_opt = -1;
			if (this.inst.getType().equalsIgnoreCase(Instruction.MOD_ADD)) modif_opt = Globals.MODIF_ADD_ATTRS;
			else if (this.inst.getType().equalsIgnoreCase(Instruction.MOD_DEL)) modif_opt = Globals.MODIF_DEL_ATTRS;
			else modif_opt = Globals.MODIF_REP_ATTRS;
			Vector modAtt = this.createModifAtt(this.att.getName(),this.att.getValues(),modif_opt);
			return Globals.ldapm.modify(this.inst.getDn(),modAtt);
		}
	}
	
	
	private Entry pickUpEntry (String dn, Vector selectAttrs, String filter) {
	
		Entry res = new Entry(dn,new Vector(),true);
		
		MVDSearchResults sr = Globals.ldapm.search(dn,LDAPManagement.BASE,selectAttrs,
												   filter,Globals.szLimit,Globals.tmLimit,true);
		
		if (sr==null || sr.size()==0) return null;
		
		res.setAttributes(sr);
		
		return res;
	}
	
	
	private boolean hasAll (Vector attsExpected, Vector attsInSystem) {
		
		boolean hasAll = true;
		
		for (int i=0; hasAll && i<attsExpected.size(); i++) {
			
			MyAttribute attExpect = (MyAttribute)attsExpected.elementAt(i);
			String attNameExpect = attExpect.getName();
			
			for (int j=0; j<attsInSystem.size(); j++) {
				
				MyAttribute attSys = (MyAttribute)attsInSystem.elementAt(j);
				String attNameSys = attSys.getName();
				if (attNameExpect.equalsIgnoreCase(attNameSys)) break;
				if (j==attsInSystem.size()-1) hasAll = false;
			}
		}
		
		return hasAll;
	}
	
	
	private void substitute (Vector attsExpected, Vector attsInSystem) {
		
		for (int i=0; i<attsExpected.size(); i++) {
			
			MyAttribute expectAttr = (MyAttribute)attsExpected.elementAt(i);
			
			if (expectAttr.getNumbOfValues()==1 && expectAttr.containsValue(Expected.STAR_VALUE_ATTR)) {
				
				String attNameExpect = expectAttr.getName();
					
				for (int j=0; j<attsInSystem.size(); j++) {
					
					MyAttribute attSys = (MyAttribute)attsInSystem.elementAt(j);
					String attNameSys = attSys.getName();
					if (attNameExpect.equalsIgnoreCase(attNameSys)) {
						
						expectAttr.setValues(attSys.getValues());
					}
				}
			}
		}
	}
	
	
	private void substitute (Vector attsExpected, Vector attsInSystem, String str) {
		
		Vector starVal = new Vector();
		starVal.add(str);
		
		for (int i=0; i<attsExpected.size(); i++) {
			
			MyAttribute expectAttr = (MyAttribute)attsExpected.elementAt(i);
			
			if (expectAttr.getNumbOfValues()==1 && expectAttr.containsValue(Expected.STAR_VALUE_ATTR)) {
				
				expectAttr.setValues(starVal);
			}
		}
	}
	
	
	boolean checkEquality () {
		
		Expected expect = this.expect;
		Entry entInSystem = this.pickUpEntry(expect.getDn(),expect.getSelectAttrs(),expect.getFilter());
		
		if (expect.getAttrs().size()==1) {
			MyAttribute ma = (MyAttribute)expect.getAttrs().firstElement();
			if (ma.getName().equalsIgnoreCase(Expected.NOT_FOUND_ATTR)) {
				if (entInSystem!=null) {
					Globals.errorMessage = "The entry: \""+expect.getDn()+"\" was expected to not be found";
					Loggin.Log(Globals.indent()+"ERROR: "+Globals.errorMessage);
					return false;
				}
				else return true;
			}
		}
		
		Vector attsInSystem = entInSystem.getAttributes();
		Vector attsExpected = expect.getAttrs();
		
		if (attsInSystem.size()==attsExpected.size()) {
			
			if (this.hasAll(attsExpected,attsInSystem)) {
				
				this.substitute(attsExpected,attsInSystem);
			}
			else this.substitute(attsExpected,attsInSystem,"*");
		}
		else this.substitute(attsExpected,attsInSystem,"*");
		
		return (expect.getEntry().equals(entInSystem));
	}
}
