import java.io.File;
import java.io.RandomAccessFile;


/**
 * Reads the regular expression file
 * 
 * @author I054742
 *
 */
public class RegularExpressionFile extends FileParsingMethods {

		
	/* Configuration file */
	static private String CONFIGURATION_FILE = ".\\regex\\regex.conf";
	
	
	static private void readRegExps (RandomAccessFile raf) throws Exception {
		
		MyHashMap currentParams = new MyHashMap();
		
		while (true) {
			
			String line = readLine(raf,0);
			if (line==null) break;
			String idVal[] = parseLinePar(line,null,nLine);
			if (currentParams.containsKey(idVal[0])) {
				Loggin.Log(Globals.indent()+"ERROR: Duplicate regular expression \""+idVal[0]+"\" in line: "+nLine);
				throw new Exception();
			}
			if (Globals.putRegExpDef(idVal[0],idVal[1])==false) throw new Exception();
		}
	}
	
	
	static void readFile () throws Exception {
		
		Loggin.Log(Globals.indent()+"Reading regular expressions file...");
		Globals.incIndent();
		
		try {
			File file = new File(CONFIGURATION_FILE);
			if (file.exists()==false || file.isDirectory()) {
				
				Loggin.Log(Globals.indent()+"ERROR: The configuration file "+CONFIGURATION_FILE+" does not exist");
				throw new Exception();
			}
			
			RandomAccessFile raf = new RandomAccessFile(CONFIGURATION_FILE,"rw");
			nLine = 0;
			
			readRegExps(raf);
			
			raf.close();
			
			Loggin.Log(Globals.indent()+"Regular expressions file read successfully");
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in RegularExpressionFile.readFile");
			Loggin.Log(Globals.indent()+"ERROR: Error reading regular expressions file");
			throw new Exception();
		}
		finally {
			Globals.decIndent();
			Loggin.Log(Globals.indent()+"Regular expressions file reading finished");
		}
	}
}
