
/**
 * Executes the Random testing
 * 
 * @author I054742
 *
 */
public class RandomTesting extends FunctionalityTesting {

	
	boolean execute () {
		
		Loggin.Log("");
		Loggin.Log(Globals.indent()+"#####################################################################");
		Loggin.Log(Globals.indent()+"########## Starting Functionality Testing Process... #################");
		Loggin.Log(Globals.indent()+"#####################################################################");
		Loggin.Log("");
		Globals.incIndent();
		
		try {
			
			this.testName = "Functionality";
		
			this.initialize();
			
			this.totalEntriesWhereAdding=this.totalEntries=1;
			this.initialEntryCounting(GeneralConfiguration.getStartingPoint());
			
			this.calculatePercentageDelete();
			this.calculatePercentageModif();
			
			this.maximum = this.calcMaximum(this.maxims);
			this.MAX_NUMBER_OF_CALLS_TO_SP = this.maximum;
			
			this.times[Globals.TIME_INDEX_FOR_TESTER] = System.currentTimeMillis();
			boolean res = (this.success = this.tester(GeneralConfiguration.getStartingPoint(),999999999));
			this.endTime = System.currentTimeMillis();
			return res;
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in RandomTesting.execute");
			Loggin.Log(Globals.indent()+"ERROR: Error while executing Random Testing Process");
			return false;
		}
		finally {
			this.endTime = System.currentTimeMillis();
			this.times[Globals.TIME_INDEX_FOR_TESTER] = System.currentTimeMillis() - this.times[Globals.TIME_INDEX_FOR_TESTER];
			Globals.decIndent();
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"#####################################################################");
			Loggin.Log(Globals.indent()+"############ Functionality Testing Process ended... #################");
			Loggin.Log(Globals.indent()+"#####################################################################");
			Loggin.Log("");
		}
	}
	
	
	/**
	 * Calculates the percentage of entries that must be deleted under each starting point
	 */
	private void calculatePercentageDelete () {
		
		int te = this.totalEntries;
		int ted = this.maxims[Globals.DEL_ENTRIES]-this.currents[Globals.DEL_ENTRIES];
		
		if (ted>=te) this.percentageDeleteEntries = 33;
		else this.percentageDeleteEntries = (ted*100)/te;
		if (this.percentageDeleteEntries<=0) this.percentageDeleteEntries=Globals.randGen.nextInt(2);
	}
	
	
	/**
	 * Calculates the percentage of modifications per entry
	 */
	private void calculatePercentageModif () {
		
		int te = this.totalEntries;
		int attrDefs = Globals.getNumbOfAtts();
		int total = te*attrDefs;
		int tm = (this.maxims[Globals.MODIF_ADD_ATTRS]+this.maxims[Globals.MODIF_DEL_ATTRS]+this.maxims[Globals.MODIF_REP_ATTRS])-
				 (this.currents[Globals.MODIF_ADD_ATTRS]+this.currents[Globals.MODIF_DEL_ATTRS]+this.currents[Globals.MODIF_REP_ATTRS]);
		
		if (tm>=total) this.percentageModif = 33;
		else this.percentageModif = ((tm*100)/total)+1;
		if (this.percentageModif<=0) this.percentageModif=Globals.randGen.nextInt(2);
	}
	
	
	/**
	 * It executes the certification tester taking as starting point the parameter 'sp'
	 * @param sp Starting point where made the test from
	 * @return 'true' if the expected results matches with the real state in every moment
	 * 		   'false' otherwise
	 */
	protected boolean tester (String sp, int deepness) {
		
		while (true) {
			
			if (this.timeCondition()==false) return true;
			
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"Testing... taking as starting point: \""+sp+"\"");
			EntrySet modified = this.initUnderSp(sp,true);
			if (modified==null) return true;
			
			deepness--;
			final int NEW_DEEPNESS = 3;
			
			Entry entForCase[] = {null,null,null,null,null};
			MyAttribute attForCase[] = {null,null,null,null,null};
			EntrySet newEnts = new EntrySet();
			int numbOfOpers[] = this.calcNumbOfOps(modified.getNumbOfEntries());
			boolean allowed[] = {true,true,true,true,true};
			this.setAllowed(allowed,numbOfOpers,sp,modified,entForCase,attForCase);
			
			int reservedDels = (numbOfOpers[Globals.DEL_ENTRIES]*2)/3;
			numbOfOpers[Globals.DEL_ENTRIES]-=reservedDels;
			
if (Certification.DEBUGGING_INFO) Loggin.Log("Operations ... : "+bl(allowed)+"----"+il(numbOfOpers)+" ..... deepness: "+deepness);
			
			while (this.allFalse(allowed)==false && this.localCondition(numbOfOpers)) {
				
				int repeatOper = this.repeatOpers((boolean[])allowed.clone(),numbOfOpers);
				for (int i=0; this.allFalse(allowed)==false && this.localCondition(numbOfOpers) && i<repeatOper; i++) {
					this.setAllowed(allowed,numbOfOpers,sp,modified,entForCase,attForCase);
					if (this.launchOper((boolean[])allowed.clone(),numbOfOpers,modified,sp,null,null,newEnts,false,entForCase,attForCase)==false) return false;
					this.setAllowed(allowed,numbOfOpers,sp,modified,entForCase,attForCase);
				}
				
if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Bucle_1"+"   .... Operations: "+bl(allowed)+"----"+il(numbOfOpers));
				
				this.setAllowed(allowed,numbOfOpers,sp,modified,entForCase,attForCase);
				if (this.launchOper((boolean[])allowed.clone(),numbOfOpers,modified,sp,null,null,newEnts,false,entForCase,attForCase)==false) return false;
				this.setAllowed(allowed,numbOfOpers,sp,modified,entForCase,attForCase);
			}
			
			int newDeepness = (Globals.randGen.nextInt(50)<100?-999:Globals.randGen.nextInt(NEW_DEEPNESS));
			newDeepness = (Globals.randGen.nextInt(50)<100?newDeepness:Globals.randGen.nextInt(999999));
			if (deepness>0 && Globals.randGen.nextInt(100)<20 && this.tester(sp,newDeepness)==false) return false;
			
			int locNumbOfEntsWhereAdding = this.countNumbEntsWhereAdding(modified);
			
			int percentCalls = ((locNumbOfEntsWhereAdding*100)/this.totalEntriesWhereAdding)+Globals.randGen.nextInt(2)+1;
			
if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"percentCalls: "+percentCalls);

			for (modified.startIterator(); deepness>0 && this.condition() && modified.hasNext(); ) {
				
				// TODO partialPercentCalls = percentCalls + percent(numbOfEntries under the current one);
				Entry ent = modified.next();
				if (Globals.randGen.nextInt(100)>percentCalls) continue;
				newDeepness = (newEnts.containsEntry(ent)?Math.min(2,deepness):deepness);
				if (this.tester(ent.getDn(),newDeepness)==false) return false;
			}
			
			newDeepness = (Globals.randGen.nextInt(50)<100?-999:Globals.randGen.nextInt(NEW_DEEPNESS));
			newDeepness = (Globals.randGen.nextInt(50)<100?newDeepness:Globals.randGen.nextInt(999999));
			if (deepness>0 && this.condition() && Globals.randGen.nextInt(100)<100 &&  this.tester(sp,newDeepness)==false) return false;
			
			numbOfOpers[Globals.DEL_ENTRIES]+=reservedDels;
			this.setAllowed(allowed,numbOfOpers,sp,modified,entForCase,attForCase);
			while (this.allFalse(allowed)==false && this.localCondition(numbOfOpers)) {
				
				this.setAllowed(allowed,numbOfOpers,sp,modified,entForCase,attForCase);
				if (this.launchOper((boolean[])allowed.clone(),numbOfOpers,modified,sp,null,null,newEnts,false,entForCase,attForCase)==false) return false;
				this.setAllowed(allowed,numbOfOpers,sp,modified,entForCase,attForCase);
			}
			
			if (deepness>999999 && this.condition() && sp.equalsIgnoreCase(GeneralConfiguration.getStartingPoint())) {
				allowed = new boolean[]{true,true,true,true,true};
				this.setAllowed(allowed,new int[]{1,1,1,1,1},sp,modified,entForCase,attForCase);
				if (this.allFalse(allowed)==false) {
					deepness = 999999999;
					continue;
				}
			}
			return true;
		}
	}
}
