import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;


/**
 * Executes the Performance testing
 * 
 * @author I054742
 *
 */
public class PerformanceTesting extends Testing {
	

	/**
	 * Makes the performance test
	 * @return A data set with final summary information about the whole process
	 */
	boolean execute () {
		
		Loggin.Log("");
		Loggin.Log(Globals.indent()+"#####################################################################");
		Loggin.Log(Globals.indent()+"############ Starting Performance Testing Process... ################");
		Loggin.Log(Globals.indent()+"#####################################################################");
		Loggin.Log("");
		Globals.incIndent();
		
		try {
			
			this.testName = "Performance";
			
			String sp = GeneralConfiguration.getStartingPoint();
			
			Loggin.Log(Globals.indent()+"Making search from the initial starting point: \""+sp+"\"");
			EntrySet modified = this.initUnderSp(sp,true);
			
			this.initialize();
			if (modified==null) return true;
			
			this.success = false;
			
			boolean result = true;
			
			Loggin.Log("");
			if (result && this.timeCondition()) result = this.perfAddEnts(sp,modified);
			
			if (result && this.timeCondition()) result = this.perfSearchBase(sp);
			
			if (result && this.timeCondition()) result = this.perfSearchOneLevel(sp);
			
			if (result && this.timeCondition()) result = this.perfSearchOneLevelSP(sp);
			
			if (result && this.timeCondition()) result = this.perfModAddAtts(sp,modified);
			
			if (result && this.timeCondition()) result = this.perfModDelAtts(sp,modified);
			
			if (result && this.timeCondition()) result = this.perfModRepAtts(sp,modified);
					
			if (result && this.timeCondition()) result = this.perfDelEnts(sp,modified);
			
			this.success = result;
			
			return true;
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in PerformanceTesting.execute");
			return  true;
		}
		finally {
			this.endTime = System.currentTimeMillis();
			Globals.decIndent();
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"#####################################################################");
			Loggin.Log(Globals.indent()+"############### Performance Testing Process ended... ################");
			Loggin.Log(Globals.indent()+"#####################################################################");
			Loggin.Log("");
		}
	}
	
	
	void writeReport () {
		
		this.writeHeader();
		
		if (this.success==false) {
			Loggin.Log(Globals.indent()+"Performance testing process was aborted because some error occurred during the process");
		}
		else {
			if (this.timeExpired) {
				Loggin.Log(Globals.indent()+"Performance testing process finished before finishing all the desired operations because the maximum allowed time for the process was reached");
			}
			else {
				Loggin.Log(Globals.indent()+"Performance testing process finished successfully");
			}
		}
		
		for (int i=0; i<Globals.NUMB_OF_PERF_OPERS; i++) {
			
			Loggin.Log("");
			if (this.maxims[i]==0) {
				Loggin.Log(Globals.indent()+"0 "+Globals.OPER_ID[i]+" were done as it was asked");
			}
			else {
				Loggin.Log(Globals.indent()+this.currents[i]+" "+Globals.OPER_ID[i]+" out of "+this.maxims[i]);
				Loggin.Log(Globals.indent()+"Consumed time: "+GenericMethods.expressProperlyTime(this.times[i]));
				if (this.currents[i]>0) { 
					long avgTime = this.times[i]/this.currents[i];
					Loggin.Log(Globals.indent()+"Average time by operation: "+GenericMethods.expressProperlyTime(avgTime));
				}
				else {
					Loggin.Log(Globals.indent()+"No average time since zero operations were done");
				}
			}
		}
		
		Loggin.Log("");
		this.writeNumbOfTC();
		
		Loggin.Log("");
		Globals.ldapm.writeReport();
		
		Loggin.Log("");
		Loggin.Log(Globals.indent()+"Total consumed time by Performance Testing Process: "+GenericMethods.expressProperlyTime(this.endTime-this.startTime));
	}
	
	
	protected void initialize () {
		
		this.times = new long[Globals.NUMB_OF_PERF_OPERS];
		this.currents = new int[Globals.NUMB_OF_PERF_OPERS];
		this.maxims = new int[Globals.NUMB_OF_PERF_OPERS];
		this.maxims[Globals.SEARCH_PERF_BASE]=GeneralConfiguration.getBaseSearches();
		this.maxims[Globals.SEARCH_PERF_ONE_LEVEL]=GeneralConfiguration.getOneLevelSearches();
		this.maxims[Globals.SEARCH_PERF_ONE_LEVEL_SP]=GeneralConfiguration.getOneLevelSearchesFromSP();
		super.initialize();
	}
	
	
	private boolean perfSearchBase (String sp) {
		
		try {
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"Launching base search operations");
			Globals.incIndent();
			this.times[Globals.SEARCH_PERF_BASE] = System.currentTimeMillis();
			boolean res = true;
			while (res && this.searchBaseCondition()) {
				int currs = this.currents[Globals.SEARCH_PERF_BASE];
				res = this.perfSearchBase(sp,true);
				if (currs==this.currents[Globals.SEARCH_PERF_BASE]) {
					Loggin.Log(Globals.indent()+"WARNING: Aborting execution of the test for operation "+Globals.OPER_ID[Globals.SEARCH_PERF_BASE]+". It seems there is no chance to execute this operation anymore with the current state");
					return true;
				}
			}
			this.times[Globals.SEARCH_PERF_BASE] = System.currentTimeMillis() - this.times[Globals.SEARCH_PERF_BASE];
			if (res==false) Loggin.Log(Globals.indent()+"Some problem occurred while executing base search operations");
			else Loggin.Log(Globals.indent()+"Base search operation process finished successfully");
			return res;
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in PerformanceTesting.perfSearchBase");
			Loggin.Log(Globals.indent()+"Some problem occurred while executing base search operations");
			return false;
		}
		finally {
			Globals.decIndent();
			Loggin.Log(Globals.indent()+"Base search operation process finished");
			Loggin.Log("");
		}
	}
	
	
	private boolean perfSearchOneLevel (String sp) {
		
		try {
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"Launching one level search operations");
			Globals.incIndent();
			this.times[Globals.SEARCH_PERF_ONE_LEVEL] = System.currentTimeMillis();
			boolean res = true;
			while (res && this.searchOneLevelCondition()) {
				int currs = this.currents[Globals.SEARCH_PERF_ONE_LEVEL];
				res = this.perfSearchOneLevel(sp,null);
				if (currs==this.currents[Globals.SEARCH_PERF_ONE_LEVEL]) {
					Loggin.Log(Globals.indent()+"WARNING: Aborting execution of the test for operation "+Globals.OPER_ID[Globals.SEARCH_PERF_ONE_LEVEL]+". It seems there is no chance to execute this operation anymore with the current state");
					return true;
				}
			}
			this.times[Globals.SEARCH_PERF_ONE_LEVEL] = System.currentTimeMillis() - this.times[Globals.SEARCH_PERF_ONE_LEVEL];
			if (res==false) Loggin.Log(Globals.indent()+"Some problem occurred while executing one level search operations");
			else Loggin.Log(Globals.indent()+"One level search operation process finished successfully");
			return res;
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in PerformanceTesting.perfSearchOneLevel");
			Loggin.Log(Globals.indent()+"Some problem occurred while executing one level search operations");
			return false;
		}
		finally {
			Globals.decIndent();
			Loggin.Log(Globals.indent()+"One level search operation process finished");
			Loggin.Log("");
		}
	}
	
	
	private boolean perfSearchOneLevelSP (String sp) {
		
		try {
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"Launching one level search from starting point operations");
			Globals.incIndent();
			this.times[Globals.SEARCH_PERF_ONE_LEVEL_SP] = System.currentTimeMillis();
			boolean res = true;
			while (res && this.searchOneLevelSPCondition()) {
				int currs = this.currents[Globals.SEARCH_PERF_ONE_LEVEL_SP];
				res = this.perfSearchOneLevelSP(sp,null);
				if (currs==this.currents[Globals.SEARCH_PERF_ONE_LEVEL_SP]) {
					Loggin.Log(Globals.indent()+"WARNING: Aborting execution of the test for operation "+Globals.OPER_ID[Globals.SEARCH_PERF_ONE_LEVEL_SP]+". It seems there is no chance to execute this operation anymore with the current state");
					return true;
				}
			}
			this.times[Globals.SEARCH_PERF_ONE_LEVEL_SP] = System.currentTimeMillis() - this.times[Globals.SEARCH_PERF_ONE_LEVEL_SP];
			if (res==false) Loggin.Log(Globals.indent()+"Some problem occurred while executing one level search from starting point operations");
			else Loggin.Log(Globals.indent()+"One level search from starting point operation process finished successfully");
			return res;
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in PerformanceTesting.perfSearchOneLevelSP");
			Loggin.Log(Globals.indent()+"Some problem occurred while executing one level search from starting point operations");
			return false;
		}
		finally {
			Globals.decIndent();
			Loggin.Log(Globals.indent()+"One level search from starting point operation process finished");
			Loggin.Log("");
		}
	}
	
	
	private boolean perfAddEnts (String sp, EntrySet modified) throws Exception {
		
		try {
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"Launching entry addition operations");
			Globals.incIndent();
			boolean res = this.perfLaunchOpers(Globals.ADD_ENTRIES,sp,modified);
			if (res==false) Loggin.Log(Globals.indent()+"Some problem occurred while executing entry addition operations");
			else Loggin.Log(Globals.indent()+"Entry addition operation process finished successfully");
			return res;
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in PerformanceTesting.perfAddEnts");
			Loggin.Log(Globals.indent()+"Some problem occurred while executing entry addition operations");
			return false;
		}
		finally {
			Globals.decIndent();
			Loggin.Log(Globals.indent()+"Entry addition operation process finished");
			Loggin.Log("");
		}
	}
	
	
	private boolean perfModAddAtts (String sp, EntrySet modified) {
		
		try {
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"Launching attribute modification ADD operations");
			Globals.incIndent();
			boolean res = this.perfLaunchOpers(Globals.MODIF_ADD_ATTRS,sp,modified);
			if (res==false) Loggin.Log(Globals.indent()+"Some problem occurred while executing attribute modification ADD operations");
			else Loggin.Log(Globals.indent()+"Attribute modification ADD operation process finished successfully");
			return res;
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in PerformanceTesting.perfModAddAtts");
			Loggin.Log(Globals.indent()+"Some problem occurred while executing attribute modification ADD operations");
			return false;
		}
		finally {
			Globals.decIndent();
			Loggin.Log(Globals.indent()+"Attribute modification ADD operation process finished");
			Loggin.Log("");
		}
	}
	
	
	private boolean perfModDelAtts (String sp, EntrySet modified) {
		
		try {
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"Launching attribute modification DELETE operations");
			Globals.incIndent();
			boolean res = this.perfLaunchOpers(Globals.MODIF_DEL_ATTRS,sp,modified);
			if (res==false) Loggin.Log(Globals.indent()+"Some problem occurred while executing attribute modification DELETE operations");
			else Loggin.Log(Globals.indent()+"Attribute modification DELETE operation process finished successfully");
			return res;
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in PerformanceTesting.perfModDelAtts");
			Loggin.Log(Globals.indent()+"Some problem occurred while executing attribute modification DELETE operations");
			return false;
		}
		finally {
			Globals.decIndent();
			Loggin.Log(Globals.indent()+"Attribute modification DELETE operation process finished");
			Loggin.Log("");
		}
	}
	
	
	private boolean perfModRepAtts (String sp, EntrySet modified) {
		
		try {
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"Launching attribute modification REPLACE operations");
			Globals.incIndent();
			boolean res = this.perfLaunchOpers(Globals.MODIF_REP_ATTRS,sp,modified);
			if (res==false) Loggin.Log(Globals.indent()+"Some problem occurred while executing attribute modification REPLACE operations");
			else Loggin.Log(Globals.indent()+"Attribute modification REPLACE operation process finished successfully");
			return res;
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in PerformanceTesting.perfModRepAtts");
			Loggin.Log(Globals.indent()+"Some problem occurred while executing attribute modification REPLACE operations");
			return false;
		}
		finally {
			Globals.decIndent();
			Loggin.Log(Globals.indent()+"Attribute modification REPLACE operation process finished");
			Loggin.Log("");
		}
	}
	
	
	private boolean perfDelEnts (String sp, EntrySet modified) {
		
		try {
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"Launching entry deletion operations");
			Globals.incIndent();
			boolean res = this.perfLaunchOpers(Globals.DEL_ENTRIES,sp,modified);
			if (res==false) Loggin.Log(Globals.indent()+"Some problem occurred while executing entry deletion operations");
			else Loggin.Log(Globals.indent()+"Entry deletion operation process finished successfully");
			return res;
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in PerformanceTesting.perfDelEnts");
			Loggin.Log(Globals.indent()+"Some problem occurred while executing entry deletion operations");
			return false;
		}
		finally {
			Globals.decIndent();
			Loggin.Log(Globals.indent()+"Entry deletion operation process finished");
			Loggin.Log("");
		}
	}
	
	
	private boolean perfLaunchOpers (int oper, String sp, EntrySet modified) {
		
		boolean allow[] = new boolean[Globals.NUMB_OF_OPERS];
		int nOfOpers[] =  new int[Globals.NUMB_OF_OPERS];
		for (int i=0; i<Globals.NUMB_OF_OPERS; i++) {
			allow[i] = (i==oper?true:false);
			nOfOpers[i] = (i==oper?this.maxims[i]:0);
		}
		this.times[oper] = System.currentTimeMillis();
		boolean res = true;
		int count = 0;
		for (; res && this.timeCondition() && this.currents[oper]<this.maxims[oper]; ) {
			int currs = this.currents[oper];
			res = this.launchOper((boolean[])allow.clone(),nOfOpers,modified,sp,null,null,null,true,null,null);
			if (currs==this.currents[oper]) {
				if (++count>333) {
					this.times[oper] = System.currentTimeMillis() - this.times[oper];
					Loggin.Log(Globals.indent()+"WARNING: Aborting execution of the test for operation "+Globals.OPER_ID[oper]+". It seems there is no chance to execute this operation anymore with the current state");
					return true;
				}
			}
			else count = 0;
		}
		this.times[oper] = System.currentTimeMillis() - this.times[oper];
		return res;
	}
	
	
	private boolean searchBaseCondition () {
		return this.currents[Globals.SEARCH_PERF_BASE]<this.maxims[Globals.SEARCH_PERF_BASE];
	}
	
	
	private boolean searchOneLevelCondition () {
		return this.currents[Globals.SEARCH_PERF_ONE_LEVEL]<this.maxims[Globals.SEARCH_PERF_ONE_LEVEL];
	}
	
	
	private boolean searchOneLevelSPCondition () {
		return this.currents[Globals.SEARCH_PERF_ONE_LEVEL_SP]<this.maxims[Globals.SEARCH_PERF_ONE_LEVEL_SP];
	}
	
	
	/**
	 * Makes the base search performance testing. It distribute the searches over the complete tree
	 * @return 'true' if no error was found while running the process
	 * 		   'false' otherwise
	 */
	private boolean perfSearchBase (String sp, boolean first) {
		
		if (this.timeCondition()==false) return true;
		long oneLevelTime = System.currentTimeMillis();
		/* Expands 'sp' */
		MVDSearchResults sr = Globals.ldapm.search(sp,LDAPManagement.ONE_LEVEL,Globals.attr,
												   Globals.urlfilter,Globals.szLimit,Globals.tmLimit,false);
		oneLevelTime = System.currentTimeMillis() - oneLevelTime;
		this.times[Globals.SEARCH_PERF_BASE]+=oneLevelTime;
		/* If we called externally this method then we should set the parameter 'first' to 'true' in order to make a base search for the initial starting point */
		if (first) {
			Globals.ldapm.search(sp,LDAPManagement.BASE,Globals.attr,Globals.urlfilter,
								 Globals.szLimit,Globals.tmLimit,true);
			this.currents[Globals.SEARCH_PERF_BASE]++;
			if (this.searchBaseCondition()==false) return true;
		}
		if (sr==null) return true;
		/* Goes through the set of nodes given as consequence of the expansion of 'sp' */
		for (int i=0; this.searchBaseCondition() && this.timeCondition() && i<sr.size(); i++) {
			MVDSearchResultEntry me = (MVDSearchResultEntry)sr.elementAt(i);
			Loggin.Log(Globals.indent()+"Making base search from starting point: "+me.getDn());
			/* Makes a base search for one node */
			Globals.ldapm.search(me.getDn(),LDAPManagement.BASE,Globals.attr,Globals.urlfilter,
								 Globals.szLimit,Globals.tmLimit,true);
			this.currents[Globals.SEARCH_PERF_BASE]++;
			if (this.searchBaseCondition()==false) return true;
			/* Calls recursively in order to try continuing expanding */
			if (this.perfSearchBase(me.getDn(),false)==false) return false;
		}
		return true;
	}
	
	
	/**
	 * Makes the one level search performance testing. It distributes the searches over the complete tree
	 * @param sp Starting point where the searches and expansion will start
	 * @return 'true' if no error was found while running the process
	 * 		   'false' otherwise
	 */
	private boolean perfSearchOneLevel (String sp, Object nothing) {
		
		if (this.timeCondition()==false) return true;
		Loggin.Log(Globals.indent()+"Making one level search from starting point: "+sp);
		MVDSearchResults sr = Globals.ldapm.search(sp,LDAPManagement.ONE_LEVEL,Globals.attr,
												   Globals.urlfilter,Globals.szLimit,Globals.tmLimit,false);
		if (sr==null) return true;
		this.currents[Globals.SEARCH_PERF_ONE_LEVEL]++;
		for (int i=0; this.searchOneLevelCondition() && this.timeCondition() && i<sr.size(); i++) {
			MVDSearchResultEntry me = (MVDSearchResultEntry)sr.elementAt(i);			
			if (this.perfSearchOneLevel(me.getDn(),nothing)==false) return false;
		}
		return true;
	}
	
	
	/**
	 * Makes the one level search performance testing making all the searches from the starting point
	 * @param sp Starting point
	 * @return 'true' if no error was found while running the process
	 * 		   'false' otherwise
	 */
	private boolean perfSearchOneLevelSP (String sp, Object nothing) {
		
		for (; this.searchOneLevelSPCondition() && this.timeCondition(); this.currents[Globals.SEARCH_PERF_ONE_LEVEL_SP]++) {
			
			Loggin.Log(Globals.indent()+"Making one level search from starting point: "+sp);
			Globals.ldapm.search(sp,LDAPManagement.ONE_LEVEL,Globals.attr,
								 Globals.urlfilter,Globals.szLimit,Globals.tmLimit,false);
		}
		return true;
	}
}
