import java.util.Vector;

import com.sap.idm.vds.MVDLogger;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;


/**
 * This class contains the methods that will be used to create the log file
 * 
 * @author I054742
 *
 */
class Loggin {

	
	private static Location logLocation = null;

	Loggin () {}

	
	/**
	 * Initializes the log
	 * @return 'true' if the initialization was done correctly
	 * 		   'false' otherwise
	 */
	static boolean init() {
		
		String aLoc = ".\\logs\\log.trc";		
		logLocation = Location.getLocation("com.sap.idm.cf.test");
		if (logLocation == null) {
			System.out.println("Can not create SAP Logging Location ... ");
			return false;
		}
		logLocation.setEffectiveSeverity(Severity.INFO);
		logLocation.addLog(new FileLog(aLoc));
		
		Vector v = new Vector();
		v.add("main");
		MVDLogger.addLoggers(v);
		
		return true;
	}

	
	/**
	 * Writes in the log 'message'
	 * @param message The message to be written
	 */
    static void Log (String message)  {
    	
    	/*-*/if (Certification.OUTPUT_INFO) System.out.println(message);
    	logLocation.logT(Severity.INFO,message);
	}
}
