import java.util.Vector;


/**
 * Executes the InstructionsAndExpecteds testing
 * 
 * @author I054742
 *
 */
public class InstructionsAndExpectedsTesting extends Testing {

	
	boolean execute () {
		
		Loggin.Log("");
		Loggin.Log(Globals.indent()+"#####################################################################");
		Loggin.Log(Globals.indent()+"### Starting Instructions And Expecteds Results Testing Process... ##");
		Loggin.Log(Globals.indent()+"#####################################################################");
		Loggin.Log("");
		Globals.incIndent();	
		
		try {
			
			this.testName = "Instructions And Expected Results";
			
			Vector instsAndExpects = InstructionsAndExpectedsFile.getInstsAndExpects();
			
			this.success = false;
			this.initialize();
			
			for (int i=0; this.timeCondition() && i<instsAndExpects.size(); i++) {
				
				Object obj = instsAndExpects.elementAt(i);
				if (obj instanceof Instruction) {
					Instruction inst = (Instruction)obj;
					Loggin.Log("");
					Loggin.Log(Globals.indent()+"Executing instruction: "+inst.getOriginal()+". In line: "+inst.getNLine());
					TestCase_EXPECTED tc = new TestCase_EXPECTED(null,null,null,inst,null);
					tc.executeCase();
				}
				else {
					Expected expect = (Expected)obj;
					Loggin.Log("");
					Loggin.Log(Globals.indent()+"Executing instruction: "+expect.getOriginal()+". In line: "+expect.getNLine());
					TestCase_EXPECTED tc = new TestCase_EXPECTED(null,null,null,null,expect);
					if (tc.checkEquality()==false) {
						return false;
					}
				}
			}
			
			this.endTime = System.currentTimeMillis();
			this.success = true;
			
			return true;
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in InstructionsAndExpectedsTesting.execute");
			Loggin.Log(Globals.indent()+"ERROR: Error while executing Instructions And Expecteds Testing Process");
			return false;
		}
		finally {
			this.endTime = System.currentTimeMillis();
			this.times[Globals.TIME_INDEX_FOR_TESTER] = System.currentTimeMillis() - this.times[Globals.TIME_INDEX_FOR_TESTER];
			Globals.decIndent();
			Loggin.Log("");
			Loggin.Log(Globals.indent()+"#####################################################################");
			Loggin.Log(Globals.indent()+"##### Instructions And Expecteds Results Testing Process ended... ###");
			Loggin.Log(Globals.indent()+"#####################################################################");
			Loggin.Log("");
		}
	}
	
	
	void writeReport () {
		
		this.writeHeader();
		
		if (this.success==false) {
			Loggin.Log(Globals.indent()+"Instructions testing process was aborted because some error occurred during the process. ERROR: "+Globals.errorMessage);
		}
		else {
			if (this.timeExpired) {
				Loggin.Log(Globals.indent()+"Instructions testing process finished before finishing all the desired operations because the maximum allowed time for the process was reached");
			}
			else {
				Loggin.Log(Globals.indent()+"Instructions testing process finished successfully");
			}
		}
		
		Loggin.Log("");
		this.writeNumbOfTC();
		
		Loggin.Log("");
		Globals.ldapm.writeReport();
		
		Loggin.Log("");
		Loggin.Log(Globals.indent()+"Execution time: "+GenericMethods.expressProperlyTime(this.endTime-this.startTime));	
	}
}
