import java.util.*;


/**
 * Set of variables and methods shared by distinct parts of the application
 * 
 * @author I054742
 *
 */
public class Globals {
	
	/* Constant used for a specific adding-removing attribute */
	static public final String DELETE_JNDI_KEY = "deleteDnIdKeyJNDIpoelkmngkjujnejkqyyejjsj2375h".toLowerCase();
	
	static final String RDN_SEP = "9nxs465vfhtgy75gjhsdj845yjhsfdh7nfd3hb";
	static final String ACC_SEP = ",";
	static final String SEP_BETWEEN_ATT_VALS = " ";
	
	/* Constants to identify the different operations that are asked to be realized for the tester */
	static final int NUMB_OF_OPERS = 5;
	static final int MODIF_ADD_ATTRS = 0;
	static final int MODIF_DEL_ATTRS = 1;
	static final int MODIF_REP_ATTRS = 2;
	static final int ADD_ENTRIES = 3;
	static final int DEL_ENTRIES = 4;
	static final int TIME_INDEX_FOR_TESTER = 0;
	
	static final private int NUMB_OF_EXTRA_PERFORMANCE_OPERS = 3;
	static final int SEARCH_PERF_BASE = 5;
	static final int SEARCH_PERF_ONE_LEVEL = 6;
	static final int SEARCH_PERF_ONE_LEVEL_SP = 7;
	static final int NUMB_OF_PERF_OPERS = NUMB_OF_OPERS + NUMB_OF_EXTRA_PERFORMANCE_OPERS;
	static final int TIME_INDEX_FOR_PERFORM_TESTER = 8;
	
	static final String OPER_ID[] = {
										"modifications with add option",
										"modifications with delete option",
										"modifications with replace option",
										"entry additions",
										"entry deletions",
										"searches with base option",
										"searches with one level option through the virtual tree",
										"searches with one level option from the initial starting point"
	};
	
	/* Test case main identifiers */
	static final String TC_M = "M";
	static final String TC_A = "A";
	static final String TC_D = "D";
	static final String TC_EXPECTED = "EXPECTED";
	
	/* Special illegal case. It covers all the modification illegal cases when executing instructions testing */
	static final String TC_M_ILLEGAL = "M_ILLEGAL";
	
	/* Modifications with ADD option test cases */
	static final String TC_MA_MODIFIABLE = "MA_MODIFIABLE";
	static final String TC_MA_MULTIVALUE = "MA_MULTIVALUE";
	static final String TC_MA_DUPLICATE_VALUES = "MA_DUPLICATE_VALUES";
	static final String TC_MA_ILLEGAL_VALUES = "MA_ILLEGAL_VALUES";
	static final String TC_MA_NORMAL_CASE = "MA_NORMAL_CASE";
	
	/* Legal test cases list */
	static final MyHashMap MODIFY_ADD_TEST_CASES = new MyHashMap() {{
		put(TC_MA_MODIFIABLE,TestCase_MA_MODIFIABLE.class);
		put(TC_MA_MULTIVALUE,TestCase_MA_MULTIVALUE.class);
		put(TC_MA_DUPLICATE_VALUES,TestCase_MA_DUPLICATE_VALUES.class);
		//put(TC_M_ILLEGAL,TestCase_M_ILLEGAL.class);
		put(TC_MA_ILLEGAL_VALUES,TestCase_MA_ILLEGAL_VALUES.class);
		put(TC_MA_NORMAL_CASE,TestCase_MA_NORMAL_CASE.class);
	}};
	
	/* Modifications with DELETE option test cases */
	static final String TC_MD_MODIFIABLE = "MD_MODIFIABLE";
	static final String TC_MD_NOT_EXISTING_VALUES = "MD_NOT_EXISTING_VALUES";
	static final String TC_MD_NORMAL_CASE = "MD_NORMAL_CASE";
	
	static final MyHashMap MODIFY_DEL_TEST_CASES = new MyHashMap() {{
		put(TC_MD_MODIFIABLE,TestCase_MD_MODIFIABLE.class);
		put(TC_MD_NOT_EXISTING_VALUES,TestCase_MD_NOT_EXISTING_VALUES.class);
		put(TC_MD_NORMAL_CASE,TestCase_MD_NORMAL_CASE.class);
	}};
	
	/* Modifications with REPLACE option test cases */
	static final String TC_MR_MODIFIABLE = "MR_MODIFIABLE";
	static final String TC_MR_ILLEGAL_VALUES = "MR_ILLEGAL_VALUES";
	static final String TC_MR_NORMAL_CASE = "MR_NORMAL_CASE";
	
	static final MyHashMap MODIFY_REP_TEST_CASES = new MyHashMap() {{
		put(TC_MR_MODIFIABLE,TestCase_MR_MODIFIABLE.class);
		put(TC_MR_ILLEGAL_VALUES,TestCase_MR_ILLEGAL_VALUES.class);
		put(TC_MR_NORMAL_CASE,TestCase_MR_NORMAL_CASE.class);
	}};
	
	/* Modifications of fake attributes test cases */
	static final String TC_MFA_ADD = "MFA_ADD";
	static final String TC_MFA_DELETE = "MFA_DELETE";
	static final String TC_MFA_REPLACE = "MFA_REPLACE";
	
	static final MyHashMap MODIFY_FAKE_TEST_CASES = new MyHashMap() {{
		put(TC_MFA_ADD,TestCase_MFA_ADD.class);
		put(TC_MFA_DELETE,TestCase_MFA_DELETE.class);
		put(TC_MFA_REPLACE,TestCase_MFA_REPLACE.class);
	}};
	
	/* Attribute deletions test cases */
	static final String TC_MDA_REPLACE = "MDA_REPLACE";
	static final String TC_MDA_DELETE = "MDA_DELETE";
	
	static final MyHashMap MODIFY_DEL_ATT_TEST_CASES = new MyHashMap() {{
		put(TC_MDA_REPLACE,TestCase_MDA_REPLACE.class);
		put(TC_MDA_DELETE,TestCase_MDA_DELETE.class);
	}};
	
	/* Attribute additions test cases */
	static final String TC_MAA_ADD = "MAA_ADD";
	static final String TC_MAA_REPLACE = "MAA_REPLACE";
	
	static final MyHashMap MODIFY_ADD_ATT_TEST_CASES = new MyHashMap() {{
		put(TC_MAA_ADD,null);
		put(TC_MAA_REPLACE,null);
	}};
	
	
	/* Special illegal case. It covers all the entry addition illegal cases when executing instructions testing */
	static final String TC_A_ILLEGAL = "A_ILLEGAL";
	
	/* Entry additions test cases */
	static final String TC_A_LEGAL_DN = "A_LEGAL_DN";
	static final String TC_A_DUPLICATE_DN = "A_DUPLICATE_DN";
	static final String TC_A_ILLEGAL_DN_ID = "A_ILLEGAL_DN_ID";
	static final String TC_A_ILLEGAL_DN_VAL = "A_ILLEGAL_DN_VAL";
	static final String TC_A_NOT_MATCH_LINKED_ATT = "A_NOT_MATCH_LINKED_ATT";
	static final String TC_A_NOT_ALL_MANDATORY = "A_NOT_ALL_MANDATORY";
	
	static final MyHashMap ADD_TEST_CASES = new MyHashMap() {{
		put(TC_A_LEGAL_DN,TestCase_A_LEGAL_DN.class);
		put(TC_A_DUPLICATE_DN,TestCase_A_DUPLICATE_DN.class);
		//put(TC_A_ILLEGAL,TestCase_A_ILLEGAL.class);
		put(TC_A_ILLEGAL_DN_ID,TestCase_A_ILLEGAL_DN_ID.class);
		put(TC_A_ILLEGAL_DN_VAL,TestCase_A_ILLEGAL_DN_VAL.class);
		put(TC_A_NOT_MATCH_LINKED_ATT,TestCase_A_NOT_MATCH_LINKED_ATT.class);
		put(TC_A_NOT_ALL_MANDATORY,TestCase_A_NOT_ALL_MANDATORY.class);
	}};
	
	
	/* Special illegal case. It covers all the entry deletion illegal cases when executing instructions testing */
	static final String TC_D_ILLEGAL = "D_ILLEGAL";
	
	/* Entry deletions test cases */
	static final String TC_D_EXISTING_ENTRY = "D_EXISTING_ENTRY";
	static final String TC_D_NOT_EXISTING_ENTRY = "D_NOT_EXISTING_ENTRY";
	static final String TC_D_ILLEGAL_DN_ID = "D_ILLEGAL_DN_ID";
	static final String TC_D_ILLEGAL_DN_VAL = "D_ILLEGAL_DN_VAL";
	
	static final MyHashMap DEL_TEST_CASES = new MyHashMap() {{
		put(TC_D_EXISTING_ENTRY,TestCase_D_EXISTING_ENTRY.class);
		put(TC_D_NOT_EXISTING_ENTRY,TestCase_D_NOT_EXISTING_ENTRY.class);
		//put(TC_D_ILLEGAL,TestCase_D_ILLEGAL.class);
		put(TC_D_ILLEGAL_DN_ID,TestCase_D_ILLEGAL_DN_ID.class);
		put(TC_D_ILLEGAL_DN_VAL,TestCase_D_ILLEGAL_DN_VAL.class);
	}};
	
	static final MyHashMap ATT_TEST_CASES = new MyHashMap() {{
		
		putAll(MODIFY_ADD_TEST_CASES);
		putAll(MODIFY_DEL_TEST_CASES);
		putAll(MODIFY_REP_TEST_CASES);
		putAll(MODIFY_DEL_ATT_TEST_CASES);
		putAll(MODIFY_ADD_ATT_TEST_CASES);
	}};
	
	/* Legal test cases list */
	static final MyHashMap TEST_CASES = new MyHashMap() {{
		
		putAll(MODIFY_ADD_TEST_CASES);
		putAll(MODIFY_DEL_TEST_CASES);
		putAll(MODIFY_REP_TEST_CASES);
		putAll(MODIFY_FAKE_TEST_CASES);
		putAll(MODIFY_DEL_ATT_TEST_CASES);
		putAll(MODIFY_ADD_ATT_TEST_CASES);
		putAll(ADD_TEST_CASES);
		putAll(DEL_TEST_CASES);
	}};
	
	static final int NUMB_OF_TEST_CASES = TEST_CASES.size();
	
	
	static final private MyHashMap TEST_CASES_MODIF_ADD_ATTRS = new MyHashMap () {{
		put(TC_MA_MODIFIABLE,TestCase_MA_MODIFIABLE.class);
		put(TC_MA_MULTIVALUE,TestCase_MA_MULTIVALUE.class);
		put(TC_MA_DUPLICATE_VALUES,TestCase_MA_DUPLICATE_VALUES.class);
		put(TC_MA_ILLEGAL_VALUES,TestCase_MA_ILLEGAL_VALUES.class);
		put(TC_MA_NORMAL_CASE,TestCase_MA_NORMAL_CASE.class);
		put(TC_MFA_ADD,TestCase_MFA_ADD.class);
		put(TC_MAA_ADD,TestCase_MAA_ADD.class);
	}};
	
	static final private MyHashMap TEST_CASES_MODIF_DEL_ATTRS = new MyHashMap () {{
		put(TC_MD_MODIFIABLE,TestCase_MD_MODIFIABLE.class);
		put(TC_MD_NOT_EXISTING_VALUES,TestCase_MD_NOT_EXISTING_VALUES.class);
		put(TC_MD_NORMAL_CASE,TestCase_MD_NORMAL_CASE.class);
		put(TC_MFA_DELETE,TestCase_MFA_DELETE.class);
		put(TC_MDA_DELETE,TestCase_MDA_DELETE.class);
	}};
	
	
	static final private MyHashMap TEST_CASES_MODIF_REP_ATTRS = new MyHashMap () {{
		put(TC_MR_MODIFIABLE,TestCase_MR_MODIFIABLE.class);
		put(TC_MR_ILLEGAL_VALUES,TestCase_MR_ILLEGAL_VALUES.class);
		put(TC_MR_NORMAL_CASE,TestCase_MR_NORMAL_CASE.class);
		put(TC_MFA_REPLACE,TestCase_MFA_REPLACE.class);
		put(TC_MDA_REPLACE,TestCase_MDA_REPLACE.class);
		put(TC_MAA_REPLACE,TestCase_MAA_REPLACE.class);
	}};
	
	static final private MyHashMap TEST_CASES_ADD_ENTRIES = new MyHashMap () {{
		put(TC_A_LEGAL_DN,TestCase_A_LEGAL_DN.class);
		put(TC_A_ILLEGAL_DN_ID,TestCase_A_ILLEGAL_DN_ID.class);
		put(TC_A_ILLEGAL_DN_VAL,TestCase_A_ILLEGAL_DN_VAL.class);
		put(TC_A_NOT_MATCH_LINKED_ATT,TestCase_A_NOT_MATCH_LINKED_ATT.class);
		put(TC_A_NOT_ALL_MANDATORY,TestCase_A_NOT_ALL_MANDATORY.class);
		put(TC_A_DUPLICATE_DN,TestCase_A_DUPLICATE_DN.class);
	}};
	
	static final private MyHashMap TEST_CASES_DEL_ENTRIES = new MyHashMap () {{
		put(TC_D_EXISTING_ENTRY,TestCase_D_EXISTING_ENTRY.class);
		put(TC_D_NOT_EXISTING_ENTRY,TestCase_D_NOT_EXISTING_ENTRY.class);
		put(TC_D_ILLEGAL_DN_ID,TestCase_D_ILLEGAL_DN_ID.class);
		put(TC_D_ILLEGAL_DN_VAL,TestCase_D_ILLEGAL_DN_VAL.class);
	}};
	
	static final MyHashMap[] TEST_CASES_GROUPS = {TEST_CASES_MODIF_ADD_ATTRS,
												TEST_CASES_MODIF_DEL_ATTRS,
												TEST_CASES_MODIF_REP_ATTRS,
												TEST_CASES_ADD_ENTRIES,
												TEST_CASES_DEL_ENTRIES};
	
	/* Legal properties */
	static final String PROP_VIRTUAL = "virtual";
	static final String PROP_LINKED = "linked";
	static final String PROP_MUST = "must";
	static final String PROP_MAY = "may";
	static final String PROP_AUTOMATIC_MUST = "automaticMust";
	static final String PROP_AUTOMATIC_MAY = "automaticMay";
	static final String PROP_ALLOWS_NO_VALUE = "allowsNoValue";
	static final String PROP_APPENDABLE = "appendable";
	static final String PROP_MULTIVALUE = "multivalue";
	static final String PROP_ALLOWS_DUPLICATE = "allowsDuplicate";
	static final String PROP_MODIFIABLE = "modifiable";
	
	static final MyHashMap PROPERTIES = new MyHashMap() {{
		
		put(PROP_VIRTUAL,"no");
		put(PROP_LINKED,"no");
		put(PROP_MUST,"no");
		put(PROP_MAY,"no");
		put(PROP_AUTOMATIC_MUST,"no");
		put(PROP_AUTOMATIC_MAY,"no");
		put(PROP_ALLOWS_NO_VALUE,"no");
		put(PROP_APPENDABLE,"no");
		put(PROP_MULTIVALUE,"no");
		put(PROP_ALLOWS_DUPLICATE,"no");
		put(PROP_MODIFIABLE,"no");
	}};
	
	
	static final MyHashMap VIRTUAL_CONSTRAINTS = new MyHashMap() {{
		put(PROP_LINKED,"yes");
	}};
	
	static final MyHashMap LINKED_CONSTRAINTS = new MyHashMap() {{
		put(PROP_MODIFIABLE,"no");
		put(PROP_MULTIVALUE,"no");
		put(PROP_AUTOMATIC_MUST,"no");
		put(PROP_AUTOMATIC_MAY,"no");
	}};
	
	static final MyHashMap MUST_CONSTRAINTS = new MyHashMap() {{
		put(PROP_MAY,"no");
		put(PROP_AUTOMATIC_MUST,"no");
		put(PROP_AUTOMATIC_MAY,"no");
	}};
	
	static final MyHashMap MAY_CONSTRAINTS = new MyHashMap() {{
		put(PROP_AUTOMATIC_MUST,"no");
		put(PROP_AUTOMATIC_MAY,"no");
	}};
	
	static final MyHashMap AUTOMATIC_MUST_CONSTRAINTS = new MyHashMap() {{
		put(PROP_AUTOMATIC_MAY,"no");
		put(PROP_MODIFIABLE,"no");
	}};
	
	static final MyHashMap AUTOMATIC_MAY_CONSTRAINTS = new MyHashMap() {{
		put(PROP_MODIFIABLE,"no");
	}};
	
	static final MyHashMap ALLOWS_NO_VALUE_CONSTRAINTS = new MyHashMap() {{
	}};
	
	static final MyHashMap APPENDABLE_CONSTRAINTS = new MyHashMap() {{
		put(PROP_MULTIVALUE,"no");
	}};
	
	static final MyHashMap MULTIVALUE_CONSTRAINTS = new MyHashMap() {{
	}};
	
	static final MyHashMap ALLOWS_DUPLICATE_CONSTRAINTS = new MyHashMap() {{
		put(PROP_MULTIVALUE,"yes");
	}};
	
	static final MyHashMap MODIFIABLE_CONSTRAINTS = new MyHashMap() {{
	}};
	
	static final MyHashMap PROPERTIES_CONSTRAINTS = new MyHashMap() {{
		
		put(PROP_VIRTUAL,VIRTUAL_CONSTRAINTS);
		put(PROP_LINKED,LINKED_CONSTRAINTS);
		put(PROP_MUST,MUST_CONSTRAINTS);
		put(PROP_MAY,MAY_CONSTRAINTS);
		put(PROP_AUTOMATIC_MUST,AUTOMATIC_MUST_CONSTRAINTS);
		put(PROP_AUTOMATIC_MAY,AUTOMATIC_MAY_CONSTRAINTS);
		put(PROP_ALLOWS_NO_VALUE,ALLOWS_NO_VALUE_CONSTRAINTS);
		put(PROP_APPENDABLE,APPENDABLE_CONSTRAINTS);
		put(PROP_MULTIVALUE,MULTIVALUE_CONSTRAINTS);
		put(PROP_ALLOWS_DUPLICATE,ALLOWS_DUPLICATE_CONSTRAINTS);
		put(PROP_MODIFIABLE,MODIFIABLE_CONSTRAINTS);
	}};
	static MyHashMap getPROPERTIES_CONSTRAINTS () {
		
		return PROPERTIES_CONSTRAINTS;
	}
	
	static final MyHashMap MUST_AT_LEAST_ONE_PROP = new MyHashMap() {{
		put(PROP_VIRTUAL,null);
		put(PROP_MUST,null);
		put(PROP_MAY,null);
		put(PROP_AUTOMATIC_MUST,null);
		put(PROP_AUTOMATIC_MAY,null);
	}};
	static MyHashMap getMUST_AT_LEAST_ONE_PROP () {
		
		return MUST_AT_LEAST_ONE_PROP;
	}
	
	/* Contains the set of regular expressions defined into the regular expressions file [regExpId->RegularExpression] */
	static private MyHashMap regExpDefs = new MyHashMap() {{
		
		putAll(RegularExpression.getPREDEFINED_REGULAR_EXPRESSIONS());
	}};
	static boolean putRegExpDef (String id, String val) {
		
		if (RegularExpression.getPREDEFINED_REGULAR_EXPRESSIONS().containsKey(id)) {
			Loggin.Log(indent()+"ERROR: The regular expression definition with ID: \""+id+"\" has the same ID as a predefined regular expression");
			return false;
		}
		if (regExpDefs.containsKey(id)) {
			Globals.incIndent();
			Loggin.Log(Globals.indent()+"ERROR: The regular expression definition with ID: \""+id+"\" has the same ID as another regular expression definition in the regular expression defintions file");
			Globals.decIndent();
			return false;
		}
		RegularExpression re = RegularExpression.getRegExpFromId(val);
		if (re==null) {
			Globals.incIndent();
			Loggin.Log(Globals.indent()+"ERROR: The regular expression with ID: \""+id+"\" did not compile");
			Globals.decIndent();
			return false;
		}
		regExpDefs.put(id,re);
		return true;
	}
	static MyHashMap getRegExpDefs () {
		
		return regExpDefs;
	} 
	static RegularExpression getRegExp (String id) {
		
		if (regExpDefs.containsKey(id)==false) return null;
		return (RegularExpression)regExpDefs.get(id);
	}
	
	
	/* Contains all the legal DN specifications in a special format which will be used by the tester [entryId->Vector] */
	static private MyHashMap legalDNSpecs = new MyHashMap();
	static Vector addLegalDNSpec (String accum, Vector dnDef) {
		
		if (legalDNSpecs.containsKey(accum)) {
			Vector v = (Vector)legalDNSpecs.get(accum);
			for (int i=0; i<v.size(); i++) {
				if (i==EntryDefinition.L_DN_RDN) continue;
				String val1 = (String)v.elementAt(i);
				String val2 = (String)dnDef.elementAt(i);
				if (val1.equalsIgnoreCase(val2)==false) {
					Loggin.Log(indent()+"ERROR: Discrepancy between two RDNs");
					Loggin.Log(indent()+"    \""+(String)v.elementAt(5)+"\"");
					Loggin.Log(indent()+"    \""+(String)dnDef.elementAt(5)+"\"");
					return null;
				}
			}
			return v;
		}
		else {
			legalDNSpecs.put(accum,dnDef);
			return dnDef;
		}
	}
	static MyHashMap getLegalDNSpecs () {return legalDNSpecs;}
	
	/* Contains all the entry definitions [entryId->EntryDefinition] */
	static private MyHashMap entDefByID = new MyHashMap();
	static void addEntDefByID (String eId, EntryDefinition ed) {entDefByID.put(eId,ed);}
	static MyHashMap getEntDefByID () {return entDefByID;} 
	
	/* Contains all the entry definitions [entryRDN->EntryDefinition] 
	 * This one will be only for the entry definitions that the tester will use to create entries */
	static private MyHashMap entDefByRDNID = new MyHashMap();
	static void addEntDefByRDNID (String rDnId, EntryDefinition ed) {entDefByRDNID.put(rDnId,ed);}
	static MyHashMap getEntDefByRDNID () {return entDefByRDNID;}
	static EntryDefinition getEntDefFromRDNID (String rDnId) {
		
		if (entDefByRDNID.containsKey(rDnId)==false) return null;
		return (EntryDefinition)entDefByRDNID.get(rDnId);
	}
	static MyHashMap getAttListByRdnId (String rDnId) {
		
		EntryDefinition entDef = getEntDefFromRDNID(rDnId);
		if (entDef==null) return null;
		return entDef.getAttrList();
	}
	
	/* Contains all the attribute definitions ordered by attribute ID [attID->AttributeDefinition] */
	static private MyHashMap attDefByID = new MyHashMap();
	static void addAttDefByID (String attId, AttributeDefinition ad) {attDefByID.put(attId,ad);}
	static MyHashMap getAttDefByID () {return attDefByID;} 
	
	/* Contains all the attribute definitions ordered by attribute RDN_SEP entry [attName+RDN_SEP+entDef.Id->AttributeDefinition] */
	static private MyHashMap attDefByAtt_Separ_Ent = new MyHashMap();
	static void addAttDefByAtt_Separ_Ent (String att_separ_ent, AttributeDefinition aDef) {attDefByAtt_Separ_Ent.put(att_separ_ent,aDef);}
	static MyHashMap getAttDefByAtt_Separ_Ent () {return attDefByAtt_Separ_Ent;}
	static boolean valIsLegal (String eId, String attName, String value) {
		
		String aeId = attName+RDN_SEP+eId;
		if (attDefByAtt_Separ_Ent.containsKey(aeId)==false) {
			Loggin.Log(indent()+"ERROR: There is no definition for the attribute: \""+attName+"\" of the entry with ID for its definition: \""+eId+"\"");
			return false;
		}
		
		AttributeDefinition aDef = (AttributeDefinition)attDefByAtt_Separ_Ent.get(aeId);
		
		return aDef.valIsLegal(value);
	}
	static boolean isLegalValue (String rDnId, String attName, String value) {
		
		if (entDefByRDNID.containsKey(rDnId)==false) return false;
		EntryDefinition eDef = (EntryDefinition)entDefByRDNID.get(rDnId);
		return valIsLegal(eDef.getId(),attName,value);
	}
	static boolean existsAttByRDnId (String rDnId, String attName) {
		
		return getAttConf(rDnId,attName)!=null;
	}
	static AttributeDefinition getAttConf (String rDnId, String attName) {
		
		if (entDefByRDNID.containsKey(rDnId)==false) return null;
		EntryDefinition eDef = (EntryDefinition)entDefByRDNID.get(rDnId);
		String aeId = attName+RDN_SEP+eDef.getId();
		if (attDefByAtt_Separ_Ent.containsKey(aeId)==false) return null;
		return (AttributeDefinition)attDefByAtt_Separ_Ent.get(aeId); 
	}
	static String getLegalValue (String rDnId, String attName) {
		
		AttributeDefinition aDef = getAttConf(rDnId,attName);
		if (aDef==null) return null;
		return aDef.getLegalVal();
	}
	static String getIllegalValue (String rDnId, String attName) {
		
		AttributeDefinition aDef = getAttConf(rDnId,attName);
		if (aDef==null) return null;
		return aDef.getIllegalVal();
	}
	static boolean hasTestCaseByRdnId (String rDnId, String attName, String testCaseId) {
		
		if (entDefByRDNID.containsKey(rDnId)==false) return false;
		EntryDefinition eDef = (EntryDefinition)entDefByRDNID.get(rDnId);
		boolean provRes = ((eDef.hasTestCase(testCaseId))==Definition.HAS_TC);
		if (attName==null) return provRes;
		String aeId = attName+RDN_SEP+eDef.getId();
		if (attDefByAtt_Separ_Ent.containsKey(aeId)==false) return false;
		AttributeDefinition aDef = (AttributeDefinition)attDefByAtt_Separ_Ent.get(aeId);
		int haveTC = aDef.hasTestCase(testCaseId);
		if (haveTC==Definition.NEUTRAL_TC) return provRes;
		else return (haveTC==Definition.HAS_TC); 
	}
	
	/* Contains the set of properties sorted by attribute and after by entry [aId->[eId->[propId->"yes|no"]]] */
	static private MyHashMap propsByAtt = new MyHashMap();
	/* Contains the set of properties sorted by entry and after by attribute [eId->[aId->[propId->"yes|no"]]] */
	static private MyHashMap propsByEnt = new MyHashMap();
	static private void addProps (MyHashMap repository, String a1, String a2, MyHashMap props) {
		if (repository.containsKey(a1)==false) {
			repository.put(a1,new MyHashMap());
		}
		MyHashMap byA1 = (MyHashMap)repository.get(a1);
		if (byA1.containsKey(a2)==false) {
			byA1.put(a2,new MyHashMap());
		}
		MyHashMap propsByA2 = (MyHashMap)byA1.get(a2);
		propsByA2.putAll(props);
	}
	static void addProps (String eId, MyHashMap propsList) {
		
		for (Iterator it=propsList.keySet().iterator(); it.hasNext(); ) {
			String attrName = (String)it.next();
			MyHashMap props = (MyHashMap)propsList.get(attrName);
			addPropsByAtt(attrName,eId,props);
			addPropsByEnt(eId,attrName,props);
		}
	} 
	static void addPropsByAtt (String attrName, String eId, MyHashMap props) {addProps(propsByAtt,attrName,eId,props);}
	static void addPropsByEnt (String eId, String attrName, MyHashMap props) {addProps(propsByEnt,eId,attrName,props);}
	static MyHashMap getPropsByAtt () {return propsByAtt;}
	static MyHashMap getPropsByEnt () {return propsByEnt;}
	static private boolean exists (MyHashMap repos, String eId, String attName) {
		
		if (repos.containsKey(eId)==false) return false;
		MyHashMap pByAtt = (MyHashMap)repos.get(eId);
		return pByAtt.containsKey(attName);
	}
	static boolean existsAtt (String eId, String attName) {
		
		return exists(propsByEnt,eId,attName);
	}
	static boolean existsEnt (String eId) {
		
		return propsByEnt.containsKey(eId);
	}
	static boolean existsAttName (String attName) {
		
		return propsByAtt.containsKey(attName);
	}
	static boolean hasPropertyByEntDefId (String eId, String attName, String propId) throws Exception {
		
		if (propsByEnt.containsKey(eId)==false) throw new Exception();
		MyHashMap pByAtt = (MyHashMap)propsByEnt.get(eId);
		if (pByAtt.containsKey(attName)==false) throw new Exception();
		MyHashMap props = (MyHashMap)pByAtt.get(attName);
		if (props.containsKey(propId)==false) return false;
		String yesNo = (String)props.get(propId);
		return yesNo.equalsIgnoreCase("yes");
	}
	static boolean hasPropertyByRdnId (String rDnId, String attName, String propId) throws Exception {
		
		if (entDefByRDNID.containsKey(rDnId)==false) throw new Exception();
		EntryDefinition entDef = (EntryDefinition)entDefByRDNID.get(rDnId);
		return hasPropertyByEntDefId(entDef.getId(),attName,propId);
	}
	static private int numbOfAtts = -1;
	static void resetNumbOfAtts () {numbOfAtts=-1;}
	static int getNumbOfAtts () {
		if (numbOfAtts!=-1) return numbOfAtts;
		numbOfAtts = 0;
		for (Iterator it=propsByAtt.keySet().iterator(); it.hasNext(); ) {
			String key = (String)it.next();
			MyHashMap mhm = (MyHashMap)propsByAtt.get(key);
			numbOfAtts+=mhm.size();
		}
		return numbOfAtts;
	}
	
	/* Indentation control */
	static private int indentation = 0;
	static String indent () {
		String res = new String();
		for (int i=0; i<indentation; i++) res+="--";
		return res;
	}
	static void incIndent () {indentation++;}
	static void decIndent () {indentation--;}
	
	/* Used for all the random generation of the program */
	static Random randGen = null;
	static void resetRandom (int seed) {randGen = new Random(seed);}

	/* Some LDAP parameters */
	static String mServer = null;
	static String mPort = null;
	static String mUser = null;
	static String mPassword = null;
	static Vector attr = new Vector();
	static String urlfilter = "(objectclass=*)";
	static int szLimit = -1;
	static int tmLimit = -1;
	static String securityOption = null;
	
	/* Class that allows LDAP operations making use of JNDI */
    static LDAPManagement ldapm = null;
    
    static String errorMessage = "ERROR: Unexpected error";
}
