import java.io.File;
import java.io.RandomAccessFile;


/**
 * Reads the GeneralConfiguration file and checks its correctness
 * 
 * @author I054742
 *
 */
public class GeneralConfiguration extends FileParsingMethods {
	
	
	static private final MyHashMap NOTHING_LEVEL = new MyHashMap();
	
	static private final MyHashMap SOFT_LEVEL = new MyHashMap() {{
		putAll(NOTHING_LEVEL);
		put(Globals.TC_MA_NORMAL_CASE,"yes");
		put(Globals.TC_MD_NORMAL_CASE,"yes");
		put(Globals.TC_MR_NORMAL_CASE,"yes");
		put(Globals.TC_MAA_ADD,"yes");
		put(Globals.TC_MAA_REPLACE,"yes");
		put(Globals.TC_MDA_DELETE,"yes");
		put(Globals.TC_MDA_REPLACE,"yes");
		put(Globals.TC_A_LEGAL_DN,"yes");
		put(Globals.TC_D_EXISTING_ENTRY,"yes");
	}};
	
	static private final MyHashMap MEDIUM_LEVEL = new MyHashMap() {{
		putAll(SOFT_LEVEL);
		put(Globals.TC_MA_MODIFIABLE,"yes");
		put(Globals.TC_MA_MULTIVALUE,"yes");
		put(Globals.TC_MA_DUPLICATE_VALUES,"yes");
		put(Globals.TC_MD_MODIFIABLE,"yes");
		put(Globals.TC_MD_NOT_EXISTING_VALUES,"yes");
		put(Globals.TC_MR_MODIFIABLE,"yes");
		put(Globals.TC_D_NOT_EXISTING_ENTRY,"yes");
		put(Globals.TC_D_ILLEGAL_DN_VAL,"yes");
		put(Globals.TC_A_DUPLICATE_DN,"yes");
	}};
	
	static private final MyHashMap HARD_LEVEL = new MyHashMap() {{
		putAll(MEDIUM_LEVEL);
		put(Globals.TC_MFA_ADD,"yes");
		put(Globals.TC_MFA_DELETE,"yes");
		put(Globals.TC_MFA_REPLACE,"yes");
		put(Globals.TC_A_ILLEGAL_DN_ID,"yes");
		put(Globals.TC_A_NOT_MATCH_LINKED_ATT,"yes");
		put(Globals.TC_A_NOT_ALL_MANDATORY,"yes");
		put(Globals.TC_D_ILLEGAL_DN_ID,"yes");
	}};
	
	static private final MyHashMap SUPER_LEVEL = new MyHashMap() {{
		putAll(HARD_LEVEL);
		put(Globals.TC_MA_ILLEGAL_VALUES,"yes");
		put(Globals.TC_MR_ILLEGAL_VALUES,"yes");
		put(Globals.TC_A_ILLEGAL_DN_VAL,"yes");
	}};
	
	static private final MyHashMap TESTING_LEVELS = new MyHashMap() {{
		put("nothing",NOTHING_LEVEL);
		put("soft",SOFT_LEVEL);
		put("medium",MEDIUM_LEVEL);
		put("hard",HARD_LEVEL);
		put("super",SUPER_LEVEL);
	}};
	
	
	/* Maximum allowed time */
	static private long time;
	static long getTime () {return time;}
	
	/* Number of required entry additions */
	static private int additions;
	static int getAdditions () {return additions;}
	
	/* Number of required entry deletions */
	static private int deletions;
	static int getDeletions () {return deletions;}
	
	/* Number of required attribute modifications */
	static private int modificationsAdd;
	static int getModificationsAdd () {return modificationsAdd;}
	static private int modificationsDel;
	static int getModificationsDel () {return modificationsDel;}
	static private int modificationsRep;
	static int getModificationsRep () {return modificationsRep;}
	
	/* Performance parameters */
	static private int baseSearches;
	static int getBaseSearches () {return baseSearches;}
	
	static private int oneLevelSearches;
	static int getOneLevelSearches () {return oneLevelSearches;}
	
	static private int oneLevelSearchesFromSP;
	static int getOneLevelSearchesFromSP () {return oneLevelSearchesFromSP;}
	
	/* Says if the DNs must be compared by their values and not for identifiers and values */
	static private boolean dnEqualsByValues;
	static boolean isDnEqualsByValues () {return dnEqualsByValues;}
	
	/* Type of desired testing */
	static private MyHashMap testCases = null;
	static MyHashMap getTestCases () {return testCases;}
	
	/* Server parameters */
	static private String startingPoint = null;
	static String getStartingPoint () {return startingPoint;}
	
	static private String server = null;
	static String getServer () {return server;}
	
	static private String port = null;
	static String getPort () {return port;}
	
	static private String user = null;
	static String getUser () {return user;}
	
	static private String password = null;
	static String getPassword () {return password;}
	
	static private int sizeLimit=1000000000;
	static int getSizeLimit () {return sizeLimit;}
	
	static private int timeLimit=1000000;
	static int getTimeLimit () {return timeLimit;}
	
	static private String securityOption = null;
	static String getSecurityOption () {return securityOption;}
	
	/* Seed for the random process */
	static private int seed;
	static int getSeed () {return seed;}
	
	/* Test type */
	static private String testType = null;
	static String getTestType () {return testType;}
	
	/* It will indicate the deepness of the collateral effects checking */
	static private String collateralEffectsChecking;
	static String getCollateralEffectsChecking () {return collateralEffectsChecking;}
	
	/* Indicates if the incompatibilities between properties must be fixed automatically */
	static private boolean fixPropertyIncompatibilities;
	static boolean getFixPropertyIncompatibilities () {return fixPropertyIncompatibilities;}
	
	/* Configuration file */
	static private String CONFIGURATION_FILE = ".\\conf\\GeneralConfiguration.conf";
	

	/**
	 * Parses the configuration file and creates all the data structures to keep the information in the correct way
	 * @return A MyHashMap object if the whole process was done successfully
	 * 		   a null value if some error was discovered while parsing the file
	 */
	static void readFile () throws Exception {
		
		Loggin.Log(Globals.indent()+"Reading general configuration file...");
		Globals.incIndent();
		
		try {
			File file = new File(CONFIGURATION_FILE);
			if (file.exists()==false || file.isDirectory()) {
				
				Loggin.Log(Globals.indent()+"ERROR: The configuration file "+CONFIGURATION_FILE+" does not exist");
				throw new Exception();
			}
			
			RandomAccessFile raf = new RandomAccessFile(CONFIGURATION_FILE,"rw");
			nLine = 0;
			
			/* Reads the maximum allowed time for random execution */
			String str = parseLine(readLine(raf,-1),"time","INTEGER",nLine);
			time=makeInteger(str,true,"time",nLine);
			if (time<0) time=Integer.MAX_VALUE;
			
			/* Reads the performance parameters */
			str = parseLine(readLine(raf,-1),"modificationsAdd","INTEGER",nLine);
			modificationsAdd=makeInteger(str,false,"modificationsAdd",nLine);
			
			str = parseLine(readLine(raf,-1),"modificationsDel","INTEGER",nLine);
			modificationsDel=makeInteger(str,false,"modificationsDelete",nLine);
			
			str = parseLine(readLine(raf,-1),"modificationsRep","INTEGER",nLine);
			modificationsRep=makeInteger(str,false,"modificationsReplace",nLine);
			
			str = parseLine(readLine(raf,-1),"additions","INTEGER",nLine);
			additions=makeInteger(str,false,"additions",nLine);
			
			str = parseLine(readLine(raf,-1),"deletions","INTEGER",nLine);
			deletions=makeInteger(str,false,"deletions",nLine);
			
			str = parseLine(readLine(raf,-1),"baseSearches","INTEGER",nLine);
			baseSearches=makeInteger(str,false,"baseSearches",nLine);
			
			str = parseLine(readLine(raf,-1),"oneLevelSearches","INTEGER",nLine);
			oneLevelSearches=makeInteger(str,false,"oneLevelSearches",nLine);
			
			str = parseLine(readLine(raf,-1),"oneLevelSearchesFromSP","INTEGER",nLine);
			oneLevelSearchesFromSP=makeInteger(str,false,"oneLevelSearchesFromSP",nLine);
			
			/* Reads LDAP parameters */
			str = parseLine(readLine(raf,-1),"startingPoint","\\.+=\\.+(,\\.+=\\.+)*",nLine);
			startingPoint=str;
			
			str = parseLine(readLine(raf,0),"server","\\.+",nLine);
			server=str;
			
			str = parseLine(readLine(raf,0),"port","INTEGER",nLine);
			port=str;
			
			str = parseLine(readLine(raf,0),"user","\\.*",nLine);
			user=str;
			
			str = parseLine(readLine(raf,0),"password","\\.*",nLine);
			password=str;
			
			/*str = parseLine(readLine(raf).toLowerCase(),"sizeLimit","INTEGER",++nLine);
			sizeLimit=Math.max(sizeLimit,new Integer(str).intValue());
			
			str = parseLine(readLine(raf).toLowerCase(),"timeLimit","INTEGER",++nLine);
			timeLimit=Math.max(timeLimit,new Integer(str).intValue());*/
			
			/*str = parseLine(readLine(raf,0),"securityOption","null|ssl",nLine);
			securityOption=(str.equalsIgnoreCase("null")?null:str);*/
			
			/* Reads the test type */
			str = parseLine(readLine(raf,-1),"testType","functionality|performance|instructions|expecteds",nLine);
			testType=str;
			
			/* Reads the testing level property */
			str = parseLine(readLine(raf,-1),"testingLevel","soft|medium|hard|super",nLine);
			testCases = (MyHashMap)TESTING_LEVELS.get(str);
			
			/* Reads the collateral effects checking level */
			str = parseLine(readLine(raf,-1),"collateralEffectsChecking","soft|medium|hard",nLine);
			collateralEffectsChecking=str;
			
			/* Reads the dnEqualsByValues property */
			str = parseLine(readLine(raf,-1),"dnEqualsByValues","yes|no",nLine);
			dnEqualsByValues=str.equalsIgnoreCase("yes");
			
			/* Reads the seed */
			str = parseLine(readLine(raf,0),"seed","INTEGER",nLine);
			seed=new Integer(str).intValue();
			
			/* Reads the automatic fixing property */
			//str = parseLine(readLine(raf,-1),"fixPropertyIncompatibilities","yes|no",++nLine);
			//fixPropertyIncompatibilities=str.equalsIgnoreCase("yes");
			
			if (readLine(raf,0)!=null) {
				
				Loggin.Log(Globals.indent()+"ERROR: Some extra line in general configuration file. In line: "+(nLine));
				throw new Exception();
			}
			
			raf.close();
			
			Loggin.Log(Globals.indent()+"General configuration file read successfully");
		}
		catch (Exception exc) {
			if (Certification.DEBUGGING_INFO) Loggin.Log(Globals.indent()+"Exception: \""+exc.getMessage()+"\" in GeneralConfiguration.readFile");
			Loggin.Log(Globals.indent()+"ERROR: Error reading general configuration file");
			throw new Exception();
		}
		finally {
			Globals.decIndent();
			Loggin.Log(Globals.indent()+"General configuration file reading finished");
		}
	}
}
