import java.util.*;


/**
 * This class represents an Expected object. This is constructed from the information in the file InstructionsAndExpecteds
 * 
 * @author I054742
 *
 */
public class Expected {

	/* The different instruction types */
	static final String ADD = "add";
	static final String DEL = "del";
	static final String MOD_ADD = "mod_add";
	static final String MOD_DEL = "mod_del";
	static final String MOD_REP = "mod_rep";
	
	static private final String NOT_FOUND = "NOT_FOUND";
	static final String NOT_FOUND_ATTR = "superrandomNOT_FOUNDattributeldkiancjsdlfasjdfaosndlkvncaklsdjlaflasdlfawefjansdklfnalskfiwelknj";
	static final String STAR_VALUE_ATTR = "attrvalueSTAR_VALUE_ATTRstarleijafklsdlkfjiiasdjkflasnvndkjlaslkdowoieqoweruhfajsdklnvjjduejjd";
	
	/* Will hold the original instruction line */
	private String original = null;
	/* Will hold the number of line where the instruction is into the file */
	private int nLine = -1;
	/* Instruction type */
	private String type = null;
	/* The instruction DN */
	private String dn = null;
	/* An entry with the instruction DN and the instruction attributes */
	private Entry entry = null;
	
	private String filter = null;
	
	private Vector selectedAttrs = null;
	
	private Vector attrs = null;
	
	
	/* They define any legal entry */
	static private final String ATTRS_DEF = "(\\{NOT_FOUND\\}|\\{((\\[[a-zA-Z_]+=\\.*\\],)*\\[[a-zA-Z_]+=\\.+\\])?\\})";
	static private final String DN_DEF = "(\\.+=\\.+,)*\\.+=\\.+";
	static private final String FILTER_DEF = "\\(\\.*\\)";
	static private final String SELECT_ATTRS_DEF = "\\[([a-zA-Z_]+(,[a-zA-Z_])*)?\\]";
	static private final String EXPECTED_DEF = "expected"+"[ ]+"+DN_DEF+"[ ]+"+FILTER_DEF+"[ ]+"+SELECT_ATTRS_DEF+"[ ]+"+"("+ATTRS_DEF+"|"+"\\{NOTFOUND\\})";
	
	/* Regular expression used to identify any legal instruction */
	static private RegularExpression expectRegDef = RegularExpression.getRegExpFromId(EXPECTED_DEF);
	
	
	static private Vector splitExpected (String expect) {
		
		expect = GenericMethods.cleanTrailingAndLeadingSpaces(expect);
		
		if (expectRegDef.matches(expect)==false) {
			
			Loggin.Log(Globals.indent()+"ERROR: The expected: "+expect+" does not match with any legal expected definition");
			return null;
		}
		
		String separators[] = {" ","(","[","{"};
		int index = -1;
		Vector parts = new Vector();
		
		for (int i=0; i<separators.length; i++) {
			index = expect.indexOf(separators[i]);
			String part = expect.substring(0,index);
			parts.add(part.trim());
			expect = expect.substring(index);
			if (i==separators.length-1) {
				part = expect;
				parts.add(part.trim());
			}
		}
		
		return parts;
	}
	
	
	static Vector makeSelectAttrs (String selectAttrs) {
		
		return GenericMethods.fromArrStringToVector(GenericMethods.collectStrings(selectAttrs,'[',']',","));
	}
	
	
	static Vector makeAttVals (String attVals) {
		
		String attrVals[] = GenericMethods.collectStrings(attVals,' ',' ',"|");
		
		if (attrVals.length==1) {
			if (attrVals[0].equals("*")) attrVals[0] = STAR_VALUE_ATTR;
			else if (attrVals[0].equals("\\*")) attrVals[0] = "*";
		}
		
		return GenericMethods.fromArrStringToVector(attrVals);
	}
	
	
	static Vector makeAttrs (String attrs) {
		
		MyHashMap provRes = new MyHashMap();
		
		String attrSet[] = GenericMethods.collectStrings(attrs,'{','}',"[");
		
		if (attrSet.length==1 && attrSet[0].equalsIgnoreCase(NOT_FOUND)) {
			provRes.put(NOT_FOUND_ATTR,new MyAttribute(NOT_FOUND_ATTR,new Vector(),null));
		}
		else {
			for (int i=0; i<attrSet.length; i++) {
				String attr = attrSet[i];
				int index = attr.indexOf("=");
				if (index<=0) return null;
				String attrSplitt[] = GenericMethods.collectStrings(attr,'[',']',"=");
				if (attrSplitt.length<2) return null;
				String attName = GenericMethods.cleanBrackets(attr.substring(0,index),'[',']');
				if (provRes.containsKey(attName)) return null;
				String attVals = GenericMethods.cleanBrackets(attr.substring(index+1),'[',']');
				Vector vals = makeAttVals(attVals);
				provRes.put(attName,new MyAttribute(attName,vals,null));
			}
		}
		
		Vector res = new Vector();
		
		for (Iterator it=provRes.keySet().iterator(); it.hasNext(); ) {
			
			String attName = (String)it.next();
			res.add((MyAttribute)provRes.get(attName));
		}
		
		return res;
	}
	
	
	static private Expected makeExpected (Vector parts, String orig, int nLine) {
		
		String type = (String)parts.elementAt(0);
		String dn = (String)parts.elementAt(1);
		String filter = (String)parts.elementAt(2);
		String selectAttrs = (String)parts.elementAt(3);
		String attrs = (String)parts.elementAt(4);
		
		Expected res = new Expected();
		
		res.setOriginal(orig);
		res.setType(type);
		res.setDn(dn);
		res.setFilter(filter);
		res.setSelectAttrs(makeSelectAttrs(selectAttrs));
		res.setAttrs(makeAttrs(attrs));
		res.setEntry(new Entry(dn,res.getAttrs(),true));
		res.setNLine(nLine);
		
		return res;
	}
	
	
	static public Expected makeExpected (String expect, int nLine) {
		
		Vector parts = splitExpected(expect);
		if (parts==null) return null;
		
		return makeExpected(parts,expect,nLine);
	}
	
	
	private void setOriginal (String aOriginal) {
		
		this.original=aOriginal;
	}
	
	
	private void setNLine (int aNLine) {
		
		this.nLine=aNLine;
	}
	
	
	private void setType (String aType) {
		
		this.type=aType;
	}
	
	
	private void setDn (String aDn) {
		
		this.dn=aDn;
	}
	
	
	private void setEntry (Entry aEntry) {
		
		this.entry=aEntry;
	}
	
	
	private void setFilter (String aFilter) {
		
		this.filter = aFilter;
	}
	
	
	private void setSelectAttrs (Vector aSelectAttrs) {
		
		this.selectedAttrs = aSelectAttrs;
	}
	
	
	private void setAttrs (Vector aAttrs) {
		
		this.attrs = aAttrs;
	}
	
	
	public String getOriginal () {
		
		return this.original;
	}
	
	
	public int getNLine () {
		
		return this.nLine;
	}
	
	
	public String getType () {
		
		return this.type;
	}
	
	
	public String getDn () {
		
		return this.dn;
	}
	
	
	public Entry getEntry () {
		
		return this.entry;
	}
	
	
	public String getFilter () {
		
		return this.filter;
	}
	
	
	public Vector getSelectAttrs () {
		
		return this.selectedAttrs;
	}
	
	
	public Vector getAttrs () {
		
		return this.attrs;
	}
}
