import java.util.*;

import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;


/**
 * Class to represent a entry set
 * 
 * @author I054742
 *
 */
class EntrySet implements Cloneable {

	/* Set of entries */
	private TreeSet entries = new TreeSet(new CompareEntries());
	//private HashMap hashEntries = new MyHashMap();
	/* Iterator to go through the entries that compose this entry set */
	private Iterator itEntry = null;
	private Entry lastItElem = null;
	/* Iterator used for the comparison of two entry sets */
	private Iterator itEquals = null;
	
	
	/**
	 * Gives the number of entries of this entry set
	 * @return The number of entries
	 */
	int getNumbOfEntries () {
		
		return this.entries.size();
	}
	
	
	/**
	 * Adds the entry 'e' to this entry set
	 * @param e The entry to be added
	 */
	void addEntry (Entry e) {
		
		this.entries.add(e);
		//this.hashEntries.put(e,e);
	}
	
	
	/**
	 * Removes 'e'
	 * @param e The entry to be removed
	 */
	void removeEntry (Entry e) {
		
		if (this.containsEntry(e)==false) return;
		this.entries.remove(e);
		//this.hashEntries.remove(e);
	}
	
	
	
	/**
	 * Gives the entry identify by 'dn'
	 * @param dn The DN of the entry
	 * @return The picked entry
	 */
	Entry getEntry (String dn) {
		
		return (Entry)(this.entries.tailSet(new Entry(dn,new Vector())).first());
	}
	
	
	Entry pickUpEntRandomly () {
		
		//if (this.hashEntries.size()==0) return null;
		if (this.entries.size()==0) return null;
		//int n = Globals.randGen.nextInt(this.hashEntries.size())+1;
		int n = Globals.randGen.nextInt(this.entries.size())+1;
		int i = 0;
		Entry res = null;
		//for (Iterator it=this.hashEntries.keySet().iterator(); i<n && it.hasNext(); i++) {
		for (Iterator it=this.entries.iterator(); i<n && it.hasNext(); i++) {
			res = (Entry)it.next();
		}
		return res;
	}
	
	
	/**
	 * Adds the set of entries 'sr' to this entry set
	 * @param sr Set of entries as result of a search against VDS
	 */
	void setEntries (MVDSearchResults sr) {
		
		if (sr==null) return;
		for (int i=0; i<sr.size(); i++) {
			MVDSearchResultEntry me = (MVDSearchResultEntry)sr.elementAt(i);
			Entry e = new Entry(me.getDn(),new Vector());
			this.addEntry(e);
		}
	}
	
	
	/**
	 * Checks if this entry set contains an entry which DN is the same as the one of 'e'
	 * @param e The entry
	 * @return 'true' if it contains it
	 * 		   'false' otherwise
	 */
	boolean containsEntry (Entry e) {
		
		return this.entries.contains(e);
	}
	
	
	/**
	 * Checks if this entry set contains an entry which DN is 'dn'
	 * @param dn The DN
	 * @return 'true' if it contains it
	 * 		   'false' otherwise
	 */
	boolean containsEntry (String dn) {
		
		return this.entries.contains(new Entry(dn,new Vector()));
	}
	
	
	/**
	 * Gives a clone of this entry set
	 */
	public Object clone () {
		
		EntrySet es = new EntrySet();
		for (Iterator it=this.entries.iterator(); it.hasNext(); ) {
			Entry e = (Entry)it.next();
			es.addEntry((Entry)e.clone());
		}
		return es;
	}
	
	
	
	
	// TODO Take care of the synchronization if it was necessary
	/**
	 * Starts the iterator to go through the entry set
	 */
	void startIterator () {
		
		this.itEntry=this.entries.iterator();
	}
	
	
	/**
	 * Checks if the entry set has more entries according to the current iterator position
	 * @return 'true' if it has more entries
	 * 		   'false' otherwise
	 */
	boolean hasNext () {
		
		return this.itEntry.hasNext();
	}
	
	
	/**
	 * Gives the next entry according to the current iterator position
	 * @return The next entry
	 */
	Entry next () {
		
		return (this.lastItElem=(Entry)this.itEntry.next());
	}
	
	
	/**
	 * Removes the entry where the current iterator position points to
	 */
	void remove () {
		
		//this.allEntries.removeElementAt(this.lastItElem.getIndex());
		//this.hashEntries.remove(this.lastItElem);
		this.itEntry.remove();
	}
	
	
	/**
	 * Starts the iterator to go through the entry set for comparison
	 */
	private void startIteratorEq () {
		
		this.itEquals=this.entries.iterator();
	}
	
	
	/**
	 * Checks if the entry set has more entries according to the current iterator position for comparison
	 * @return 'true' if it has more entries
	 * 		   'false' otherwise
	 */
	private boolean hasNextEq () {
		
		return this.itEquals.hasNext();
	}
	
	
	/**
	 * Gives the next entry according to the current iterator position for comparison
	 * @return The next entry
	 */
	private Entry nextEq () {
		
		return (Entry)this.itEquals.next();
	}
	
	
	/**
	 * 
	 */	
	/*private void removeEq () {
		
		this.itEquals.remove();
	}*/
	
	
	/**
	 * Checks if this entry set and the entry set 'es' are equals looking at the DN of their entries
	 * @param es The entry set to be compared with this one
	 * @return 'true' if both are equal
	 * 		   'false' otherwise
	 */
	boolean equalsOneLevel (EntrySet esSystem) {
		
		if (this.entries.size()!=esSystem.getNumbOfEntries()) {
			Error.numberOfEntries(this,esSystem);
			return false;
		}
		for (this.startIteratorEq(), esSystem.startIteratorEq(); this.hasNextEq(); ) {
			Entry entCTT = this.nextEq();
			Entry entSystem = esSystem.nextEq();
			if (GeneralConfiguration.isDnEqualsByValues()){
				if (entCTT.equalsDnByValues(entSystem)==false) {
					Error.diffEntries(entCTT,entSystem);
					return false;
				}
			}
			else if (entCTT.getDn().equalsIgnoreCase(entSystem.getDn())==false) {
				Error.diffEntries(entCTT,entSystem);
				return false;
			}
		}
		return true;
	}
	
	
	/**
	 * Checks if this entry set and the entry set 'es' are completely equals. Entry by entry, 
	 * attribute by attribute and value by value
	 * @param es The entry set to be compared with this one
	 * @return 'true' if both are equal
	 * 		   'false' otherwise
	 */
	boolean equals (EntrySet es) {
		
		if (this.entries.size()!=es.getNumbOfEntries()) return false;
		for (this.startIteratorEq(), es.startIteratorEq(); this.hasNextEq(); ) {
			Entry e1 = this.nextEq();
			Entry e2 = es.nextEq();
			if (e1.equals(e2)==false) return false;
		}
		return true;
	}
	
	
	
	/**
	 * Checks if this entry set and the entry set 'es' are completely equals. Entry by entry, 
	 * attribute by attribute and value by value
	 * @param es The entry set to be compared with this one
	 * @return 'true' if both are equal
	 * 		   'false' otherwise
	 */
	boolean equalsOnlyDefinitionAndNotAutomatic (EntrySet esSystem) {
		
		if (this.entries.size()!=esSystem.getNumbOfEntries()) {
			Error.numberOfEntries(this,esSystem);
			return false;
		}
		for (this.startIteratorEq(), esSystem.startIteratorEq(); this.hasNextEq(); ) {
			Entry entCTT = this.nextEq();
			Entry entSystem = esSystem.nextEq();
			if (entCTT.equalsOnlyDefinitionAndNotAutomatic(entSystem)==false) {
				Error.diffEntries(entCTT,entSystem);
				return false;
			}
		}
		if (false) return false;
		else return true;
	}
}
