/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.util;

import com.sap.idm.vds.ie.util.IniFile;
import com.sap.idm.vds.sec.Base64;
import com.sap.idm.vds.sec.IllegalBase64Exception;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

public class MVDMic_Util {
    public static String NormalizeForPlatform(String str, boolean bVars, boolean bSep, boolean bFileSep) {
        if (str == null) {
            return null;
        }
        String strRes = str;
        if (bFileSep) {
            strRes = MVDMic_Util.replace(strRes, ";", File.pathSeparator);
            strRes = MVDMic_Util.replace(strRes, ":\\", "$GURBA$");
            strRes = MVDMic_Util.replace(strRes, ":", File.pathSeparator);
            strRes = MVDMic_Util.replace(strRes, "$GURBA$", ":\\");
        }
        if (bSep) {
            strRes = MVDMic_Util.replace(strRes, "\\", File.separator);
            strRes = MVDMic_Util.replace(strRes, "/", File.separator);
        }
        if (bVars && ((strRes = MVDMic_Util.Substitute(strRes)) == null || strRes.length() == 0)) {
            return strRes;
        }
        return strRes;
    }

    public static String Substitute(String aSource) {
        Replacer r = new Replacer(aSource);
        return r.Substitute();
    }

    private static String decryptString(String aCipherText, String aKeyFile) {
        String algName = "DESede/ECB/PKCS5Padding";
        try {
            SecretKeyFactory keyFactory;
            Cipher cp;
            byte[] ciphertext;
            int keyix = 0;
            String inikey = "KEY000";
            String rawkey = "";
            try {
                int colon;
                if (aCipherText.startsWith("{DES3}")) {
                    aCipherText = aCipherText.substring(6);
                }
                if ((colon = aCipherText.indexOf(58)) > 0) {
                    String ix = aCipherText.substring(0, colon);
                    aCipherText = aCipherText.substring(colon + 1);
                    keyix = Integer.parseInt(ix);
                    String num = "000" + Integer.toString(keyix);
                    num = num.substring(num.length() - 3);
                    inikey = "KEY" + num;
                }
                if ((rawkey = IniFile.getKeyValue(aKeyFile, "KEYS", inikey)) == null || rawkey.length() < 1) {
                    Map keys = IniFile.getSectionValues("KEYS", aKeyFile);
                    Object[] sortedKeys = new String[keys.size()];
                    sortedKeys = keys.keySet().toArray(sortedKeys);
                    Arrays.sort(sortedKeys);
                    rawkey = (String)keys.get(sortedKeys[sortedKeys.length - 1]);
                }
                ciphertext = MVDMic_Util.hexToByte(aCipherText);
                cp = Cipher.getInstance(algName);
                keyFactory = SecretKeyFactory.getInstance("DESede");
            }
            catch (NoSuchAlgorithmException nsae) {
                return null;
            }
            byte[] currentKey = MVDMic_Util.hexToByte(rawkey);
            if (inikey.equals("KEY000")) {
                currentKey = Base64.encode(algName.getBytes()).getBytes();
            }
            SecretKey key = keyFactory.generateSecret(new DESedeKeySpec(currentKey));
            cp.init(2, key);
            byte[] cleartext = cp.doFinal(ciphertext);
            return new String(cleartext);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String dcString(String aSource) {
        String result = aSource;
        if (result == null || result.equals("")) {
            result = "";
        } else if (result.startsWith("{CRYPT}")) {
            try {
                String sTemp = result.substring(7, result.length() - 1);
                byte[] bOldTemp = Base64.decode(sTemp);
                byte[] bTemp = new byte[bOldTemp.length - 1];
                for (int i = 1; i < bOldTemp.length; ++i) {
                    int iTmp = bOldTemp[i];
                    iTmp = iTmp + i % 19 - 7;
                    bTemp[i - 1] = (byte)iTmp;
                }
                try {
                    result = new String(bTemp, "UTF-8");
                }
                catch (Exception e) {
                    result = new String(bTemp);
                }
            }
            catch (IllegalBase64Exception ibe) {}
        } else if (result.startsWith("{DES3}")) {
            File dsehome = new File(System.getProperty("MX_SERVER_HOME", "."));
            File keys = new File(dsehome, "impexp");
            File keyfile = new File(keys, "Keys.ini");
            if (keyfile != null && keyfile.exists()) {
                result = MVDMic_Util.decryptString(result, keyfile.getAbsolutePath());
            } else {
                try {
                    String sTemp = result.substring(6);
                    byte[] bTemp = MVDMic_Util.hexToByte(sTemp);
                    String algName = "DESede/ECB/PKCS5Padding";
                    byte[] b = Base64.encode(algName.getBytes()).getBytes();
                    Cipher cp = Cipher.getInstance(algName);
                    SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
                    SecretKey key = keyFactory.generateSecret(new DESedeKeySpec(b));
                    cp.init(2, key);
                    byte[] bText = cp.doFinal(bTemp);
                    result = new String(bText);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static String padMe(int width, String start) {
        StringBuffer sb = new StringBuffer(width);
        for (int x = 0; x < width; ++x) {
            sb.replace(0, 0, " ");
        }
        sb.replace(0, start.length(), start);
        return new String(sb);
    }

    public static String getJavaExecutableName() {
        String os = System.getProperty("os.name").toLowerCase();
        boolean dosBased = os.indexOf("windows") >= 0 || os.indexOf("os/2") >= 0;
        String extension = dosBased ? ".exe" : "";
        File jExecutable = new File(System.getProperty("java.home") + "/../bin/java" + extension);
        if (jExecutable.exists()) {
            return jExecutable.getAbsolutePath();
        }
        jExecutable = new File(System.getProperty("java.home") + "/bin/java" + extension);
        if (jExecutable.exists()) {
            return jExecutable.getAbsolutePath();
        }
        return "java";
    }

    public static byte[] readFile(String filename) {
        return MVDMic_Util.readFile(new File(filename));
    }

    public static byte[] readFile(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        byte[] data = new byte[(int)file.length()];
        try {
            new FileInputStream(file).read(data);
            return data;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static byte[] readFile(InputStream Stream2) {
        BufferedInputStream bf = new BufferedInputStream(Stream2);
        int i = 1;
        String str = new String();
        byte[] s = new byte[6000];
        try {
            while (i > 0) {
                i = bf.read(s);
                if (i <= 0) continue;
                String tempS = new String(s, 0, i);
                str = str + tempS;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return str.getBytes();
    }

    public static final Vector splitString(String aString, char aDelimiter) {
        char[] d = new char[]{aDelimiter};
        return MVDMic_Util.splitString(aString, d);
    }

    public static final Vector splitString(String aString, char[] aDelimiter) {
        Vector<String> result = new Vector<String>();
        StringTokenizer t = new StringTokenizer(aString, new String(aDelimiter));
        while (t.hasMoreTokens()) {
            result.add(t.nextToken());
        }
        return result;
    }

    public static final Vector splitString(String aString, String aDelimiter) {
        String temp = aString;
        Vector<String> result = new Vector<String>();
        if (aDelimiter.length() == 0) {
            result.add(aString);
            return result;
        }
        int idx = temp.indexOf(aDelimiter);
        while (idx >= 0) {
            result.add(temp.substring(0, idx));
            temp = temp.substring(idx + aDelimiter.length());
            idx = temp.indexOf(aDelimiter);
        }
        result.add(temp);
        return result;
    }

    public static final Vector splitStringIgnoreCase(String aString, String aDelimiter) {
        String temp = aString;
        String tempLCase = temp.toLowerCase();
        String delimLCase = aDelimiter.toLowerCase();
        Vector<String> result = new Vector<String>();
        int idx = tempLCase.indexOf(delimLCase);
        while (idx >= 0) {
            result.add(temp.substring(0, idx));
            tempLCase = tempLCase.substring(idx + delimLCase.length());
            temp = temp.substring(idx + aDelimiter.length());
            idx = tempLCase.indexOf(delimLCase);
        }
        result.add(temp);
        return result;
    }

    public static final String joinStrings(String[] aStrings, String aDelimiter) {
        String result = "";
        for (int i = 0; i < aStrings.length; ++i) {
            result = i == 0 ? aStrings[i] : result + aDelimiter + aStrings[i];
        }
        return result;
    }

    public static final String joinStrings(Vector aStrings, String aDelimiter) {
        String result = "";
        boolean first = true;
        Iterator it = aStrings.iterator();
        while (it.hasNext()) {
            if (first) {
                result = (String)it.next();
                first = false;
                continue;
            }
            result = result + aDelimiter + (String)it.next();
        }
        return result;
    }

    public static final String replace(String aSource, String aOldString, String aNewString) {
        return MVDMic_Util.joinStrings(MVDMic_Util.splitString(aSource, aOldString), aNewString);
    }

    public static final String replaceIgnoreCase(String aSource, String aOldString, String aNewString) {
        return MVDMic_Util.joinStrings(MVDMic_Util.splitStringIgnoreCase(aSource, aOldString), aNewString);
    }

    public static boolean StringToBool(String aInput) {
        try {
            if (aInput.length() == 0) {
                return false;
            }
            if ("true".equalsIgnoreCase(aInput)) {
                return true;
            }
            Integer i = new Integer(aInput);
            if (i > 0) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static String byteToHex(byte aByte) {
        return new String(MVDMic_Util.byteToHexHelper(aByte));
    }

    public static String byteToHex(byte[] aByteArray) {
        StringBuffer hex = new StringBuffer(2 * aByteArray.length);
        for (int i = 0; i < aByteArray.length; ++i) {
            hex.append(MVDMic_Util.byteToHexHelper(aByteArray[i]));
        }
        return hex.toString();
    }

    static char[] byteToHexHelper(byte aByte) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hex = new char[2];
        hex[1] = hexDigit[aByte & 0xF];
        hex[0] = hexDigit[aByte >>> 4 & 0xF];
        return hex;
    }

    public static byte[] hexToByte(String aHexString) {
        String hex = aHexString.toLowerCase();
        char[] hexChar = hex.toCharArray();
        byte[] byt = new byte[hexChar.length % 2 == 0 ? hexChar.length / 2 : hexChar.length / 2 + 1];
        for (int i = 0; i < byt.length; ++i) {
            byt[i] = 0;
        }
        int bytIndex = -1;
        int shift = 4;
        for (int i = 0; i < hexChar.length; ++i) {
            bytIndex = i % 2 == 0 ? ++bytIndex : bytIndex;
            shift = i % 2 == 0 ? 4 : 0;
            if (hexChar[i] >= '0' & hexChar[i] <= '9') {
                int n = bytIndex;
                byt[n] = (byte)(byt[n] + (hexChar[i] - 48 << shift));
                continue;
            }
            if (hexChar[i] >= 'a' & hexChar[i] <= 'f') {
                int n = bytIndex;
                byt[n] = (byte)(byt[n] + (10 + (hexChar[i] - 97) << shift));
                continue;
            }
            throw new IllegalArgumentException("Non hex character found");
        }
        return byt;
    }

    public static void WriteStringToFile(String FileName, String strToDump) {
        File f = new File(FileName);
        FileOutputStream writeFile = null;
        try {
            writeFile = new FileOutputStream(f);
            writeFile.write(strToDump.getBytes(), 0, strToDump.length());
            writeFile.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static InputStream openFileOrURL(String aLocation) throws FileNotFoundException {
        InputStream result = null;
        try {
            URL url = new URL(aLocation);
            result = url.openStream();
        }
        catch (MalformedURLException mue) {
            result = null;
        }
        catch (IOException ioe) {
            result = null;
        }
        return result;
    }

    public static String encode(String aInput) {
        try {
            String value = "x" + aInput;
            byte[] bTemp = MVDMic_Util.ToUTF8(value);
            for (int i = 0; i < bTemp.length; ++i) {
                int iTmp = bTemp[i];
                iTmp = iTmp - i % 19 + 7;
                bTemp[i] = (byte)iTmp;
            }
            bTemp[0] = (byte)(value.length() % 123 + 2);
            String s = Base64.encode(bTemp, true);
            int mod = value.length() % 62;
            if (mod > 9) {
                mod += 7;
            }
            if (mod > 42) {
                mod += 6;
            }
            byte[] bb = new byte[]{(byte)(48 + mod)};
            String t = MVDMic_Util.FromUTF8(bb);
            return "{CRYPT}" + s + t;
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException(t.toString());
        }
    }

    private static byte[] ToUTF8(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (NullPointerException p) {
            return null;
        }
        catch (Exception e) {
            return s.getBytes();
        }
    }

    private static String FromUTF8(byte[] bRes) {
        try {
            return new String(bRes, "UTF-8");
        }
        catch (NullPointerException p) {
            return null;
        }
        catch (Exception e) {
            return new String(bRes);
        }
    }

    private static class Replacer {
        String s1;
        String key;

        Replacer(String s) {
            this.s1 = s;
        }

        private int getPair(int iStart) {
            if (iStart == this.s1.length()) {
                return -1;
            }
            int i1 = this.s1.indexOf("%", iStart);
            if (i1 < 0) {
                return -1;
            }
            int i2 = this.s1.indexOf("%", i1 + 1);
            if (i2 < 0) {
                return -1;
            }
            this.key = this.s1.substring(i1 + 1, i2);
            return i2 + 1;
        }

        public String Substitute() {
            String val = "";
            HashMap<String, String> h = new HashMap<String, String>();
            int lastIndex = 0;
            while ((lastIndex = this.getPair(lastIndex)) != -1) {
                val = (String)h.get(this.key);
                if ((val == null || val.length() == 0) && this.key.length() > 0 && (val = System.getProperty(this.key)) != null && val.length() != 0) {
                    h.put(this.key, val);
                }
                if (val == null || val.length() == 0) continue;
                this.s1 = MVDMic_Util.replace(this.s1, "%" + this.key + "%", val);
            }
            return this.s1;
        }
    }
}

