/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.logging;

import com.sap.idm.vds.ie.MVDIELogger;
import com.sap.idm.vds.ie.lists.VerifierUtil;
import com.sap.idm.vds.ie.logging.DestinationCustom83;
import com.sap.idm.vds.ie.logging.DestinationIC83;
import com.sap.idm.vds.ie.logging.DestinationTXTFile83;
import com.sap.idm.vds.ie.logging.DestinationXMLFile83;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractLoggingChildren {
    private String mTopNodeName = "";
    private double mVersionPatch = 8.2;
    protected HashMap mDefaults = new HashMap();

    public AbstractLoggingChildren(String aTopNodeName) {
        this.mTopNodeName = aTopNodeName;
    }

    public AbstractLoggingChildren(String aTopNodeName, double aVersionPatch) {
        this.mTopNodeName = aTopNodeName;
        this.mVersionPatch = aVersionPatch;
    }

    public abstract void initDefaults() throws Exception;

    public String getDefault(String aKey) {
        return (String)this.mDefaults.get(aKey);
    }

    public HashMap getDefault() {
        return this.mDefaults;
    }

    public boolean init() throws Exception {
        this.initDefaults();
        VerifierUtil.createSecondLevelObject("Logging", false);
        VerifierUtil.createSubLevelObject(this.mTopNodeName, "Logging", false);
        return true;
    }

    protected abstract HashMap initDiffsByKey(String var1);

    public HashMap initDiffs(String aKey) {
        if (aKey == null || aKey.length() == 0) {
            HashMap aDiffs = new HashMap(this.mDefaults);
            return aDiffs;
        }
        return this.initDiffsByKey(aKey);
    }

    public void verifyTags() throws Exception {
        block10: {
            String outputId = "";
            String appenderValue = "";
            try {
                Document document = VerifierUtil.getDocument();
                NodeList nl = document.getElementsByTagName("MVDConfig");
                Node mc = nl.item(0);
                nl = ((Element)mc).getElementsByTagName("Logging");
                Node logc = nl.item(0);
                nl = ((Element)logc).getElementsByTagName(this.mTopNodeName);
                Node aNode = nl.item(0);
                if (aNode.getNodeType() == 3) break block10;
                try {
                    Node appendersnode;
                    if (this.mVersionPatch == 8.3 && (nl = ((Element)aNode).getElementsByTagName("Appenders")).getLength() != 0 && (appendersnode = nl.item(0)).getParentNode().getNodeName().equals(this.mTopNodeName) && (appenderValue = VerifierUtil.getTextValue(appendersnode)) == null) {
                        appenderValue = "";
                    }
                    outputId = this.mTopNodeName;
                    VerifierUtil.doTheMagic(aNode, this.initDiffs(null), null, null, outputId);
                    if (this.mVersionPatch > 8.2 && this.mVersionPatch < 8.4) {
                        String customAppender;
                        DestinationCustom83 ds83;
                        DestinationIC83 ic83;
                        DestinationXMLFile83 xml83;
                        DestinationTXTFile83 txt83 = new DestinationTXTFile83(this.mTopNodeName, appenderValue.equalsIgnoreCase("!TXT"));
                        if (txt83.init()) {
                            txt83.findAndVerifyNode();
                        }
                        if ((xml83 = new DestinationXMLFile83(this.mTopNodeName, appenderValue.equalsIgnoreCase("!XML"))).init()) {
                            xml83.findAndVerifyNode();
                        }
                        if (this.mTopNodeName.equals("Operation") && (ic83 = new DestinationIC83(this.mTopNodeName, false)).init()) {
                            ic83.findAndVerifyNode();
                        }
                        if ((ds83 = new DestinationCustom83(this.mTopNodeName, customAppender = appenderValue.toUpperCase().indexOf("!TXT") < 0 && appenderValue.toUpperCase().indexOf("!XML") < 0 ? appenderValue : "")).init()) {
                            ds83.findAndVerifyNode();
                        }
                    }
                }
                catch (Exception e) {
                    MVDIELogger.Log("Could not update <" + outputId + "> node: " + e, 2);
                }
            }
            catch (Exception e) {
                MVDIELogger.Log("Could not update <" + outputId + "> node: " + e, 2);
            }
        }
    }
}

