/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.lists;

import com.sap.idm.vds.ie.MVDIELogger;
import com.sap.idm.vds.ie.cache.Cache_Util;
import com.sap.idm.vds.ie.lists.EventActions;
import com.sap.idm.vds.ie.lists.VerifierUtil;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractTopListObject {
    private String mParentNodeName = "";
    private String mTopNodeName = "";
    private String mChildName = "";
    private String[] mIdKeys = null;
    protected HashMap mDefaults = new HashMap();

    public AbstractTopListObject(String aParentNodename, String aTopNodeName, String aChildName, String[] aIdKeys) {
        this.mParentNodeName = aParentNodename;
        this.mTopNodeName = aTopNodeName;
        this.mChildName = aChildName;
        this.mIdKeys = aIdKeys;
    }

    public abstract void initDefaults() throws Exception;

    public String getDefault(String aKey) {
        return (String)this.mDefaults.get(aKey);
    }

    public HashMap getDefault() {
        return this.mDefaults;
    }

    public boolean init() throws Exception {
        this.initDefaults();
        boolean bCreateRecord = false;
        if (this.mTopNodeName.equalsIgnoreCase("Cache") || this.mTopNodeName.equalsIgnoreCase("Proxy")) {
            bCreateRecord = true;
        }
        if (this.mParentNodeName != null) {
            VerifierUtil.createSecondLevelObject(this.mParentNodeName, false);
            VerifierUtil.createSubLevelObject(this.mTopNodeName, this.mParentNodeName, bCreateRecord);
            return true;
        }
        return VerifierUtil.createSecondLevelObject(this.mTopNodeName, bCreateRecord);
    }

    protected abstract HashMap initDiffsByKey(String var1);

    public HashMap initDiffs(String aKey) {
        HashMap aDiffs = null;
        aDiffs = aKey == null || aKey.length() == 0 ? new HashMap(this.mDefaults) : this.initDiffsByKey(aKey);
        if (this.mTopNodeName.equalsIgnoreCase("Cache")) {
            aDiffs.put("CacheDataSource", "0");
        }
        if (this.mTopNodeName.equalsIgnoreCase("Destination")) {
            aDiffs.put("log4jxml", "0");
        }
        if (this.mTopNodeName.equalsIgnoreCase("EventTriggers")) {
            aDiffs.put("Actions", "0");
        }
        if (this.mTopNodeName.equalsIgnoreCase("KeyStores")) {
            aDiffs.put("Certstore", "0");
        }
        return aDiffs;
    }

    public abstract String updateIdHash(HashMap var1);

    public void verifyTopNode() throws Exception {
        String outputId = "";
        try {
            Document document = VerifierUtil.getDocument();
            NodeList nl = document.getElementsByTagName(this.mTopNodeName);
            Node node = nl.item(0);
            if (node != null) {
                nl = ((Element)node).getElementsByTagName(this.mChildName);
                for (int i = 0; i < nl.getLength(); ++i) {
                    EventActions ea;
                    Node memberNode = nl.item(i);
                    if (memberNode == null) continue;
                    HashMap idHash = null;
                    String aKey = null;
                    if (this.mIdKeys != null) {
                        idHash = VerifierUtil.getObjectIdentification(memberNode, this.mIdKeys);
                        aKey = this.updateIdHash(idHash);
                        outputId = VerifierUtil.getOutputId(this.mChildName, idHash, this.mIdKeys);
                    } else {
                        aKey = "";
                        outputId = this.mChildName;
                    }
                    VerifierUtil.doTheMagic(memberNode, this.initDiffs(aKey), idHash, this.mIdKeys, outputId);
                    if (this.mTopNodeName.equalsIgnoreCase("Cache")) {
                        Cache_Util.verifyCacheDataSources(memberNode);
                    }
                    if (!this.mTopNodeName.equalsIgnoreCase("EventTriggers") || !(ea = new EventActions()).init()) continue;
                    ea.verifyNode(memberNode);
                }
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not update " + this.mTopNodeName + "-" + outputId + " - " + e, 2);
        }
    }
}

