/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.lists;

import com.sap.idm.vds.ie.MVDIELogger;
import com.sap.idm.vds.ie.cache.Cache_Util;
import com.sap.idm.vds.ie.lists.VerifierUtil;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDynListObject {
    private String mTopNodeName = "";
    private String mChildName = "";
    private String[] mIdKeys = null;
    protected HashMap mDefaults = new HashMap();

    public AbstractDynListObject(String aTopNodeName, String aChildName, String[] aIdKeys) {
        this.mTopNodeName = aTopNodeName;
        this.mChildName = aChildName;
        this.mIdKeys = aIdKeys;
    }

    public abstract void initDefaults() throws Exception;

    public String getDefault(String aKey) {
        return (String)this.mDefaults.get(aKey);
    }

    public HashMap getDefault() {
        return this.mDefaults;
    }

    public boolean init() throws Exception {
        this.initDefaults();
        return true;
    }

    protected abstract HashMap initDiffsByKey(String var1);

    public HashMap initDiffs(String aKey) {
        HashMap aDiffs = null;
        aDiffs = aKey == null || aKey.length() == 0 ? new HashMap(this.mDefaults) : this.initDiffsByKey(aKey);
        if (this.mTopNodeName.equalsIgnoreCase("Cache")) {
            aDiffs.put("CacheDataSource", "0");
        }
        return aDiffs;
    }

    public abstract String updateIdHash(HashMap var1);

    public void verifyNode(Node aParentNode) throws Exception {
        String outputId = "";
        try {
            NodeList nl = ((Element)aParentNode).getElementsByTagName(this.mTopNodeName);
            Node node = nl.item(0);
            if (node != null) {
                nl = ((Element)node).getElementsByTagName(this.mChildName);
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node memberNode = nl.item(i);
                    if (memberNode == null) continue;
                    HashMap idHash = null;
                    String aKey = null;
                    if (this.mIdKeys != null) {
                        idHash = VerifierUtil.getObjectIdentification(memberNode, this.mIdKeys);
                        aKey = this.updateIdHash(idHash);
                        outputId = VerifierUtil.getOutputId(this.mChildName, idHash, this.mIdKeys);
                    } else {
                        aKey = "";
                        outputId = this.mChildName;
                    }
                    VerifierUtil.doTheMagic(memberNode, this.initDiffs(aKey), idHash, this.mIdKeys, outputId);
                    if (!this.mTopNodeName.equalsIgnoreCase("Cache")) continue;
                    Cache_Util.verifyCacheDataSources(memberNode);
                }
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not update " + this.mTopNodeName + "-" + outputId + " - " + e, 2);
        }
    }
}

