/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.dsgroups;

import com.sap.idm.vds.ie.MVDIELogger;
import com.sap.idm.vds.ie.lists.VerifierUtil;
import java.util.HashMap;
import org.w3c.dom.Node;

public class Source {
    private String mBelongsTo = "";
    private HashMap mDefaults = new HashMap();

    public Source(String aGroupName) {
        this.mBelongsTo = aGroupName;
    }

    public String getDefault(String aKey) {
        return (String)this.mDefaults.get(aKey);
    }

    public HashMap getDefault() {
        return this.mDefaults;
    }

    public boolean init() throws Exception {
        this.initDefaults();
        return true;
    }

    public void initDefaults() throws Exception {
        this.mDefaults.put("IsMaster", "");
        if (this.mBelongsTo.equalsIgnoreCase("UnlinkedDataSourceGroups") || this.mBelongsTo.equalsIgnoreCase("LoadBalancingGroups") || this.mBelongsTo.equalsIgnoreCase("FailoverList")) {
            this.mDefaults.put("IsCritical", "");
        }
        this.mDefaults.put("MappingType", "");
        this.mDefaults.put("MappingID", "");
        this.mDefaults.put("Tree", "");
        this.mDefaults.put("NestedDN", "");
        this.mDefaults.put("DisplayName", "");
        this.mDefaults.put("SrcID", "");
        this.mDefaults.put("UserData", "");
    }

    private HashMap initDiffs() throws Exception {
        HashMap aDiffs = new HashMap(this.mDefaults);
        return aDiffs;
    }

    public void verifySingleNode(Node aRecordNode) throws Exception {
        String outputId = "";
        try {
            String[] idkeys = new String[]{"SrcID"};
            HashMap idHash = VerifierUtil.getObjectIdentification(aRecordNode, idkeys);
            String recID = (String)idHash.get("SrcID");
            if (recID == null || recID.length() == 0) {
                recID = "" + VerifierUtil.getLargestID();
                idHash.put("SrcID", recID);
            }
            outputId = VerifierUtil.getOutputId("Source", idHash, idkeys);
            VerifierUtil.doTheMagic(aRecordNode, this.initDiffs(), idHash, idkeys, outputId);
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not update " + outputId + " - " + e, 2);
        }
    }
}

