/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.cache;

import com.sap.idm.vds.ie.MVDIELogger;
import com.sap.idm.vds.ie.lists.VerifierUtil;
import java.util.HashMap;
import org.w3c.dom.Node;

public class CacheDataSource {
    private HashMap mDefaults = new HashMap();

    public String getDefault(String aKey) {
        return (String)this.mDefaults.get(aKey);
    }

    public HashMap getDefault() {
        return this.mDefaults;
    }

    public boolean init() throws Exception {
        this.initDefaults();
        return true;
    }

    public void initDefaults() throws Exception {
        this.mDefaults.put("datasource", "");
        this.mDefaults.put("Enabled", "FALSE");
        this.mDefaults.put("cache_base", "");
        this.mDefaults.put("ttl", "");
        this.mDefaults.put("override_attrs", "");
    }

    private HashMap initDiffs() throws Exception {
        HashMap aDiffs = new HashMap(this.mDefaults);
        return aDiffs;
    }

    public void verifySingleNode(Node aRecordNode) throws Exception {
        String outputId = "";
        try {
            String[] idkeys = new String[]{"datasource"};
            HashMap idHash = VerifierUtil.getObjectIdentification(aRecordNode, idkeys);
            String recID = (String)idHash.get("datasource");
            if (recID == null || recID.length() == 0) {
                recID = "" + VerifierUtil.getLargestID();
                idHash.put("datasource", recID);
            }
            outputId = VerifierUtil.getOutputId("CacheDataSource", idHash, idkeys);
            VerifierUtil.doTheMagic(aRecordNode, this.initDiffs(), idHash, idkeys, outputId);
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not update " + outputId + " - " + e, 2);
        }
    }
}

