/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie;

import com.sap.idm.vds.ie.Config;
import com.sap.idm.vds.ie.MVDIELogger;
import com.sap.idm.vds.ie.cache.CacheGlobal;
import com.sap.idm.vds.ie.deployments.LDAPDeployment;
import com.sap.idm.vds.ie.deployments.WSDeployment;
import com.sap.idm.vds.ie.dsgroups.DynamicAdd;
import com.sap.idm.vds.ie.dsgroups.FailoverGroup;
import com.sap.idm.vds.ie.dsgroups.Joined;
import com.sap.idm.vds.ie.dsgroups.LoadBalancingGroup;
import com.sap.idm.vds.ie.dsgroups.Provisioning;
import com.sap.idm.vds.ie.dsgroups.Unlinked;
import com.sap.idm.vds.ie.lists.Acl;
import com.sap.idm.vds.ie.lists.DataSource;
import com.sap.idm.vds.ie.lists.EventTriggers;
import com.sap.idm.vds.ie.lists.Forest;
import com.sap.idm.vds.ie.lists.KeyStore;
import com.sap.idm.vds.ie.lists.Method;
import com.sap.idm.vds.ie.lists.Proxy;
import com.sap.idm.vds.ie.lists.Rule;
import com.sap.idm.vds.ie.lists.User;
import com.sap.idm.vds.ie.lists.UserGroup;
import com.sap.idm.vds.ie.lists.VerifierUtil;
import com.sap.idm.vds.ie.logging.Appender;
import com.sap.idm.vds.ie.logging.AuditLog;
import com.sap.idm.vds.ie.logging.AuditLog83;
import com.sap.idm.vds.ie.logging.AuditLogSAP;
import com.sap.idm.vds.ie.logging.OperationLog;
import com.sap.idm.vds.ie.logging.OperationLog83;
import com.sap.idm.vds.ie.logging.OperationLogSAP;
import com.sap.idm.vds.ie.logging.PerformanceLog;
import com.sap.idm.vds.ie.logging.SNMPLog;
import com.sap.idm.vds.ie.logging.Statistics;
import com.sap.idm.vds.ie.logging.Statistics83;
import com.sap.idm.vds.ie.logging.StatisticsSAP;
import com.sap.idm.vds.ie.single.Queue;
import com.sap.idm.vds.ie.util.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Document;

public class VerifyMVDConf {
    public static final String READ_AUTH_UPGRADE_TUTORIAL = "EXTAUTH";
    public static final String SOMTHING_ELSE = "NOTYET";
    private static double mConfigVersion = 0.0;
    private static String mPropertyFile = null;
    private static String mXmlConfigFileName;
    private static String mConfigName;
    private static boolean mIsTemplate;
    private static String mTemplateType;
    public static final String HIGHEST_VERIFIER_VERSION = "8.4";
    public static final String LOWEST_VERIFIER_VERSION = "8.2";
    public static final double[] mVerifyingSteps;

    private static final void printVersion(boolean aLongVersion, boolean sys) {
        String sMajorVersion = "1";
        String sMinorVersion = "0";
        String sBuildInfo = "0";
        Date myDate = new Date();
        String BUILDDATE = DateFormat.getDateInstance(3).format(myDate);
        String BUILDTIME = DateFormat.getTimeInstance().format(myDate);
        String COPYRIGHT = "MaXware 2006";
        String result = " Version: " + sMajorVersion + "." + sMinorVersion + "." + sBuildInfo + "  Built: " + BUILDDATE + " " + BUILDTIME + " Copyright: " + COPYRIGHT;
        if (sys) {
            System.out.println(result);
        } else {
            MVDIELogger.Log(result, 1);
        }
    }

    private static void usage() {
        System.out.println("-----------------------------------------------------------------------------------------");
        System.out.println("USAGE:");
        System.out.println("  VerifyDB  -version");
        System.out.println("     or");
        System.out.println("  VerifyDB options ");
        System.out.println("        In this case, all of the mandatory parameters have to be supplied");
        System.out.println("        (See 'options' below)");
        System.out.println("     or");
        System.out.println("  VerifyDB PROPFILE=<file> [options]");
        System.out.println("        In this case, options can be ANY subset of parameters described below.");
        System.out.println("        These settings override the values given by PROPFILE parameter");
        System.out.println("");
        System.out.println("  options:");
        System.out.println("        INPUTCONFIG=<Full path pf XML file to be written to MIC>");
        System.out.println("        TEMPLATE=<1 if the input file is a Template file, 0 otherwises>");
        System.out.println("----------------------------------------------------------------------------------------");
    }

    private static void Verify(Config aConfig) throws Exception {
        Document doc = aConfig.getDoc();
        VerifyMVDConf.Verify(doc);
    }

    private static void Verify(Document doc) throws Exception {
        VerifierUtil.setDocument(doc);
        VerifierUtil.checkMVDConfigRoot();
        VerifierUtil.setLargestID(null, "ID");
        try {
            for (int ix = 0; ix < mVerifyingSteps.length; ++ix) {
                if (mConfigVersion > mVerifyingSteps[ix]) continue;
                VerifyMVDConf.verifyMVDConfiguration(mVerifyingSteps[ix]);
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Verifying MVD configuration failed : " + e.toString(), 2);
            throw new Exception(e);
        }
    }

    private static void verifyMVDConfiguration(double verifyingLevel) throws Exception {
        if (mConfigName == null || mConfigName.length() == 0) {
            MVDIELogger.Log("Beginning verifying process of the Virtual Directory Server configuration (LEVEL:" + verifyingLevel + ")", 1);
        } else {
            MVDIELogger.Log("Beginning verifying process of the Virtual Directory Server configuration (NAME:" + mConfigName + ", LEVEL:" + verifyingLevel + ")", 1);
        }
        if (verifyingLevel == 8.2) {
            SNMPLog sn;
            AuditLog au;
            PerformanceLog perf;
            Statistics sta;
            OperationLog oro;
            Appender apr;
            MVDIELogger.Log("Verifying ACL configuration", 1);
            Acl acl = new Acl();
            if (acl.init()) {
                acl.verifyACLTags();
            }
            MVDIELogger.Log("Verifying joined group configuration", 1);
            Joined j = new Joined();
            if (j.init()) {
                j.findAndVerifyTopNode(null);
            }
            MVDIELogger.Log("Verifying dynamic add group configuration", 1);
            DynamicAdd dad = new DynamicAdd();
            if (dad.init()) {
                dad.findAndVerifyTopNode(null);
            }
            MVDIELogger.Log("Verifying unlinked group configuration", 1);
            Unlinked u = new Unlinked();
            if (u.init()) {
                u.findAndVerifyTopNode(null);
            }
            MVDIELogger.Log("Verifying provisioning group configuration", 1);
            Provisioning p = new Provisioning();
            if (p.init()) {
                p.findAndVerifyTopNode(null);
            }
            MVDIELogger.Log("Verifying load balacing group configuration", 1);
            LoadBalancingGroup loa = new LoadBalancingGroup();
            if (loa.init()) {
                loa.findAndVerifyTopNode(null);
            }
            MVDIELogger.Log("Verifying failover group configuration", 1);
            FailoverGroup fa = new FailoverGroup();
            if (fa.init()) {
                fa.findAndVerifyTopNode(null);
            }
            MVDIELogger.Log("Verifying data sources configuration", 1);
            DataSource ds = new DataSource();
            if (ds.init()) {
                ds.verifyTopNode();
            }
            MVDIELogger.Log("Verifying forest configuration", 1);
            Forest fs = new Forest();
            if (fs.init()) {
                fs.verifyTopNode();
            }
            if ((apr = new Appender()).init()) {
                apr.verifyTopNode();
            }
            if ((oro = new OperationLog()).init()) {
                oro.verifyTags();
            }
            if ((sta = new Statistics()).init()) {
                sta.verifyTags();
            }
            if ((perf = new PerformanceLog()).init()) {
                perf.verifyTags();
            }
            if ((au = new AuditLog()).init()) {
                au.verifyTags();
            }
            if ((sn = new SNMPLog()).init()) {
                sn.verifyTags();
            }
            MVDIELogger.Log("Verifying Keystore configuration", 1);
            KeyStore ks = new KeyStore();
            if (ks.init()) {
                ks.verifyTopNode();
            }
            MVDIELogger.Log("Verifying LDAP deployments configuration", 1);
            LDAPDeployment ldp = new LDAPDeployment();
            if (ldp.init()) {
                ldp.verifyTopNode();
            }
            MVDIELogger.Log("Verifying WS deployments configuration", 1);
            WSDeployment wsd = new WSDeployment();
            if (wsd.init()) {
                wsd.verifyTopNode();
            }
            MVDIELogger.Log("Verifying proxy configuration", 1);
            Proxy pr = new Proxy();
            if (pr.init()) {
                pr.verifyTopNode();
            }
            MVDIELogger.Log("Verifying rule configuration", 1);
            Rule rl = new Rule();
            if (rl.init()) {
                rl.verifyTopNode();
            }
            MVDIELogger.Log("Verifying method configuration", 1);
            Method mtd = new Method();
            if (mtd.init()) {
                mtd.verifyTopNode();
            }
            MVDIELogger.Log("Verifying usergroups configuration", 1);
            UserGroup ug = new UserGroup();
            if (ug.init()) {
                ug.verifyTopNode();
            }
            MVDIELogger.Log("Verifying user configuration", 1);
            User usr = new User();
            if (usr.init()) {
                usr.verifyTopNode();
            }
            MVDIELogger.Log("Verifying cache configuration", 1);
            CacheGlobal cgb = new CacheGlobal();
            if (cgb.init()) {
                cgb.verifyTopNode();
            }
            MVDIELogger.Log("Verifying event triggers", 1);
            EventTriggers etr = new EventTriggers();
            if (etr.init()) {
                etr.verifyTopNode();
            }
            MVDIELogger.Log("Verifying request queue configuration", 1);
            Queue qu = new Queue();
            if (qu.init()) {
                qu.findAndVerifyNode();
            }
        } else if (verifyingLevel == 8.3) {
            Appender apr;
            AuditLog83 au;
            Statistics83 sta;
            OperationLog83 oro = new OperationLog83();
            if (oro.init()) {
                oro.verifyTags();
            }
            if ((sta = new Statistics83()).init()) {
                sta.verifyTags();
            }
            if ((au = new AuditLog83()).init()) {
                au.verifyTags();
            }
            if ((apr = new Appender()).init()) {
                apr.verifyTopNode();
            }
            MVDIELogger.Log("Verifying proxy configuration", 1);
            Proxy pr = new Proxy();
            if (pr.init()) {
                pr.verifyTopNode();
            }
        } else if (verifyingLevel == 8.4) {
            StatisticsSAP sta;
            AuditLogSAP au;
            OperationLogSAP oro = new OperationLogSAP();
            if (oro.init()) {
                oro.verifyTags();
            }
            if ((au = new AuditLogSAP()).init()) {
                au.verifyTags();
            }
            if ((sta = new StatisticsSAP()).init()) {
                sta.verifyTags();
            }
            MVDIELogger.Log("Verifying proxy configuration", 1);
            Proxy pr = new Proxy();
            if (pr.init()) {
                pr.verifyTopNode();
            }
        }
        if (mConfigName == null || mConfigName.length() == 0) {
            MVDIELogger.Log("Ended verifying process of Virtual Directory Server configuration (LEVEL:" + verifyingLevel + ")", 1);
        } else {
            MVDIELogger.Log("Ended verifying process of Virtual Directory Server configuration (NAME:" + mConfigName + ", LEVEL:" + verifyingLevel + ")", 1);
        }
    }

    private static void fetchProperties(String propFile) throws Exception {
        Properties defaultProps = new Properties();
        try {
            String tmpStr;
            String field;
            FileInputStream in = new FileInputStream(propFile);
            defaultProps.load(in);
            in.close();
            if (mXmlConfigFileName == null) {
                field = "INPUTCONFIG";
                tmpStr = defaultProps.getProperty(field, "");
                if ((tmpStr = tmpStr.trim()) == null || tmpStr.length() == 0) {
                    MVDIELogger.Log("Missing field:" + field + " in the property file", 2);
                }
                mXmlConfigFileName = tmpStr.toUpperCase();
            }
            field = "TEMPLATE";
            tmpStr = defaultProps.getProperty(field, "");
            if ((tmpStr = tmpStr.trim()) == null || tmpStr.length() == 0) {
                MVDIELogger.Log("Missing field:" + field + " in the property file", 2);
            }
            if (!tmpStr.equalsIgnoreCase("0") && !tmpStr.equalsIgnoreCase("1")) {
                MVDIELogger.Log("Field:" + field + " in the property file is invalid", 2);
            }
            mIsTemplate = tmpStr.equalsIgnoreCase("1");
        }
        catch (Exception e) {
            MVDIELogger.Log("Error reading property file : " + propFile + " : " + e.toString(), 2);
            throw e;
        }
    }

    public static void main(String[] args) {
        try {
            VerifyMVDConf.execute(args);
        }
        catch (Exception e) {
            MVDIELogger.Log(e.getMessage(), 2);
            System.exit(1);
        }
        System.exit(0);
    }

    public static Vector execute(Document aDOMConfig) {
        Vector retVector = null;
        try {
            retVector = VerifyMVDConf.execute(aDOMConfig, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVector;
    }

    public static Vector execute(Document aDOMConfig, boolean aVerbose) throws Exception {
        if (aVerbose) {
            MVDIELogger.setLevel(1);
        } else {
            MVDIELogger.setLevel(3);
        }
        Vector<Object> retVector = new Vector<Object>();
        String domHasChanged = System.setProperty("DOM_HAS_CHANGED", "0");
        if (aDOMConfig == null) {
            retVector.add(Boolean.FALSE);
            retVector.add(aDOMConfig);
            return retVector;
        }
        try {
            String message = "";
            if (!VerifyMVDConf.checkConfigVersion(aDOMConfig)) {
                retVector.add("-2");
                message = "This configuration file can not be upgraded to the latest version directly.";
                message = message + "\n\nYou should first execute the following command:";
                message = message + "\njava -jar lib\\confupgrade.jar <oldfile> <newfile>";
                message = message + "\nand then open the result file in the GUI";
                retVector.add(VerifierUtil.getDocument());
                retVector.add(message);
                return retVector;
            }
            VerifyMVDConf.Verify(aDOMConfig);
            domHasChanged = System.getProperty("DOM_HAS_CHANGED");
            if (domHasChanged.equalsIgnoreCase("1")) {
                retVector.add("-1");
                message = "Verifier has changed the configuration.";
            } else {
                retVector.add("0");
            }
            retVector.add(VerifierUtil.getDocument());
            retVector.add(message);
            retVector.add(VerifierUtil.getChangeMessages());
            retVector.add(VerifierUtil.getImportanceFlag());
        }
        catch (Exception e) {
            MVDIELogger.Log("Error while verifying configuration:" + e.toString(), 2);
        }
        return retVector;
    }

    private static boolean checkConfigVersion(Config aXMLConfig) throws Exception {
        Document document = aXMLConfig.getDoc();
        return VerifyMVDConf.checkConfigVersion(document);
    }

    private static boolean checkConfigVersion(Document document) throws Exception {
        double lowestVersion;
        double dVersion;
        String version = document.getDocumentElement().getAttribute("version");
        if (version == null || version.equals("")) {
            version = document.getDocumentElement().getAttribute("Version");
        }
        if ((dVersion = Double.parseDouble(version)) < (lowestVersion = Double.parseDouble(LOWEST_VERIFIER_VERSION))) {
            return false;
        }
        mConfigVersion = dVersion;
        return true;
    }

    private static void execute(String[] args) throws Exception {
        String tmpStr;
        String domHasChanged = System.setProperty("DOM_HAS_CHANGED", "0");
        String commandArgument = "";
        String commandKey = "";
        if (args.length == 0) {
            VerifyMVDConf.usage();
            System.exit(0);
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("-version")) {
            VerifyMVDConf.printVersion(true, true);
            System.exit(0);
        }
        if (args.length < 2 && !(tmpStr = args[0].toUpperCase()).toUpperCase().startsWith("PROPFILE")) {
            VerifyMVDConf.usage();
            System.exit(0);
        }
        VerifyMVDConf.printVersion(true, false);
        boolean hasTemplateVar = false;
        String tmpStr2 = "";
        for (int x = 0; x < args.length; ++x) {
            commandArgument = args[x];
            int iHelp = commandArgument.indexOf("=");
            if (iHelp < 0) continue;
            commandKey = commandArgument.substring(0, iHelp);
            if ((commandKey = commandKey.toUpperCase()).equalsIgnoreCase("PROPFILE")) {
                mPropertyFile = commandArgument.substring(iHelp + 1);
                continue;
            }
            if (commandKey.equalsIgnoreCase("INPUTCONFIG")) {
                mXmlConfigFileName = commandArgument.substring(iHelp + 1);
                continue;
            }
            if (commandKey.equalsIgnoreCase("TEMPLATE")) {
                mIsTemplate = commandArgument.substring(iHelp + 1).equalsIgnoreCase("1");
                hasTemplateVar = true;
                continue;
            }
            VerifyMVDConf.usage();
            MVDIELogger.Log("Missing delimiter on command line", 2);
        }
        if (mPropertyFile != null && mPropertyFile.length() > 0) {
            VerifyMVDConf.fetchProperties(mPropertyFile);
        }
        String field = "INPUTCONFIG";
        tmpStr2 = mXmlConfigFileName;
        if (tmpStr2 == null || tmpStr2.length() == 0) {
            MVDIELogger.Log("Missing field:" + field, 2);
        }
        String strXmlFileName = "empty";
        try {
            strXmlFileName = mXmlConfigFileName;
            if (mConfigName == null) {
                mConfigName = strXmlFileName.substring(strXmlFileName.lastIndexOf("\\") + 1, strXmlFileName.lastIndexOf("."));
            }
            Config xmlConf = null;
            if (strXmlFileName != null) {
                File configFile = new File(strXmlFileName);
                if (configFile == null || !configFile.exists()) {
                    MVDIELogger.Log("Can not find config file:" + strXmlFileName, 2);
                } else {
                    xmlConf = new Config(configFile);
                }
            }
            Document doc = xmlConf.getDoc();
            VerifyMVDConf.execute(doc);
            domHasChanged = System.getProperty("DOM_HAS_CHANGED");
            if (domHasChanged.equalsIgnoreCase("1")) {
                XMLUtil.WriteXMLtoFile(xmlConf.getDoc(), mXmlConfigFileName);
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Error while verifying configuration:" + strXmlFileName + ":" + e.toString(), 2);
            throw e;
        }
    }

    static {
        mIsTemplate = false;
        mTemplateType = null;
        mVerifyingSteps = new double[]{8.2, 8.3, 8.4};
    }
}

