/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.op.db;

import com.sap.idm.vds.ie.op.common.AbstractReader;
import com.sap.idm.vds.ie.op.common.Config;
import com.sap.idm.vds.ie.op.common.MVDIELogger;
import com.sap.idm.vds.ie.op.common.util.DBUtil;
import com.sap.idm.vds.ie.op.db.DBConfig;
import java.sql.Connection;
import java.util.Properties;

public class vdsReadDB
extends AbstractReader {
    private long mLastChangeNumber = -1L;
    private String mJdbcDriver = null;
    private Connection mConnection = null;
    private String mConfigName = null;
    private String mConnectionString = null;

    public void usage() {
        System.out.println("-----------------------------------------------------------------------------------------");
        System.out.println("USAGE:");
        System.out.println("  ReadDB  -version");
        System.out.println("     or");
        System.out.println("  ReadDB options OPER=<get|compile|start>");
        System.out.println("        (See 'options' below)");
        System.out.println("  options:");
        System.out.println("        [JDKHOME=<Path to Java SDK>]");
        System.out.println("        JDBCURL=<Connection string>");
        System.out.println("        DRIVER=<JDBC driver>");
        System.out.println("        DBCFG=<The name of the MVD configuration in the database>");
        System.out.println("        OUTPUTCONFIG=<Full path to XML file to be created>");
        System.out.println("        [LOGLEVEL=<Log level: None=3, Error=2, Normal=1, Debug=0>]");
        System.out.println("----------------------------------------------------------------------------------------");
    }

    public void fetchSpecificProperties(Properties defaultProps) {
        try {
            String tmpStr;
            String field;
            if (this.mConnectionString == null) {
                field = "JDBCURL";
                tmpStr = defaultProps.getProperty(field, "");
                if ((tmpStr = tmpStr.trim()) == null || tmpStr.length() == 0) {
                    MVDIELogger.Log("Missing field:" + field + " in the property file", 2);
                }
                this.mConnectionString = tmpStr;
            }
            if (this.mConfigName == null) {
                field = "DBCFG";
                tmpStr = defaultProps.getProperty(field, "");
                if ((tmpStr = tmpStr.trim()) == null || tmpStr.length() == 0) {
                    MVDIELogger.Log("Missing field:" + field + " in the property file", 2);
                }
                this.mConfigName = tmpStr;
            }
            if (this.mJdbcDriver == null) {
                field = "DRIVER";
                tmpStr = defaultProps.getProperty(field, "");
                if ((tmpStr = tmpStr.trim()) == null || tmpStr.length() == 0) {
                    MVDIELogger.Log("Missing field:" + field + " in the property file", 2);
                }
                this.mJdbcDriver = tmpStr;
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Error reading specific properties :" + e.toString(), 2);
        }
    }

    public void sanitySpecificCheck() {
        String field = "JDBCURL";
        String tmpStr = this.mConnectionString;
        if (tmpStr == null || tmpStr.length() == 0) {
            MVDIELogger.Log("Missing field:" + field, 2);
        }
        field = "DRIVER";
        tmpStr = this.mJdbcDriver;
        if (tmpStr == null || tmpStr.length() == 0) {
            MVDIELogger.Log("Missing field:" + field, 2);
        }
        field = "DBCFG";
        tmpStr = this.mConfigName;
        if (tmpStr == null || tmpStr.length() == 0) {
            MVDIELogger.Log("Missing field:" + field, 2);
        }
    }

    public void load(boolean firstload) throws Exception {
        try {
            if (firstload) {
                this.mConnection = DBUtil.initConnection(this.mConnectionString, this.mJdbcDriver);
                DBConfig dc = DBUtil.getConfigurationByConfigName(this.mConnection, this.mConfigName, "0");
                this.mLastChangeNumber = Integer.parseInt(dc.getVersion());
                this.Read(new Config(dc.getDoc()));
            } else {
                String version = DBUtil.getConfigurationVersion(this.mConnection, this.mConfigName);
                long dbcfgmodified = Integer.parseInt(version);
                if (this.mLastChangeNumber < dbcfgmodified) {
                    DBConfig dc = DBUtil.getConfigurationByConfigName(this.mConnection, this.mConfigName, "0");
                    this.Read(new Config(dc.getDoc()));
                    this.mLastChangeNumber = Integer.parseInt(dc.getVersion());
                }
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Error while importing configuration: " + e.getMessage(), 2);
        }
    }

    public void execute(String[] args, boolean aDoExitOnFatalError) throws Exception {
        String commandArgument = "";
        String commandKey = "";
        if (args.length == 0) {
            this.usage();
            throw new Exception("Invalid arguments");
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("-version")) {
            this.printVersion(true);
            return;
        }
        this.printVersion(true);
        for (int x = 0; x < args.length; ++x) {
            commandArgument = args[x];
            int iHelp = commandArgument.indexOf("=");
            if (iHelp >= 0) {
                commandKey = commandArgument.substring(0, iHelp);
                if ((commandKey = commandKey.toUpperCase()).equalsIgnoreCase("OUTPUTCONFIG")) {
                    this.mXmlConfigFileName = commandArgument.substring(iHelp + 1);
                    continue;
                }
                if (commandKey.equalsIgnoreCase("JDBCURL")) {
                    this.mConnectionString = commandArgument.substring(iHelp + 1);
                    continue;
                }
                if (commandKey.equalsIgnoreCase("OPER")) {
                    this.setOperType(commandArgument.substring(iHelp + 1));
                    continue;
                }
                if (commandKey.equalsIgnoreCase("DBCFG")) {
                    this.mConfigName = commandArgument.substring(iHelp + 1);
                    continue;
                }
                if (commandKey.equalsIgnoreCase("DRIVER")) {
                    this.mJdbcDriver = commandArgument.substring(iHelp + 1);
                    continue;
                }
                if (commandKey.equalsIgnoreCase("JDKHOME")) {
                    this.setJdkHome(commandArgument.substring(iHelp + 1));
                    continue;
                }
                if (commandKey.equalsIgnoreCase("LOGLEVEL")) {
                    MVDIELogger.setLevel(Integer.parseInt(commandArgument.substring(iHelp + 1)));
                    continue;
                }
                this.usage();
                MVDIELogger.Log("Unknown command:" + commandKey, 2);
                continue;
            }
            this.usage();
            MVDIELogger.Log("Missing delimiter on command line", 2);
        }
        this.sanityCheck();
        try {
            this.load(true);
        }
        catch (Exception e) {
            MVDIELogger.Log("Error while importing configuration:" + this.mXmlConfigFileName + ":" + e.toString(), 2);
        }
    }

    public static void main(String[] args) throws Exception {
        vdsReadDB rdb = new vdsReadDB();
        rdb.execute(args, true);
        System.exit(0);
    }
}

