/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.op.common.util;

import com.sap.tc.logging.Location;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MD5 {
    private static Location sLogger = Location.getLocation((String)"com.sap.idm.vds.tools");
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    private MD5() {
    }

    private static String byteToHex(byte[] aArray, int aOffset, int aLength) {
        char[] buf = new char[aLength * 2];
        int i = 0;
        int j = 0;
        while (i < aLength) {
            byte k = aArray[aOffset + i++];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static String getHash(String aSource) {
        byte[] src;
        if (aSource == null) {
            return null;
        }
        try {
            src = aSource.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            src = aSource.getBytes();
        }
        byte[] tmp = MD5.getMD5Bytes(src);
        if (tmp != null) {
            return MD5.byteToHex(tmp, 0, tmp.length);
        }
        return null;
    }

    public static byte[] getMD5Bytes(byte[] aBytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(aBytes);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            sLogger.errorT("JVM does not provide MD5 algorithm:" + e);
            return null;
        }
    }

    public static String getDoubleHash(String aSource) {
        String pwHashString = MD5.getHash(aSource);
        return MD5.getHash(pwHashString);
    }
}

