/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.op.common.util;

import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCShimDriver
implements Driver {
    private Driver mDriver;

    JDBCShimDriver(Driver aDriver) {
        this.mDriver = aDriver;
    }

    public boolean acceptsURL(String aUrl) throws SQLException {
        return this.mDriver.acceptsURL(aUrl);
    }

    public Connection connect(String aUrl, Properties aProperties) throws SQLException {
        return this.mDriver.connect(aUrl, aProperties);
    }

    public int getMajorVersion() {
        return this.mDriver.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.mDriver.getMinorVersion();
    }

    public DriverPropertyInfo[] getPropertyInfo(String aUrl, Properties aProperties) throws SQLException {
        return this.mDriver.getPropertyInfo(aUrl, aProperties);
    }

    public boolean jdbcCompliant() {
        return this.mDriver.jdbcCompliant();
    }

    public Driver getDriver() {
        return this.mDriver;
    }

    public static void registerDriver(String aDriverName, ClassLoader aClassLoader, PrintStream aErrOut) throws Exception {
        Class<?> driverClass = null;
        if (aDriverName == null || aDriverName.trim().equals("")) {
            throw new Exception("No drivername given.");
        }
        try {
            driverClass = aClassLoader == null ? Class.forName(aDriverName) : Class.forName(aDriverName, true, aClassLoader);
        }
        catch (ClassNotFoundException cnfe) {
            driverClass = null;
        }
        if (driverClass == null) {
            if (aErrOut != null) {
                if (aClassLoader instanceof URLClassLoader) {
                    aErrOut.println("Could not load " + aDriverName + " using URLClassLoader with the folowing URLS");
                    URL[] urls = ((URLClassLoader)aClassLoader).getURLs();
                    for (int ii = 0; ii < urls.length; ++ii) {
                        aErrOut.println("  -  " + urls[ii].toString());
                    }
                } else {
                    aErrOut.println("Could not load " + aDriverName);
                }
            }
            throw new Exception("Could not load " + aDriverName);
        }
        try {
            Driver jsqld = (Driver)driverClass.newInstance();
            DriverManager.registerDriver(new JDBCShimDriver(jsqld));
        }
        catch (SQLException se) {
            if (aErrOut != null) {
                aErrOut.println("Exception registering JDBC driver " + aDriverName + " - " + se.toString());
            }
            throw new Exception("Exception registering JDBC driver " + aDriverName + " - " + se.toString());
        }
        catch (InstantiationException ie) {
            if (aErrOut != null) {
                aErrOut.println("Exception instantiating JDBC driver " + aDriverName + " - " + ie.toString());
            }
            throw new Exception("Exception instantiating JDBC driver " + aDriverName + " - " + ie.toString());
        }
        catch (IllegalAccessException iae) {
            if (aErrOut != null) {
                aErrOut.println("Exception instantiating JDBC driver " + aDriverName + " - " + iae.toString());
            }
            throw new Exception("Exception instantiating JDBC driver " + aDriverName + " - " + iae.toString());
        }
    }
}

