/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.op.common;

import com.sap.idm.vds.ie.VerifyMVDConf;
import com.sap.idm.vds.ie.op.common.MVDIELogger;
import com.sap.idm.vds.ie.op.common.util.MVDMic_Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class Config {
    private Document mDoc = null;
    private DocumentBuilder dBuilder;
    private File mFile = null;

    public Document getDoc() {
        return this.mDoc;
    }

    public Config(URL url) throws Exception {
        this(url.openStream());
    }

    public Config(File file) {
        if (!file.exists()) {
            MVDIELogger.Log("File doesn't exist:" + file, 2);
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.dBuilder = dbf.newDocumentBuilder();
            this.mFile = file;
            this.mDoc = this.dBuilder.parse(this.mFile);
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not parse xml file : " + file + " : " + e.toString(), 2);
        }
    }

    public Config(InputStream Stream2) {
        try {
            byte[] data = MVDMic_Util.readFile(Stream2);
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.dBuilder = dbf.newDocumentBuilder();
            this.mDoc = this.dBuilder.parse(bis);
            Vector vec = VerifyMVDConf.execute((Document)this.mDoc, (boolean)true);
            int status = Integer.parseInt((String)vec.elementAt(0));
            if (status == -1) {
                System.out.println("VERIFY CHANGED THE DOCUMENT!!!");
            } else if (status == -2) {
                System.out.println("The version read is NEWER than the one we are prepared for");
            }
        }
        catch (Exception e) {
            MVDIELogger.Log("Could not obtain document form stream : " + e.toString(), 2);
        }
    }

    public Config(Document aDocument) throws Exception {
        Vector vec = VerifyMVDConf.execute((Document)aDocument, (boolean)true);
        int status = Integer.parseInt((String)vec.elementAt(0));
        if (status == -1) {
            System.out.println("VERIFY CHANGED THE DOCUMENT!!!");
        } else if (status == -2) {
            System.out.println("The version read is NEWER than the one we are prepared for");
        }
        this.mDoc = aDocument;
    }
}

