/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ie.op.common;

import com.sap.idm.vds.ie.op.common.Config;
import com.sap.idm.vds.ie.op.common.MVDIELogger;
import com.sap.idm.vds.ie.op.common.Method;
import com.sap.idm.vds.ie.op.common.util.CompileUtil;
import com.sap.idm.vds.ie.op.common.util.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.w3c.dom.Document;

public abstract class AbstractReader {
    protected static int GET_CONFIG = 1;
    protected static int COMPILE_CONFIG = 2;
    protected static int START_CONFIG = 3;
    protected static String OPER_GET_CONFIG = "GET";
    protected static String OPER_COMPILE_CONFIG = "COMPILE";
    protected static String OPER_START_CONFIG = "START";
    protected static String JDKHOME = "JDKHOME";
    private static String mJdkHome = null;
    private Properties mProperties = null;
    private int mOperType = GET_CONFIG;
    protected String mPropertyFile = null;
    protected String mXmlConfigFileName = null;

    protected void setJdkHome(String s) {
        mJdkHome = s;
    }

    public static String getJdkHome() {
        if (mJdkHome != null) {
            return mJdkHome;
        }
        String systemJDKHOME = System.getProperty("JDK_HOME");
        return systemJDKHOME;
    }

    protected void setOperType(String s) {
        this.mOperType = s.toUpperCase().equals(OPER_GET_CONFIG) ? GET_CONFIG : (s.toUpperCase().equals(OPER_COMPILE_CONFIG) ? COMPILE_CONFIG : START_CONFIG);
    }

    public String getXmlConfigFileName() {
        return this.mXmlConfigFileName;
    }

    public void loadPropertyFile(String aPropFileName) throws IOException {
        File propFile = new File(aPropFileName);
        if (!propFile.exists()) {
            throw new IOException("Cannot find the properties file: " + aPropFileName);
        }
        if (this.mProperties == null) {
            this.mProperties = new Properties();
        }
        Properties temp = new Properties();
        temp.load(new FileInputStream(propFile));
        Iterator<Object> i = temp.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next().toString();
            String value = temp.getProperty(key);
            Object v = this.mProperties.get(key);
            if (v != null) continue;
            if (key.equalsIgnoreCase(JDKHOME) && value != null && value.length() != 0) {
                this.setJdkHome(value);
            }
            this.mProperties.put(key, value);
        }
        this.fetchSpecificProperties(this.mProperties);
    }

    protected void sanityCheck() {
        String field = "OUTPUTCONFIG";
        String tmpStr = this.mXmlConfigFileName;
        if (tmpStr == null || tmpStr.length() == 0) {
            MVDIELogger.Log("Missing field:" + field, 2);
        }
        this.sanitySpecificCheck();
    }

    protected final void printVersion(boolean aLongVersion) {
        String sMajorVersion = "1";
        String sMinorVersion = "0";
        String sBuildInfo = "0";
        Date myDate = new Date();
        String BUILDDATE = DateFormat.getDateInstance(3).format(myDate);
        String BUILDTIME = DateFormat.getTimeInstance().format(myDate);
        String COPYRIGHT = "MaXware 2004";
        String result = " Version: " + sMajorVersion + "." + sMinorVersion + "." + sBuildInfo + "  Built: " + BUILDDATE + " " + BUILDTIME + " Copyright: " + COPYRIGHT;
        MVDIELogger.Log(result, 1);
    }

    protected void Read(Config config) {
        Document doc = config.getDoc();
        try {
            if (this.mOperType == COMPILE_CONFIG || this.mOperType == START_CONFIG) {
                Method.init(doc);
                if (CompileUtil.isCompileEnabled()) {
                    Method.compileMethods(this);
                } else {
                    MVDIELogger.Log("Either JDK_HOME must be defined or proper tools.jar must be in classpath", 2);
                }
            }
            XMLUtil.WriteXMLtoFile(doc, this.mXmlConfigFileName);
        }
        catch (Exception e) {
            MVDIELogger.Log("Processing MVD configuration failed : " + e, 2);
        }
    }

    public abstract void fetchSpecificProperties(Properties var1);

    public abstract void sanitySpecificCheck();

    public abstract void usage();

    public abstract void load(boolean var1) throws Exception;

    public abstract void execute(String[] var1, boolean var2) throws Exception;
}

