/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.tools.lv;

import com.sap.tc.logging.tools.lv.LVFormatOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

class LVFormatPattern {
    public static final int OPT_MIN = 0;
    public static final int OPT_DATE = 1;
    public static final int OPT_TIME = 2;
    public static final int OPT_SEVERITY = 3;
    public static final int OPT_GUID = 4;
    public static final int OPT_LOCATION = 5;
    public static final int OPT_CATEGORY = 6;
    public static final int OPT_MESSAGE = 7;
    public static final int OPT_MAX = 8;
    private static final String DEFAULT_FORMAT = "%d %t %s %m";
    private static final int DEF_MESSAGE_WIDTH = -1;
    private static final int DEF_DATE_WIDTH = 10;
    private static final int DEF_TIME_WIDTH = 12;
    private static final int DEF_SEVERITY_WIDTH = 8;
    private static final int DEF_GUID_WIDTH = 35;
    private static final int DEF_LOCATION_WIDTH = 35;
    private static final int DEF_CATEGORY_WIDTH = 35;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_RIGHT = 3;
    public static List parsedOptions;
    public static String help;
    static HashMap formatOptions;

    public LVFormatPattern(String pattern) {
        this.parse(pattern);
    }

    private void parse(String pattern) {
        StringBuffer buf = new StringBuffer(pattern);
        int patternLen = pattern.length();
        char curVal = '\u0000';
        parsedOptions = new LinkedList();
        int i = 0;
        while (i < patternLen) {
            switch (buf.charAt(i)) {
                case '%': {
                    String key = String.valueOf(buf.charAt(i + 1)).toUpperCase();
                    if (!formatOptions.containsKey(key)) break;
                    LVFormatOption formatOpt = (LVFormatOption)formatOptions.get(key);
                    formatOpt.isEnabled = true;
                    if (buf.length() > ++i + 1 && buf.charAt(i + 1) == '[') {
                        switch (buf.charAt(i + 2)) {
                            case 'l': {
                                formatOpt.align = 1;
                                break;
                            }
                            case 'c': {
                                formatOpt.align = 2;
                                break;
                            }
                            case 'r': {
                                formatOpt.align = 3;
                            }
                        }
                        i += 2;
                    }
                    if (buf.length() > i + 1 && buf.charAt(i + 1) == ',') {
                        StringBuffer digit = new StringBuffer();
                        int index = 0;
                        index = i + 2;
                        while (index < patternLen) {
                            curVal = buf.charAt(index);
                            if (curVal == ']') break;
                            if (Character.isDigit(curVal)) {
                                digit.append(curVal);
                            }
                            ++index;
                        }
                        if (index > i + 2) {
                            formatOpt.width = Integer.parseInt(digit.toString());
                        }
                        i = index;
                    }
                    parsedOptions.add(formatOpt);
                }
            }
            ++i;
        }
    }

    static {
        help = "Format options:\n  -format <format pattern>\n   With this option the format of a message can be customized\n   Default pattern = %d %t %s %m\n   Format pattern elements:\n    %m[a,n]\n     print the message\n     <a> is the alignment. \n       <l>eft, <c>enter, <r>ight - default is <l>eft\n     <n> is the maximum width of the field\n       default is -1 char\n    %d[a,n]\n     print the date of the message\n     <a> is the alignment. \n       <l>eft, <c>enter, <r>ight - default is <l>eft\n     <n> is the maximum width of the field\n       default is 10 char\n    %t[a,n]\n     print the time of the message\n     <a> is the alignment. \n       <l>eft, <c>enter, <r>ight - default is <l>eft\n     <n> is the maximum width of the field\n       default is 12 char\n    %s[a,n]\n     print the severity of the message\n     <a> is the alignment. \n       <l>eft, <c>enter, <r>ight - default is <l>eft\n     <n> is the maximum width of the field\n       default is 8 char\n    %g[a,n]\n     print the guid of the message\n     <a> is the alignment. \n       <l>eft, <c>enter, <r>ight - default is <l>eft\n     <n> is the maximum width of the field\n       default is 35 char\n    %l[a,n]\n     print the location of the message\n     <a> is the alignment. \n       <l>eft, <c>enter, <r>ight - default is <l>eft\n     <n> is the maximum width of the field\n       default is 35 char\n    %c[a,n]\n     print the category of the message\n     <a> is the alignment. \n       <l>eft, <c>enter, <r>ight - default is <l>eft\n     <n> is the maximum width of the field\n       default is 35 char\n";
        formatOptions = new HashMap();
        formatOptions.put("D", new LVFormatOption("date", 1, 10, 1));
        formatOptions.put("T", new LVFormatOption("time", 2, 12, 1));
        formatOptions.put("S", new LVFormatOption("severity", 3, 8, 1));
        formatOptions.put("G", new LVFormatOption("guid", 4, 35, 1));
        formatOptions.put("L", new LVFormatOption("location", 5, 35, 1));
        formatOptions.put("C", new LVFormatOption("category", 6, 35, 1));
        formatOptions.put("M", new LVFormatOption("message", 7, -1, 1));
    }
}

