/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.exceptions;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.exceptions.ExMSGs;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.StringTokenizer;

public abstract class LoggingBaseException
extends Exception {
    static final long serialVersionUID = 7343005603199954500L;
    public static final String EMPTY_STRING = "";
    public static final String CORELATE_STRING = "";
    private static final int EXCEPTION_INFO_MIN = -1;
    private static final int EXCEPTION_INFO_MESSAGE = 0;
    private static final int EXCEPTION_INFO_STACK_TRACE = 1;
    private static final int EXCEPTION_INFO_DESTINATIONS = 2;
    private static final int EXCEPTION_INFO_MAX = 3;
    private Throwable exCause;
    private String messageID;
    private String exceptionInfo;
    private long exceptionInfoID;
    private String[] exceptionInfoData = new String[3];
    private boolean exceptionInfoExists = false;

    public LoggingBaseException() {
    }

    public LoggingBaseException(Throwable ex) {
        this(ex.getMessage(), ex);
    }

    public LoggingBaseException(String msg) {
        super(msg);
    }

    public LoggingBaseException(String msg, Throwable ex) {
        super(msg);
        this.exCause = ex;
    }

    public LoggingBaseException(String messageID, String message) {
        this(messageID, message, null, null);
    }

    public LoggingBaseException(String messageID, String message, Throwable ex) {
        this(messageID, message, null, ex);
    }

    public LoggingBaseException(String messageID, String message, Object[] msgArgs) {
        this(messageID, message, msgArgs, null);
    }

    public LoggingBaseException(String messageID, String message, Object[] msgArgs, Throwable ex) {
        super(msgArgs == null ? message : MessageFormat.format(message, msgArgs));
        this.messageID = messageID;
        this.exCause = ex;
        Location lcSource = this.findSource();
        if (lcSource.beLogged(200)) {
            this.logException(lcSource);
        }
    }

    public LoggingBaseException(long messageID, String message, Object[] msgArgs) {
        this(Long.toString(messageID), message, msgArgs, null);
    }

    public LoggingBaseException(long messageID, String message, Object[] msgArgs, Throwable ex) {
        this(Long.toString(messageID), message, msgArgs, ex);
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getAdditionalInfoID() {
        return ExMSGs.LOGGING_MSG_ID_EXCEPTION_INFO;
    }

    public String getAdditionalInfo() {
        if (this.exceptionInfoExists) {
            return MessageFormat.format(ExMSGs.LOGGING_MSG_STR_EXCEPTION_INFO, this.exceptionInfoData);
        }
        return "";
    }

    public Throwable getCause() {
        return this.exCause;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        if (this.isJDK_1_4_XX()) {
            super.printStackTrace(s);
        } else {
            this.printStackTraceInt(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (this.isJDK_1_4_XX()) {
            super.printStackTrace(s);
        } else {
            this.printStackTraceInt(s);
        }
    }

    private Location findSource() {
        String source = this.findSourceName();
        Location lcSource = null;
        lcSource = source != null ? Location.getLocation(source) : Location.getLocation(this.getClass().getName());
        return lcSource;
    }

    private void logException(Location lcSource) {
        this.buildExceptionInfo(0, lcSource, lcSource.path(Category.SYS_LOGGING, "", (Object)this.getMessageID(), null, this.getMessage()));
        this.buildExceptionInfo(1, lcSource, lcSource.traceThrowableT(200, this.getMessage(), this));
        this.buildExceptionInfo(2, lcSource, null);
    }

    private void buildExceptionInfo(int index, LogController source, LogRecord record) {
        switch (index) {
            case 0: 
            case 1: {
                if (record == null) break;
                this.exceptionInfoData[index] = record.getId().toString();
                break;
            }
            case 2: {
                StringBuffer logNames = new StringBuffer();
                Iterator iter = source.getAllLogs().iterator();
                while (iter.hasNext()) {
                    logNames.append(((Log)iter.next()).getName());
                }
                if (logNames.length() > 0) {
                    this.exceptionInfoData[index] = logNames.toString();
                }
                this.exceptionInfoExists = true;
            }
        }
    }

    private String findSourceName() {
        StringWriter stack = new StringWriter();
        PrintWriter writer = new PrintWriter(stack);
        ((Throwable)this).printStackTrace(writer);
        String myStack = ((Object)stack).toString();
        int currPos = 0;
        int lastPos = 0;
        while ((currPos = myStack.indexOf("at", currPos)) >= 0) {
            if (myStack.substring(currPos - 1, currPos).trim().length() == 0 && myStack.substring(currPos + 2, currPos + 3).trim().length() == 0) {
                lastPos = currPos;
                break;
            }
            ++currPos;
        }
        if (lastPos == 0) {
            return null;
        }
        String myLine = myStack.substring(lastPos + 2);
        myLine = myLine.substring(0, myLine.indexOf("("));
        StringTokenizer strTok = new StringTokenizer(myLine, ".", true);
        StringBuffer location = new StringBuffer();
        int cnt = strTok.countTokens() - 2;
        int i = 0;
        while (i < cnt) {
            location.append(strTok.nextToken());
            ++i;
        }
        return location.toString();
    }

    private void printStackTraceInt(PrintStream s) {
        super.printStackTrace(s);
    }

    private void printStackTraceInt(PrintWriter s) {
        super.printStackTrace(s);
    }

    private boolean isJDK_1_4_XX() {
        int versionNum = 0;
        try {
            versionNum = Integer.parseInt(System.getProperty("java.version").substring(2, 3));
            if (versionNum < 4) {
                return false;
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }
}

