/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.ExceptionManager;
import com.sap.tc.logging.Group;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.MSGCollection;

class GroupFactory {
    private static Location LOC = Location.getLocation("com.sap.tc.logging.GroupFactory");

    GroupFactory() {
    }

    public static Group openGroup(int size, LogController src, LogController[] relatives, String name, String description, int severity, String subLoc) {
        Group newGroup = null;
        Group parentGroup = src.thrLocals.getGroup();
        int parentGroupLevel = 0;
        if (parentGroup != null) {
            parentGroupLevel = parentGroup.getLevel();
        }
        String locName = src.getName();
        if (subLoc != null) {
            locName = locName + '.' + subLoc;
        }
        if (++parentGroupLevel <= size) {
            newGroup = new Group(locName, subLoc, relatives, name, description, parentGroup, ++parentGroupLevel, severity);
            src.thrLocals.setGroup(newGroup);
            src.groupT("Opening group");
            newGroup.setCommitted(true);
        } else {
            LOC.logIntByAPI(400, LOC, "[openGroup(...)]", MSGCollection.LOGGING_MSG_ID_GROUP_OPEN_LIMIT, MSGCollection.LOGGING_MSG_STR_GROUP_OPEN_LIMIT, new String[]{"LogController", src.getName(), Integer.toString(size)});
            ExceptionManager.handleException(new IndexOutOfBoundsException(), 5);
        }
        return newGroup;
    }

    public static boolean closeGroup(LogController src) {
        try {
            src.thrLocals.setGroup(src.thrLocals.getGroup().getParent());
            if (src.thrLocals.getGroup() == null) {
                src.thrLocals = null;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static boolean closeGroup(LogController src, Group group) {
        try {
            src.thrLocals.setGroup(src.thrLocals.getGroup().getParent());
            if (src.thrLocals.getGroup() == null) {
                src.thrLocals = null;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

