/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util.mic;

import com.sap.idm.vds.ie.op.common.util.MVDMic_Util;
import com.sap.idm.vds.util.HidedIDStoreOperations;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class OracleBlobHandler {
    private HidedIDStoreOperations mHidID;

    public OracleBlobHandler(HidedIDStoreOperations aHidID) {
        this.mHidID = aHidID;
    }

    protected boolean updateLobs(String aTableName, String aIndexCol, String aKey, Vector aLobColumns, Vector aLobValues, Vector aLobTypes) throws IOException, SQLException {
        String lobCols = "";
        for (int ix = 0; ix < aLobColumns.size(); ++ix) {
            lobCols = lobCols + "," + (String)aLobColumns.get(ix);
        }
        lobCols = lobCols.substring(1);
        String cmd = "SELECT " + lobCols + " FROM " + aTableName + " WHERE " + aIndexCol + "=? FOR UPDATE";
        System.out.println(cmd);
        PreparedStatement prep = this.mHidID.idstoreconnection().prepareStatement(cmd, 1004, 1008);
        if (aKey.length() < 4000) {
            prep.setString(1, aKey);
        } else {
            StringReader ir = new StringReader(aKey);
            prep.setCharacterStream(1, (Reader)ir, aKey.length());
        }
        ResultSet rset = prep.executeQuery();
        rset.next();
        for (int ix = 0; ix < aLobColumns.size(); ++ix) {
            String value = (String)aLobValues.get(ix);
            if (((String)aLobTypes.get(ix)).equals("CLOB")) {
                CLOB clob = (CLOB)rset.getClob(ix + 1);
                clob.putString(1L, value);
                continue;
            }
            BLOB blob = (BLOB)rset.getBlob(ix + 1);
            OutputStream outstream = blob.getBinaryOutputStream();
            if (value.startsWith("{HEX}")) {
                outstream.write(MVDMic_Util.hexToByte((String)value.substring(5)));
            } else {
                outstream.write(value.getBytes());
            }
            outstream.flush();
            outstream.close();
        }
        rset.close();
        prep.close();
        return true;
    }

    public boolean updateLob(String aSQLStatement, String aLobValue) throws IOException, SQLException {
        Statement stat = this.mHidID.idstoreconnection().createStatement(1004, 1008);
        ResultSet rset = stat.executeQuery(aSQLStatement);
        rset.next();
        ResultSetMetaData rsmd = rset.getMetaData();
        if (rsmd.getColumnType(1) == 2005) {
            CLOB clob = (CLOB)rset.getClob(1);
            clob.putString(1L, aLobValue);
        } else if (rsmd.getColumnType(1) == 2004) {
            BLOB blob = (BLOB)rset.getBlob(1);
            OutputStream outstream = blob.getBinaryOutputStream();
            if (aLobValue.startsWith("{HEX}")) {
                outstream.write(MVDMic_Util.hexToByte((String)aLobValue.substring(5)));
            } else {
                outstream.write(aLobValue.getBytes());
            }
            outstream.flush();
            outstream.close();
        }
        rset.close();
        stat.close();
        return true;
    }
}

