/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util.mic;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class IniFile {
    public static final int OK = 0;
    public static final int FILE_ERROR = 1;
    public static final int SECTION_ERROR = 2;
    public static final int KEY_ERROR = 3;
    public static final int FILE_LOCKED = 4;
    private static int sStatus = 0;

    private static String fixFileName(String aFileName) {
        if (File.separatorChar != '\\') {
            return aFileName.replace('\\', File.separatorChar);
        }
        return aFileName;
    }

    public static String readFile(String aFileName) throws IOException, FileNotFoundException {
        StringBuffer sFileContent = new StringBuffer(100000);
        FileReader frIni = new FileReader(IniFile.fixFileName(aFileName));
        if (frIni != null) {
            BufferedReader brIni = new BufferedReader(frIni);
            if (brIni != null) {
                String sLine;
                while (brIni.ready() && (sLine = brIni.readLine()) != null) {
                    sFileContent.append(sLine).append('\n');
                }
                brIni.close();
            }
            frIni.close();
        }
        return sFileContent.toString();
    }

    private static int getSectionIndex(String aSectionName, String aIniFileContent) {
        String name = aSectionName.toUpperCase();
        String buffer = aIniFileContent.toUpperCase();
        return buffer.indexOf("\n[" + name + "]");
    }

    private static String getSection(String aSectionName, String aIniFileContent) {
        sStatus = 0;
        String sIniContent = "\n" + aIniFileContent;
        int index = IniFile.getSectionIndex(aSectionName, sIniContent);
        if (index == -1) {
            sStatus = 2;
            return "";
        }
        String sSectionContent = aIniFileContent.substring(index);
        int indexOfFollowingSection = sSectionContent.indexOf("\n[") + 1;
        if (indexOfFollowingSection == 0) {
            indexOfFollowingSection = sSectionContent.length();
        }
        sSectionContent = sSectionContent.substring(0, indexOfFollowingSection);
        return sSectionContent;
    }

    private static int getKeyIndex(String aKey, String aSectionContent) {
        String key = aKey.toUpperCase();
        String section = aSectionContent.toUpperCase();
        return section.indexOf("\n" + key + "=");
    }

    private static String getKeyValue(String aKey, String aSectionContent) {
        String sSection = "\n" + aSectionContent;
        int indexStart = IniFile.getKeyIndex(aKey, sSection);
        if (indexStart == -1) {
            sStatus = 3;
            return "";
        }
        String sValue = sSection.substring(indexStart += 2 + aKey.length());
        int indexEnd = sValue.indexOf(10);
        if (indexEnd == -1) {
            indexEnd = sValue.length();
        }
        sValue = sValue.substring(0, indexEnd).trim();
        return sValue;
    }

    public static String getKeyValue(String aIniFullFileName, String aSectionName, String aKey) {
        String sIniFileContent = "";
        sStatus = 0;
        try {
            sIniFileContent = IniFile.readFile(aIniFullFileName);
        }
        catch (Exception e) {
            sStatus = 1;
            return "";
        }
        String sValue = IniFile.getKeyValueFromString(aSectionName, aKey, sIniFileContent);
        return sValue;
    }

    public static String getKeyValue(String aIniFullFileName, String aSectionName, String aKey, String aIniFileContent) {
        sStatus = 0;
        if (aIniFileContent == null) {
            return IniFile.getKeyValue(aIniFullFileName, aSectionName, aKey);
        }
        String sRetVal = IniFile.getKeyValue(aIniFullFileName, aSectionName, aKey);
        if (sRetVal == null || sRetVal.length() < 1) {
            return sRetVal;
        }
        sStatus = 0;
        String sSectionContent = IniFile.getSection(aSectionName, aIniFileContent);
        if (sStatus != 0) {
            return "";
        }
        String sValue = IniFile.getKeyValue(aKey, sSectionContent);
        return sValue;
    }

    public static String getKeyValueFromString(String aSectionName, String aKey, String aIniFileContent) {
        sStatus = 0;
        if (aIniFileContent == null) {
            return "";
        }
        String sSectionContent = IniFile.getSection(aSectionName, aIniFileContent);
        if (sStatus != 0) {
            return "";
        }
        String sValue = IniFile.getKeyValue(aKey, sSectionContent);
        return sValue;
    }

    public static int getStatus() {
        return sStatus;
    }

    public static Map getSectionValues(String aSectionName, String aIniFullFileName) {
        HashMap<String, String> result = new HashMap<String, String>();
        String sIniFileContent = "";
        try {
            String line;
            sIniFileContent = IniFile.readFile(aIniFullFileName);
            String sCompleteSection = IniFile.getSection(aSectionName, sIniFileContent);
            BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(sCompleteSection.getBytes())));
            while ((line = br.readLine()) != null) {
                int ix = (line = line.trim()).indexOf("=");
                if (ix <= 0) continue;
                String name = line.substring(0, ix).toUpperCase();
                String value = line.substring(ix + 1);
                if (result.containsKey(name)) continue;
                result.put(name, value);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }
}

