/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.MVDCacheUtil;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.util.SessionObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SessionStore {
    private static final String SESSION_CACHE_NAME = "SESSIONS";
    private static ByteArrayOutputStream mBout;
    private static ObjectOutputStream mOout;

    public static void createSession(String aSessionID, Vector aSessionObjects) {
        MVDSearchResultEntry entry = new MVDSearchResultEntry();
        entry.setDn(aSessionID);
        Iterator iter = aSessionObjects.iterator();
        while (iter.hasNext()) {
            SessionObject so = (SessionObject)iter.next();
            entry.setAttrValue(so.getObjectname(), true, SessionStore.convertObjToByteArray(so.getPayload()));
        }
        MVDSearchResults res = new MVDSearchResults();
        res.add(entry);
        res.setOK();
        MVDCacheUtil.addToCache(SESSION_CACHE_NAME, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertObjToByteArray(Object aObj) {
        ObjectOutputStream objectOutputStream = mOout;
        synchronized (objectOutputStream) {
            try {
                mOout.writeObject(aObj);
                mOout.flush();
                mBout.flush();
                byte[] byteobj = mBout.toByteArray();
                mOout.reset();
                mBout.reset();
                return byteobj;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private static Object convertByteArrayToObj(byte[] aByteArr) {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(aByteArr);
            ObjectInputStream oin = new ObjectInputStream(bin);
            Object o = oin.readObject();
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Vector getSessionObjects(String aSessionID) {
        MVDSearchResults incache = MVDCacheUtil.getFromCache(SESSION_CACHE_NAME, aSessionID, new Vector());
        if (incache == null || incache.size() == 0) {
            MVDLogger.Log("No session found to update for sessionid: " + aSessionID, 2);
            throw new NoSuchElementException();
        }
        MVDSearchResultEntry entry = (MVDSearchResultEntry)incache.elementAt(0);
        Iterator it = entry.getAttrAndValues().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pair = it.next();
            SessionObject so = new SessionObject((String)pair.getKey(), SessionStore.convertByteArrayToObj((byte[])pair.getValue()));
        }
        return null;
    }

    public static boolean sessionInitiated(String aSessionID) {
        return MVDCacheUtil.getFromCache(SESSION_CACHE_NAME, aSessionID, new Vector()) != null;
    }

    public static boolean updateSession(String aSessionID, SessionObject aSessionObject) {
        MVDSearchResults incache = MVDCacheUtil.getFromCache(SESSION_CACHE_NAME, aSessionID, new Vector());
        if (incache == null || incache.size() == 0) {
            MVDLogger.Log("No session found to update for sessionid: " + aSessionID, 2);
            return false;
        }
        MVDSearchResultEntry entry = (MVDSearchResultEntry)incache.elementAt(0);
        entry.setAttrValue(aSessionObject.getObjectname(), true, SessionStore.convertObjToByteArray(aSessionObject.getPayload()));
        SessionStore.removeSession(aSessionID);
        incache.setOK();
        MVDCacheUtil.addToCache(SESSION_CACHE_NAME, incache);
        return true;
    }

    public static void removeSession(String aSessionID) {
        MVDCacheUtil.deleteFromCache(SESSION_CACHE_NAME, aSessionID);
    }

    public static void removeSessionObject(String aSessionID, SessionObject aObjectID) {
        MVDSearchResults incache = MVDCacheUtil.getFromCache(SESSION_CACHE_NAME, aSessionID, new Vector());
        if (incache == null || incache.size() == 0) {
            MVDLogger.Log("No session found to update for sessionid: " + aSessionID, 2);
            return;
        }
        MVDSearchResultEntry entry = (MVDSearchResultEntry)incache.elementAt(0);
        entry.getAttrAndValues().remove(aObjectID);
        SessionStore.removeSession(aSessionID);
        incache.setOK();
        MVDCacheUtil.addToCache(SESSION_CACHE_NAME, incache);
    }

    static {
        if (!MVDCacheUtil.createCache(SESSION_CACHE_NAME, 3600, true, true)) {
            MVDLogger.Log("Could not create cache for sessions", 2);
        }
        try {
            mBout = new ByteArrayOutputStream();
            mOout = new ObjectOutputStream(mBout);
        }
        catch (IOException e) {
            MVDLogger.Log("Exception initializing serializer in Sessionstore", 2);
        }
    }
}

