/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.MVDGlobals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.message.MxAdd;
import com.sap.idm.vds.message.MxAttrSet;
import com.sap.idm.vds.message.MxDelete;
import com.sap.idm.vds.message.MxEntry;
import com.sap.idm.vds.message.MxModify;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.message.MxSearch;
import com.sap.idm.vds.util.DSMLUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SPMLUtil {
    private static String mPatchingMode = "";

    public static MxRequest[] RequestTransform(Object aRequest, Object aSessionGlobals) {
        MxRequest[] mxReqs = null;
        mPatchingMode = MVDGlobals.getGlobalParameter("GLOBAL_UNDERLINE_PATCHING", "SAP");
        Vector<Object> values = new Vector<Object>();
        HashMap sessionGlobals = (HashMap)aSessionGlobals;
        try {
            String aVal;
            NamedNodeMap nm;
            Node reqid;
            String spmlRequest = null;
            String clientIP = null;
            if (aRequest instanceof String) {
                spmlRequest = (String)aRequest;
            } else {
                spmlRequest = ((HashMap)aRequest).get("MESSAGE").toString();
                clientIP = ((HashMap)aRequest).get("CLIENT_IP").toString();
            }
            if (spmlRequest.indexOf("urn:oasis:names:tc:SPML:2:0") != -1) {
                sessionGlobals.put("TRANSFORMATIONERROR", "SPMLv2");
                MVDLogger.Log("Request type is SPML v2 and not supported by the service. To support SPML v2 requests deploy the web service with the MxSPMLv2_DSMLTranform transformation class.", 7);
                return mxReqs;
            }
            if (spmlRequest.indexOf("\"urn:oasis:names:tc:SPML:1:0\"") == -1) {
                if (spmlRequest.indexOf("urn:oasis:names:tc:DSML:2:0:core") != -1) {
                    sessionGlobals.put("TRANSFORMATIONERROR", "DSML");
                    MVDLogger.Log("Request type is DSML v2 and not supported by the web service. To support DSML v2 requests deploy  the web service with the MxDSMLv2TransformClass transformation class.", 7);
                } else {
                    sessionGlobals.put("TRANSFORMATIONERROR", "UNDEFINED");
                    MVDLogger.Log("Request type is not supported by the web service. Deploy the web service with a customized transformation class to solve the problem.", 7);
                }
                return mxReqs;
            }
            Document SPMLSearchReqAsDOM = MVDUtilities.ConvertFromStringToDOM(spmlRequest);
            Element topNode = SPMLSearchReqAsDOM.getDocumentElement();
            sessionGlobals.put(aRequest, values);
            Node batchRoot = topNode;
            String nodeName = batchRoot.getLocalName();
            while (!(nodeName.equalsIgnoreCase("batchRequest") || nodeName.equalsIgnoreCase("searchRequest") || nodeName.equalsIgnoreCase("modifyRequest") || nodeName.equalsIgnoreCase("addRequest") || nodeName.equalsIgnoreCase("deleteRequest") || nodeName.equalsIgnoreCase("schemaRequest"))) {
                batchRoot = batchRoot.getFirstChild();
                nodeName = batchRoot.getLocalName();
            }
            if (batchRoot.hasAttributes() && (reqid = (nm = batchRoot.getAttributes()).getNamedItem("requestID")) != null && (aVal = reqid.getNodeValue()) != null) {
                sessionGlobals.put("ASYNC_REQUEST_ID", aVal);
            }
            if (!nodeName.equalsIgnoreCase("batchRequest")) {
                values.add("SINGLE");
                values.add(new Vector());
                mxReqs = new MxRequest[]{SPMLUtil.RequestTransform(aRequest, batchRoot, sessionGlobals)};
            } else {
                values.add("BATCH");
                values.add(new Vector());
                NodeList requestList = batchRoot.getChildNodes();
                mxReqs = new MxRequest[requestList.getLength()];
                for (int requestCounter = 0; requestCounter < requestList.getLength(); ++requestCounter) {
                    Node requestNode = requestList.item(requestCounter);
                    if (requestNode.getLocalName() == null) continue;
                    mxReqs[requestCounter] = SPMLUtil.RequestTransform(aRequest, requestNode, sessionGlobals);
                }
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming SPML request:\t" + e);
        }
        return mxReqs;
    }

    private static MxRequest RequestTransform(Object aOrgReq, Node aRequestNode, HashMap aSessionGlobals) {
        MxRequest request = null;
        try {
            Vector values = (Vector)aSessionGlobals.get(aOrgReq);
            Vector actions = (Vector)values.get(1);
            String requestNodeName = aRequestNode.getLocalName();
            if (requestNodeName.equalsIgnoreCase("searchRequest")) {
                request = SPMLUtil.TransformSearchRequest(aRequestNode, aOrgReq, aSessionGlobals);
            } else if (requestNodeName.equalsIgnoreCase("deleteRequest")) {
                actions.add("MxDelete");
                values.set(1, actions);
                aSessionGlobals.put(aOrgReq, values);
                request = SPMLUtil.TransformDeleteRequest(aRequestNode);
            } else if (requestNodeName.equalsIgnoreCase("addRequest")) {
                actions.add("MxAdd");
                values.set(1, actions);
                aSessionGlobals.put(aOrgReq, values);
                request = SPMLUtil.TransformAddRequest(aRequestNode);
            } else if (requestNodeName.equalsIgnoreCase("modifyRequest")) {
                actions.add("MxModify");
                values.set(1, actions);
                aSessionGlobals.put(aOrgReq, values);
                request = SPMLUtil.TransformModifyRequest(aRequestNode);
            } else if (requestNodeName.equalsIgnoreCase("schemaRequest")) {
                actions.add("MxSchema");
                values.set(1, actions);
                aSessionGlobals.put(aOrgReq, values);
                request = SPMLUtil.TransformSchemaRequest(aRequestNode);
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming " + aRequestNode.getLocalName() + ":" + e);
        }
        return request;
    }

    private static MxSearch TransformSearchRequest(Node aSearchReqNode, Object aOrgReq, HashMap aSessionGlobals) {
        String startPoint = null;
        String filter = null;
        MxSearch search = new MxSearch();
        Vector values = (Vector)aSessionGlobals.get(aOrgReq);
        Vector actions = (Vector)values.get(1);
        Vector reqAttrs = new Vector();
        try {
            NodeList childNodes = aSearchReqNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String childName = childNode.getLocalName();
                if (childName == null) continue;
                if (childName.equalsIgnoreCase("searchBase")) {
                    Node startPointNode = childNode;
                    startPoint = SPMLUtil.GetLastNodeValue(childNode, "ID");
                    search.setStartingPoint(startPoint);
                    aSessionGlobals.put("LAST_OPER", startPoint);
                    continue;
                }
                if (childName.equalsIgnoreCase("filter")) {
                    Node filterNode = childNode;
                    if (filterNode.hasChildNodes()) {
                        Node filterChildNode = filterNode.getFirstChild();
                        while (filterChildNode.getLocalName() == null) {
                            filterChildNode = filterChildNode.getNextSibling();
                        }
                        filter = DSMLUtil.GetFilterAsString(filterChildNode);
                    }
                    search.setRequestedFilter(filter);
                    continue;
                }
                if (!childName.equalsIgnoreCase("attributes")) continue;
                reqAttrs = SPMLUtil.GetReqAttrsAsVector(childNode.getChildNodes());
                search.setRequestedAttributes(reqAttrs);
            }
            if (reqAttrs != null && !reqAttrs.isEmpty()) {
                actions.add(reqAttrs);
            } else {
                actions.add("MxSearch");
            }
            values.set(1, actions);
            aSessionGlobals.put(aOrgReq, values);
            String searchScope = MVDGlobals.getGlobalParameter("GLOBAL_SPMLSCOPE", "");
            if (searchScope != null && !searchScope.equalsIgnoreCase("")) {
                int scope = Integer.parseInt(searchScope);
                if (scope >= 0 && scope < 3) {
                    search.setOperationScope(scope);
                } else {
                    search.setOperationScope(0);
                }
            } else {
                search.setOperationScope(0);
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming search request:" + e);
        }
        return search;
    }

    private static MxAdd TransformAddRequest(Node aAddReqNode) {
        MxAdd add = new MxAdd();
        try {
            NodeList childNodes = aAddReqNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String childName = childNode.getLocalName();
                if (childName == null) continue;
                if (childName.equalsIgnoreCase("identifier")) {
                    String identifier = SPMLUtil.GetLastNodeValue(aAddReqNode, "ID");
                    add.setDn(identifier);
                    continue;
                }
                if (!childName.equalsIgnoreCase("attributes")) continue;
                HashMap reqAttrs = SPMLUtil.GetReqAttrsAsMap(childNode.getChildNodes());
                add.setAttrSetAndValues(new MxAttrSet(reqAttrs));
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming add request:" + e);
        }
        return add;
    }

    private static MxModify TransformModifyRequest(Node aModReqNode) {
        MxModify modify = new MxModify();
        try {
            NodeList childNodes = aModReqNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String childName = childNode.getLocalName();
                if (childName == null) continue;
                if (childName.equalsIgnoreCase("identifier")) {
                    String identifier = SPMLUtil.GetLastNodeValue(childNode, "ID");
                    modify.setDn(identifier);
                    continue;
                }
                if (!childName.equalsIgnoreCase("modifications")) continue;
                Vector<MVDModAttrValues> modifications = new Vector<MVDModAttrValues>();
                NodeList modList = childNode.getChildNodes();
                for (int modCounter = 0; modCounter < modList.getLength(); ++modCounter) {
                    Node modNode = modList.item(modCounter);
                    if (modNode.getNodeType() == 3) continue;
                    String modName = ((Element)modNode).getAttribute("name");
                    String modOperation = ((Element)modNode).getAttribute("operation");
                    if (modOperation == null) {
                        modOperation = "add";
                    }
                    MVDModAttrValues modification = new MVDModAttrValues();
                    if (SPMLUtil.containsMxDashAttrs(modName)) {
                        MVDLogger.Debug("Attribute name before patching " + modName);
                        modName = MVDUtil.replace(modName, "-", "_");
                        MVDLogger.Debug("Attribute name after patching " + modName);
                    }
                    modification.setAttrName(modName);
                    modification.setModType(SPMLUtil.mapOperation(modOperation));
                    NodeList modValues = modNode.getChildNodes();
                    for (int subModCounter = 0; subModCounter < modValues.getLength(); ++subModCounter) {
                        Node modValue = modValues.item(subModCounter);
                        if (modValue.getNodeType() == 3) continue;
                        Object value = DSMLUtil.GetValue(modValue);
                        modification.add(value);
                    }
                    modifications.add(modification);
                }
                modify.setAttrAndModValues(modifications);
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming modify request:" + e);
        }
        return modify;
    }

    private static MxDelete TransformDeleteRequest(Node aDelReqNode) {
        MxDelete delete = new MxDelete();
        try {
            String identifier = SPMLUtil.GetLastNodeValue(aDelReqNode, "ID");
            delete.setDn(identifier);
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming delete request:" + e);
        }
        return delete;
    }

    private static MxSearch TransformSchemaRequest(Node aSchemaReqNode) {
        MxSearch search = new MxSearch();
        try {
            String globGetSchemaOper = MVDGlobals.getGlobalParameter("GLOBAL_SPML_SCHEMA_OPER", "schema");
            String schemaid = SPMLUtil.GetLastNodeValue(aSchemaReqNode, "schemaId");
            if (schemaid.length() > 0) {
                search.setStartingPoint(globGetSchemaOper + "@" + schemaid);
            } else {
                search.setStartingPoint(globGetSchemaOper);
            }
            search.setRequestedURLFilter("(objectclass=*)");
            search.setRequestedAttributes(new Vector());
            search.setOperationScope(0);
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming schema request:" + e);
        }
        return search;
    }

    private static String GetLastNodeValue(Node aStartNode, String aTagName) {
        String nodeValue = null;
        boolean isNodeFound = false;
        Node node = aStartNode;
        try {
            while (!isNodeFound) {
                if (node.getLocalName() == null) {
                    node = node.getNextSibling();
                    continue;
                }
                if (node.getLocalName().equalsIgnoreCase(aTagName)) {
                    isNodeFound = true;
                }
                node = node.getFirstChild();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (node == null) {
            return "";
        }
        nodeValue = node.getNodeValue();
        return nodeValue;
    }

    private static Vector GetReqAttrsAsVector(NodeList aReqAttrNodes) {
        Vector<String> reqAttrs = new Vector<String>();
        try {
            for (int i = 0; i < aReqAttrNodes.getLength(); ++i) {
                String attr;
                Node reqAttr = aReqAttrNodes.item(i);
                if (reqAttr.getNodeType() == 3 || (attr = ((Element)aReqAttrNodes.item(i)).getAttribute("name").toLowerCase()).equalsIgnoreCase("*")) continue;
                if (SPMLUtil.containsMxDashAttrs(attr)) {
                    MVDLogger.Debug("Attribute name before patching " + attr);
                    attr = MVDUtil.replace(attr, "-", "_");
                    MVDLogger.Debug("Attribute name after patching " + attr);
                }
                reqAttrs.add(attr);
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error getting requested attributes as a vector:" + e);
        }
        return reqAttrs;
    }

    private static boolean containsMxDashAttrs(String aSource) {
        if (aSource == null) {
            return false;
        }
        return mPatchingMode.equalsIgnoreCase("SAP") ? aSource.startsWith("MXREF-") || aSource.startsWith("mxref-") || aSource.startsWith("MXMEMBER-") || aSource.startsWith("mxmember-") || aSource.startsWith("MX-") || aSource.startsWith("mx-") : aSource.indexOf("-") >= 0;
    }

    private static boolean containsMxUnderlineAttrs(String aSource) {
        if (aSource == null) {
            return false;
        }
        return mPatchingMode.equalsIgnoreCase("SAP") ? aSource.startsWith("MXREF_") || aSource.startsWith("mxref_") || aSource.startsWith("MXMEMBER_") || aSource.startsWith("mxmember_") || aSource.startsWith("MX_") || aSource.startsWith("mx_") : aSource.indexOf("_") >= 0;
    }

    private static HashMap GetReqAttrsAsMap(NodeList aReqAttrNodes) {
        HashMap<String, Vector> reqAttrs = new HashMap<String, Vector>();
        try {
            Node reqAttr = aReqAttrNodes.item(0);
            for (int i = 0; i < aReqAttrNodes.getLength(); ++i) {
                Node attrNode = aReqAttrNodes.item(i);
                if (attrNode.getNodeType() == 3) continue;
                String attr = ((Element)attrNode).getAttribute("name").toLowerCase();
                if (attrNode.hasChildNodes()) {
                    NodeList attrNodeValues = attrNode.getChildNodes();
                    for (int j = 0; j < attrNodeValues.getLength(); ++j) {
                        Node attrNodeValue = attrNodeValues.item(j);
                        if (attrNodeValue.getNodeType() == 3) continue;
                        Vector attrValues = new Vector();
                        if (reqAttrs.containsKey(attr)) {
                            attrValues = (Vector)reqAttrs.get(attr);
                        }
                        Object value = DSMLUtil.GetValue(attrNodeValue);
                        attrValues.add(value);
                        if (SPMLUtil.containsMxDashAttrs(attr)) {
                            MVDLogger.Debug("Attribute name before patching " + attr);
                            attr = MVDUtil.replace(attr, "-", "_");
                            MVDLogger.Debug("Attribute name after patching " + attr);
                        }
                        reqAttrs.put(attr, attrValues);
                    }
                    continue;
                }
                String value = attrNode.getFirstChild().getFirstChild().getNodeValue();
                Vector attrValues = new Vector();
                if (reqAttrs.containsKey(attr)) {
                    attrValues = (Vector)reqAttrs.get(attr);
                }
                attrValues.add(value);
                if (SPMLUtil.containsMxDashAttrs(attr)) {
                    MVDLogger.Debug("Attribute name before patching " + attr);
                    attr = MVDUtil.replace(attr, "-", "_");
                    MVDLogger.Debug("Attribute name after patching " + attr);
                }
                reqAttrs.put(attr, attrValues);
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error getting requested attributes as a map:" + e);
        }
        return reqAttrs;
    }

    public static Object ResponseTransform(MxResponse[] aResponses, Object aOrgReq, Object aSessionGlobals, MxRequest[] aRequestArr) {
        HashMap sessionGlobals = (HashMap)aSessionGlobals;
        if (sessionGlobals.containsKey("TRANSFORMATIONERROR")) {
            return "TRANSFORMATIONERROR_SPMLv1";
        }
        Vector values = (Vector)sessionGlobals.get(aOrgReq);
        String singOrBatchReq = values.get(0).toString();
        Vector actions = (Vector)values.get(1);
        Node respNode = null;
        MxResponse respons = null;
        try {
            Node respRoot = null;
            Document SPMLRespons = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            if (singOrBatchReq.equalsIgnoreCase("SINGLE")) {
                respons = aResponses[0];
                Object reqObj = actions.get(0);
                respRoot = SPMLUtil.ResponseTransform(respons, aOrgReq, reqObj, SPMLRespons, sessionGlobals, aRequestArr[0]);
            } else {
                respRoot = SPMLRespons.createElement("spml:batchResponse");
                String totalState = "success";
                for (int i = 0; i < aResponses.length; ++i) {
                    String x;
                    respons = aResponses[i];
                    Object reqObj = actions.get(i);
                    respNode = SPMLUtil.ResponseTransform(respons, aOrgReq, reqObj, SPMLRespons, sessionGlobals, aRequestArr[i]);
                    respRoot.appendChild(respNode);
                    Node tmp = respNode.getAttributes().getNamedItem("result");
                    if (tmp == null || !(x = tmp.getNodeValue()).toLowerCase().endsWith("failure")) continue;
                    totalState = "failure";
                }
                if (totalState.equalsIgnoreCase("failure")) {
                    respRoot.setAttribute("result", "urn:oasis:names:tc:SPML:1:0#failure");
                } else {
                    respRoot.setAttribute("result", "urn:oasis:names:tc:SPML:1:0#success");
                }
            }
            respRoot.setAttribute("xmlns:dsml", "urn:oasis:names:tc:DSML:2:0:core");
            ((Element)respRoot).setAttribute("xmlns:spml", "urn:oasis:names:tc:SPML:1:0");
            String requestId = (String)sessionGlobals.get("ASYNC_REQUEST_ID");
            if (requestId != null) {
                ((Element)respRoot).setAttribute("requestID", requestId);
            }
            SPMLRespons.appendChild(respRoot);
            sessionGlobals.remove(aResponses);
            return MVDUtilities.ConvertFromDOMToString(SPMLRespons);
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transform response:" + e);
            return null;
        }
    }

    private static Node ResponseTransform(MxResponse aResponse, Object aOrgReq, Object aReqObj, Document aSPMLRequest, HashMap aSessionGlobals, MxRequest aRequest) {
        Node respNode = null;
        try {
            if (aReqObj instanceof Vector) {
                Vector reqAttr = (Vector)aReqObj;
                if (reqAttr.size() == 1 && reqAttr.elementAt(0).equals("*")) {
                    reqAttr = new Vector();
                }
                respNode = SPMLUtil.TransformSearchRespons(aResponse, reqAttr, aSPMLRequest, aSessionGlobals);
            } else {
                String reqTypeName = (String)aReqObj;
                if (reqTypeName.equalsIgnoreCase("MxSearch")) {
                    return SPMLUtil.TransformSearchRespons(aResponse, new Vector(), aSPMLRequest, aSessionGlobals);
                }
                if (reqTypeName.equalsIgnoreCase("MxSchema")) {
                    return SPMLUtil.TransformSchemaRespons(aResponse, new Vector(), aSPMLRequest);
                }
                int reqType = reqTypeName.equalsIgnoreCase("MxAdd") ? 0 : (reqTypeName.equalsIgnoreCase("MxDelete") ? 1 : 2);
                respNode = SPMLUtil.TransformRespons(aResponse, reqType, aSPMLRequest, aRequest);
            }
        }
        catch (Exception e) {
            MVDLogger.Debug("Error transforming response:" + e);
            return null;
        }
        return respNode;
    }

    private static Node TransformSearchRespons(MxResponse aRespons, Vector aReqAttrs, Document aSPMLRequest, HashMap aSessionGlobals) {
        Element topNode;
        block14: {
            topNode = null;
            try {
                String additionalMessage = aRespons.isOK() ? null : aRespons.getMessage();
                String resultcode = "success";
                topNode = aSPMLRequest.createElement("spml:searchResponse");
                topNode.setAttribute("result", "urn:oasis:names:tc:SPML:1:0#" + resultcode);
                if (additionalMessage != null) {
                    topNode.setAttribute("error", additionalMessage);
                }
                if (!aRespons.isOK()) break block14;
                for (int entryCounter = 0; entryCounter < aRespons.size(); ++entryCounter) {
                    Node valueNode;
                    Object retObj;
                    int valueCount;
                    Vector returnedValues;
                    Element attrNode;
                    String key;
                    String lastOperation;
                    MxEntry entry = aRespons.getEntry(entryCounter);
                    Element entryTopNode = aSPMLRequest.createElement("searchResultEntry");
                    topNode.appendChild(entryTopNode);
                    Element idTopNode = aSPMLRequest.createElement("spml:identifier");
                    entryTopNode.appendChild(idTopNode);
                    Element idNode = aSPMLRequest.createElement("spml:id");
                    idTopNode.appendChild(idNode);
                    String dn = entry.getDn();
                    String defaultContext = MVDGlobals.getGlobalParameter("GLOBAL_DEFAULTCONTEXT", "none");
                    if (!defaultContext.equalsIgnoreCase("none") && (lastOperation = (String)aSessionGlobals.get("LAST_OPER")) != null && ((lastOperation = lastOperation.toLowerCase()).equalsIgnoreCase("operation=info") || lastOperation.length() == 0)) {
                        dn = lastOperation;
                    }
                    idNode.appendChild(aSPMLRequest.createTextNode(dn));
                    HashMap returnedAttrs = entry.getAttrAndValues();
                    if (returnedAttrs == null || returnedAttrs.isEmpty()) continue;
                    Element attrTopNode = aSPMLRequest.createElement("spml:attributes");
                    entryTopNode.appendChild(attrTopNode);
                    if (aReqAttrs != null && !aReqAttrs.isEmpty()) {
                        for (int attrCounter = 0; attrCounter < aReqAttrs.size(); ++attrCounter) {
                            key = aReqAttrs.get(attrCounter).toString();
                            attrNode = aSPMLRequest.createElement("dsml:attr");
                            if (returnedAttrs.containsKey(key) && !(returnedValues = (Vector)returnedAttrs.get(key)).isEmpty()) {
                                for (valueCount = 0; valueCount < returnedValues.size(); ++valueCount) {
                                    retObj = returnedValues.get(valueCount);
                                    valueNode = DSMLUtil.GetValue(aSPMLRequest, retObj);
                                    attrNode.appendChild(valueNode);
                                }
                            }
                            if (SPMLUtil.containsMxUnderlineAttrs(key)) {
                                MVDLogger.Debug("Attribute name before patching " + key);
                                key = MVDUtil.replace(key, "_", "-");
                                MVDLogger.Debug("Attribute name after patching " + key);
                            }
                            attrNode.setAttribute("name", key);
                            attrTopNode.appendChild(attrNode);
                        }
                        continue;
                    }
                    Iterator attrCounter = returnedAttrs.keySet().iterator();
                    while (attrCounter.hasNext()) {
                        key = attrCounter.next().toString();
                        attrNode = aSPMLRequest.createElement("dsml:attr");
                        if (returnedAttrs.containsKey(key) && !(returnedValues = (Vector)returnedAttrs.get(key)).isEmpty()) {
                            for (valueCount = 0; valueCount < returnedValues.size(); ++valueCount) {
                                retObj = returnedValues.get(valueCount);
                                valueNode = DSMLUtil.GetValue(aSPMLRequest, retObj);
                                attrNode.appendChild(valueNode);
                            }
                        }
                        if (SPMLUtil.containsMxUnderlineAttrs(key)) {
                            MVDLogger.Debug("Attribute name before patching " + key);
                            key = MVDUtil.replace(key, "_", "-");
                            MVDLogger.Debug("Attribute name after patching " + key);
                        }
                        attrNode.setAttribute("name", key);
                        attrTopNode.appendChild(attrNode);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Exception making respons as DOM object: " + e);
            }
        }
        return topNode;
    }

    private static Node TransformSchemaRespons(MxResponse aRespons, Vector aReqAttrs, Document aSPMLRequest) {
        Element topNode = null;
        try {
            String additionalMessage = aRespons.isOK() ? null : aRespons.getMessage();
            String resultcode = "success";
            topNode = aSPMLRequest.createElement("spml:schemaResponse");
            topNode.setAttribute("result", "urn:oasis:names:tc:SPML:1:0#" + resultcode);
            if (additionalMessage != null) {
                topNode.setAttribute("error", additionalMessage);
            }
            if (aRespons.isOK()) {
                Element schemaTopNode = aSPMLRequest.createElement("schema");
                topNode.appendChild(schemaTopNode);
                if (aRespons.size() > 0) {
                    Vector returnedObjectclasses;
                    Vector returnedAttrs;
                    int ix;
                    MxEntry entry = (MxEntry)aRespons.elementAt(0);
                    String schemaId = "";
                    String dn = entry.getDn();
                    String defaultContext = MVDGlobals.getGlobalParameter("GLOBAL_DEFAULTCONTEXT", "none");
                    if (!defaultContext.equalsIgnoreCase("none") && (ix = dn.toLowerCase().indexOf(defaultContext.toLowerCase())) >= 0 && (dn = dn.substring(0, ix)).endsWith(",")) {
                        dn = dn.substring(0, dn.length() - 1);
                    }
                    if ((schemaId = dn) != null && schemaId.length() > 0) {
                        Element schemaidentifierTopNode = aSPMLRequest.createElement("schemaIdentifier");
                        schemaidentifierTopNode.setAttribute("schemaIDType", "urn:oasis:names:tc:SPML:1:0#GenericString");
                        schemaTopNode.appendChild(schemaidentifierTopNode);
                        Element schemaidNode = aSPMLRequest.createElement("schemaId");
                        schemaidentifierTopNode.appendChild(schemaidNode);
                        schemaidNode.appendChild(aSPMLRequest.createTextNode(schemaId));
                    }
                    if ((returnedAttrs = entry.getAttrValues("attributetypes")) != null && !returnedAttrs.isEmpty()) {
                        for (int ix2 = 0; ix2 < returnedAttrs.size(); ++ix2) {
                            Element attrTopNode = aSPMLRequest.createElement("attributeDefinition");
                            schemaTopNode.appendChild(attrTopNode);
                            String oneAttrDefinition = (String)returnedAttrs.elementAt(ix2);
                            oneAttrDefinition = SPMLUtil.cleanTrim(oneAttrDefinition);
                            StringTokenizer matcher = new StringTokenizer(oneAttrDefinition);
                            String PASS = matcher.nextToken();
                            PASS = matcher.nextToken();
                            String aName = matcher.nextToken();
                            aName = SPMLUtil.concatTokens(aName, matcher);
                            PASS = matcher.nextToken();
                            String aDesc = matcher.nextToken();
                            aDesc = SPMLUtil.concatTokens(aDesc, matcher);
                            if (SPMLUtil.containsMxUnderlineAttrs(aName)) {
                                MVDLogger.Debug("Attribute name before patching " + aName);
                                aName = MVDUtil.replace(aName, "_", "-");
                                MVDLogger.Debug("Attribute name after patching " + aName);
                            }
                            attrTopNode.setAttribute("name", aName);
                            if (aDesc.length() <= 0 || aDesc.equalsIgnoreCase("null")) continue;
                            attrTopNode.setAttribute("description", aDesc);
                        }
                    }
                    if ((returnedObjectclasses = entry.getAttrValues("objectclasses")) != null && !returnedObjectclasses.isEmpty()) {
                        for (int ix3 = 0; ix3 < returnedObjectclasses.size(); ++ix3) {
                            Element objTopNode = aSPMLRequest.createElement("objectClassDefinition");
                            schemaTopNode.appendChild(objTopNode);
                            String oneObjDefinition = (String)returnedObjectclasses.elementAt(ix3);
                            oneObjDefinition = SPMLUtil.cleanTrim(oneObjDefinition);
                            StringTokenizer matcher = new StringTokenizer(oneObjDefinition);
                            String PASS = matcher.nextToken();
                            PASS = matcher.nextToken();
                            String aName = matcher.nextToken();
                            aName = SPMLUtil.concatTokens(aName, matcher);
                            PASS = matcher.nextToken();
                            String aDesc = matcher.nextToken();
                            aDesc = SPMLUtil.concatTokens(aDesc, matcher);
                            objTopNode.setAttribute("name", aName);
                            if (aDesc.length() > 0 && !aDesc.equalsIgnoreCase("null")) {
                                objTopNode.setAttribute("description", aDesc);
                            }
                            Element memberObjs = aSPMLRequest.createElement("memberAttributes");
                            objTopNode.appendChild(memberObjs);
                            String SUPAbstractStructural = matcher.nextToken();
                            if (!SUPAbstractStructural.equalsIgnoreCase("ABSTRACT")) {
                                if (SUPAbstractStructural.equalsIgnoreCase("SUP")) {
                                    String aSup = matcher.nextToken();
                                    Element supObjs = aSPMLRequest.createElement("superiorClasses");
                                    objTopNode.appendChild(supObjs);
                                    Element refObjs = aSPMLRequest.createElement("objectClassDefinitionReference");
                                    refObjs.setAttribute("name", aSup);
                                    supObjs.appendChild(refObjs);
                                    String STRUCTURAL = matcher.nextToken();
                                } else if (SUPAbstractStructural.equalsIgnoreCase("STRUCTURAL")) {
                                    // empty if block
                                }
                            }
                            String mustValue = "";
                            int mustIndex = oneObjDefinition.indexOf("MUST");
                            if (mustIndex >= 0) {
                                int xOrigIndex;
                                mustIndex += 4;
                                int mayIndex = oneObjDefinition.indexOf("MAY");
                                mustValue = mayIndex >= 0 ? oneObjDefinition.substring(mustIndex, mayIndex) : ((xOrigIndex = oneObjDefinition.indexOf("X-ORIGIN")) >= 0 ? oneObjDefinition.substring(mustIndex, xOrigIndex) : oneObjDefinition.substring(mustIndex));
                            }
                            String mayValue = "";
                            int mayIndex = oneObjDefinition.indexOf("MAY");
                            if (mayIndex >= 0) {
                                mayIndex += 3;
                                int xOrigIndex = oneObjDefinition.indexOf("X-ORIGIN");
                                mayValue = xOrigIndex >= 0 ? oneObjDefinition.substring(mayIndex, xOrigIndex) : oneObjDefinition.substring(mayIndex);
                            }
                            SPMLUtil.addAttributeReferences(mustValue, aSPMLRequest, memberObjs, true);
                            SPMLUtil.addAttributeReferences(mayValue, aSPMLRequest, memberObjs, false);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception making respons as DOM object: " + e);
        }
        return topNode;
    }

    private static void addAttributeReferences(String origStr, Document aSPMLRequest, Node memberObjs, boolean bRequired) {
        if (origStr.length() > 0 && (origStr = SPMLUtil.cleanTrim(origStr)).length() > 0) {
            Vector v = MVDUtil.splitString(origStr, "$");
            for (int zz = 0; zz < v.size(); ++zz) {
                String a = (String)v.elementAt(zz);
                Element aObjs = aSPMLRequest.createElement("attributeDefinitionReference");
                String ref = a.trim();
                if (SPMLUtil.containsMxUnderlineAttrs(ref)) {
                    MVDLogger.Debug("Attribute name before patching " + ref);
                    ref = MVDUtil.replace(ref, "_", "-");
                    MVDLogger.Debug("Attribute name after patching " + ref);
                }
                aObjs.setAttribute("name", ref);
                aObjs.setAttribute("required", "" + bRequired);
                memberObjs.appendChild(aObjs);
            }
        }
    }

    private static String concatTokens(String aOrigStr, StringTokenizer matcher) {
        String loctoc = "";
        String str = aOrigStr;
        if (str.startsWith("'")) {
            if (!str.endsWith("'")) {
                do {
                    loctoc = matcher.nextToken();
                    str = str + " " + loctoc;
                } while (!loctoc.endsWith("'"));
            }
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    private static String cleanTrim(String aOrigStr) {
        String str = aOrigStr.trim();
        if (str.startsWith("(")) {
            str = str.substring(1);
        }
        if (str.endsWith(")")) {
            str = str.substring(0, str.length() - 1);
        }
        str = str.trim();
        return str;
    }

    private static Node TransformRespons(MxResponse aRespons, int aReqType, Document aSPMLRequest, MxRequest aRequest) {
        Element topNode = null;
        try {
            switch (aReqType) {
                case 0: {
                    MxAdd addreq;
                    topNode = aSPMLRequest.createElement("spml:addResponse");
                    if (!aRespons.isOK() || !(addreq = (MxAdd)aRequest).getDn().toLowerCase().startsWith("auto")) break;
                    Element idfel = aSPMLRequest.createElement("spml:identifier");
                    idfel.setAttribute("type", "urn:oasis:names:tc:SPML:1:0#GUID");
                    Element idel = aSPMLRequest.createElement("spml:id");
                    if (idel == null) break;
                    Text valNode = aSPMLRequest.createTextNode(addreq.getDn());
                    idel.appendChild(valNode);
                    idfel.appendChild(idel);
                    topNode.appendChild(idfel);
                    break;
                }
                case 1: {
                    topNode = aSPMLRequest.createElement("spml:deleteResponse");
                    break;
                }
                case 2: {
                    topNode = aSPMLRequest.createElement("spml:modifyResponse");
                }
            }
            if (!aRespons.isOK()) {
                topNode.setAttribute("result", "urn:oasis:names:tc:SPML:1:0#failure");
                String errorMessage = aRespons.getMessage();
                if (errorMessage != null && !errorMessage.equalsIgnoreCase("")) {
                    Element errorMessageNode = aSPMLRequest.createElement("spml:errorMessage");
                    errorMessageNode.appendChild(aSPMLRequest.createTextNode(errorMessage));
                    topNode.appendChild(errorMessageNode);
                }
            } else {
                topNode.setAttribute("result", "urn:oasis:names:tc:SPML:1:0#success");
            }
        }
        catch (Exception e) {
            System.out.println("Exception making respons as DOM object: " + e);
        }
        return topNode;
    }

    private static int mapOperation(String aOperation) {
        if (aOperation.equalsIgnoreCase("add")) {
            return 0;
        }
        if (aOperation.equalsIgnoreCase("delete")) {
            return 1;
        }
        if (aOperation.equalsIgnoreCase("replace")) {
            return 2;
        }
        return -1;
    }

    public static void main(String[] args) {
        String fileName = args[0];
        String request = MVDUtil.ReadFile(fileName, false, false);
        SPMLUtil.RequestTransform(request, new HashMap());
        boolean x = true;
    }
}

