/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.MVDGlobals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.message.MxAdd;
import com.sap.idm.vds.message.MxAttrSet;
import com.sap.idm.vds.message.MxDelete;
import com.sap.idm.vds.message.MxEntry;
import com.sap.idm.vds.message.MxModify;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.message.MxSearch;
import com.sap.idm.vds.util.DSMLUtil;
import com.sap.idm.vds.util.MxSPMLv2_Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.XMLMarshaller;
import org.openspml.v2.msg.spml.AddRequest;
import org.openspml.v2.msg.spml.AddResponse;
import org.openspml.v2.msg.spml.DeleteRequest;
import org.openspml.v2.msg.spml.DeleteResponse;
import org.openspml.v2.msg.spml.ErrorCode;
import org.openspml.v2.msg.spml.Extensible;
import org.openspml.v2.msg.spml.Modification;
import org.openspml.v2.msg.spml.ModificationMode;
import org.openspml.v2.msg.spml.ModifyRequest;
import org.openspml.v2.msg.spml.ModifyResponse;
import org.openspml.v2.msg.spml.PSO;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.msg.spml.StatusCode;
import org.openspml.v2.msg.spmlsearch.Query;
import org.openspml.v2.msg.spmlsearch.Scope;
import org.openspml.v2.msg.spmlsearch.SearchRequest;
import org.openspml.v2.msg.spmlsearch.SearchResponse;
import org.openspml.v2.profiles.DSMLProfileRegistrar;
import org.openspml.v2.profiles.dsml.AttributeDescription;
import org.openspml.v2.profiles.dsml.AttributeDescriptions;
import org.openspml.v2.profiles.dsml.DSMLAttr;
import org.openspml.v2.profiles.dsml.DSMLModification;
import org.openspml.v2.profiles.dsml.DSMLValue;
import org.openspml.v2.profiles.dsml.Filter;
import org.openspml.v2.util.xml.ObjectFactory;
import org.openspml.v2.util.xml.ReflectiveDOMXMLUnmarshaller;
import org.openspml.v2.util.xml.ReflectiveXMLMarshaller;

public class MxSPMLv2_DSMLTranformUtil {
    private static String mPatchingMode = "";

    public static MxRequest[] RequestTransform(Object aRequest, Object aSessionGlobals) {
        MxRequest[] mxReqs = null;
        mPatchingMode = MVDGlobals.getGlobalParameter("GLOBAL_UNDERLINE_PATCHING", "SAP");
        try {
            HashMap sessionGlobals = (HashMap)aSessionGlobals;
            String spmlRequest = null;
            String clientIP = null;
            Vector<Object> values = new Vector<Object>();
            if (aRequest instanceof String) {
                spmlRequest = (String)aRequest;
            } else {
                spmlRequest = ((HashMap)aRequest).get("MESSAGE").toString();
                clientIP = ((HashMap)aRequest).get("CLIENT_IP").toString();
            }
            if (spmlRequest.indexOf("urn:oasis:names:tc:SPML:1:0") != -1) {
                sessionGlobals.put("TRANSFORMATIONERROR", "SPMLv1");
                MVDLogger.Log("Request type is SPML v1 and not supported by the service. To support SPML v1 requests deploy the web service with the MxSPMLTransformClass transformation class.", 7);
                return mxReqs;
            }
            if (spmlRequest.indexOf("\"urn:oasis:names:tc:SPML:2:0\"") == -1) {
                if (spmlRequest.indexOf("urn:oasis:names:tc:DSML:2:0:core") != -1) {
                    sessionGlobals.put("TRANSFORMATIONERROR", "DSML");
                    MVDLogger.Log("Request type is DSML v2 and not supported by the web service. To support DSML v2 requests deploy the web service with the MxDSMLv2TransformClass transformation class.", 7);
                } else {
                    sessionGlobals.put("TRANSFORMATIONERROR", "UNDEFINED");
                    MVDLogger.Log("Request type is not supported by the web service. Deploy the web service with a customized transformation class to solve the problem.", 7);
                }
                return mxReqs;
            }
            ObjectFactory.getInstance().register((ObjectFactory.ProfileRegistrar)new DSMLProfileRegistrar());
            ReflectiveDOMXMLUnmarshaller unMarshaller = new ReflectiveDOMXMLUnmarshaller();
            Request request = (Request)unMarshaller.unmarshall(spmlRequest);
            values.add("SINGLE");
            values.add(new Vector());
            sessionGlobals.put(aRequest, values);
            mxReqs = new MxRequest[]{MxSPMLv2_DSMLTranformUtil.RequestTransform(aRequest, request, sessionGlobals)};
        }
        catch (Exception e) {
            e.printStackTrace();
            MVDLogger.Debug("Could not transform SPML v2 request");
        }
        return mxReqs;
    }

    private static MxRequest RequestTransform(Object aOrgReq, Request aSPMLRequest, HashMap aSessionGlobals) {
        MxRequest request = null;
        String requestType = "";
        try {
            if (aSPMLRequest instanceof SearchRequest) {
                requestType = "search";
                request = MxSPMLv2_DSMLTranformUtil.transformSearchRequest(aOrgReq, aSPMLRequest, aSessionGlobals);
            } else {
                Vector values = (Vector)aSessionGlobals.get(aOrgReq);
                Vector actions = (Vector)values.get(1);
                if (aSPMLRequest instanceof AddRequest) {
                    requestType = "add";
                    actions.add("MxAdd");
                    request = MxSPMLv2_DSMLTranformUtil.transformAddRequest(aOrgReq, aSPMLRequest);
                } else if (aSPMLRequest instanceof DeleteRequest) {
                    requestType = "delete";
                    actions.add("MxDelete");
                    request = MxSPMLv2_DSMLTranformUtil.transformDelRequest(aSPMLRequest);
                } else {
                    requestType = "modify";
                    actions.add("MxModify");
                    request = MxSPMLv2_DSMLTranformUtil.transformModRequest(aSPMLRequest);
                }
                values.set(1, actions);
                aSessionGlobals.put(aOrgReq, values);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MVDLogger.Debug("Error transforming SPML " + requestType + " request.");
        }
        return request;
    }

    private static MxRequest transformSearchRequest(Object aOrgReq, Request aSPMLRequest, HashMap aSessionGlobals) throws Exception {
        String startingPoint;
        Vector values = (Vector)aSessionGlobals.get(aOrgReq);
        Vector<String> reqAttrs = new Vector<String>();
        SearchRequest spmlRequest = (SearchRequest)aSPMLRequest;
        MxSearch search = new MxSearch();
        Query query = spmlRequest.getQuery();
        int sizeLimit = spmlRequest.getMaxSelect();
        if (sizeLimit > 0) {
            search.setSizeLimit(sizeLimit);
        }
        if ((startingPoint = query.getBasePsoID().getID()) == null) {
            startingPoint = "";
        }
        search.setStartingPoint(startingPoint);
        int scope = 0;
        if (query.getScope() == Scope.ONELEVEL) {
            scope = 1;
        } else if (query.getScope() == Scope.SUBTREE) {
            scope = 2;
        }
        search.setOperationScope(scope);
        OpenContentElement[] contents = query.getOpenContentElements();
        for (int i = 0; i < contents.length; ++i) {
            OpenContentElement content = contents[i];
            if (content instanceof AttributeDescriptions) {
                AttributeDescriptions attrDescs = (AttributeDescriptions)content;
                AttributeDescription[] spmlAttrs = attrDescs.getAttributeDescriptions();
                for (int attrCounter = 0; attrCounter < spmlAttrs.length; ++attrCounter) {
                    AttributeDescription spmlAttr = spmlAttrs[attrCounter];
                    String attributeName = spmlAttr.getName();
                    if (MxSPMLv2_DSMLTranformUtil.containsMxDashAttrs(attributeName)) {
                        MVDLogger.Debug("Attribute name before patching " + attributeName);
                        attributeName = MVDUtil.replace(attributeName, "-", "_");
                        attributeName = MVDUtil.replace(attributeName, "&#95", "_");
                        MVDLogger.Debug("Attribute name after patching " + attributeName);
                    }
                    reqAttrs.add(attributeName);
                }
                search.setRequestedAttributes(reqAttrs);
            }
            if (!(content instanceof Filter)) continue;
            Filter spmlFilter = (Filter)content;
            String filter = MxSPMLv2_Util.getLDAPFilter(spmlFilter, mPatchingMode);
            search.setRequestedFilter(filter);
        }
        Vector temp = (Vector)values.get(1);
        if (reqAttrs != null && !reqAttrs.isEmpty()) {
            temp.add(reqAttrs);
        } else {
            temp.add("MxSearch");
        }
        aSessionGlobals.put(aOrgReq, values);
        return search;
    }

    private static boolean containsMxDashAttrs(String aSource) {
        if (aSource == null) {
            return false;
        }
        return mPatchingMode.equalsIgnoreCase("SAP") ? aSource.startsWith("MXREF-") || aSource.startsWith("mxref-") || aSource.startsWith("MXMEMBER-") || aSource.startsWith("mxmember-") || aSource.startsWith("MX-") || aSource.startsWith("mx-") : aSource.indexOf("-") >= 0;
    }

    private static boolean containsMxUnderlineAttrs(String aSource) {
        if (aSource == null) {
            return false;
        }
        return mPatchingMode.equalsIgnoreCase("SAP") ? aSource.startsWith("MXREF_") || aSource.startsWith("mxref_") || aSource.startsWith("MXMEMBER_") || aSource.startsWith("mxmember_") || aSource.startsWith("MX_") || aSource.startsWith("mx_") : aSource.indexOf("_") >= 0;
    }

    private static MxAdd transformAddRequest(Object aOrgReq, Request aSPMLRequest) throws Exception {
        MxAdd add = new MxAdd();
        AddRequest request = (AddRequest)aSPMLRequest;
        String dn = request.getPsoID().getID();
        if (dn == null) {
            dn = "";
        }
        add.setDn(dn);
        Extensible contents = request.getData();
        OpenContentElement[] datas = contents.getOpenContentElements();
        HashMap attrsAndValues = new HashMap();
        for (int i = 0; i < datas.length; ++i) {
            OpenContentElement content = datas[i];
            if (!(content instanceof DSMLAttr)) continue;
            DSMLAttr attr = (DSMLAttr)content;
            Vector<String> vals = new Vector<String>();
            DSMLValue[] values = attr.getValues();
            for (int valueCounter = 0; valueCounter < values.length; ++valueCounter) {
                String tmpvalue = DSMLUtil.ReverseMapIllegalXMLChars(values[valueCounter].getValue());
                vals.add(tmpvalue);
            }
            String attributeName = attr.getName();
            if (MxSPMLv2_DSMLTranformUtil.containsMxDashAttrs(attributeName)) {
                MVDLogger.Debug("Attribute name before patching " + attributeName);
                attributeName = MVDUtil.replace(attributeName, "-", "_");
                attributeName = MVDUtil.replace(attributeName, "&#95", "_");
                MVDLogger.Debug("Attribute name after patching " + attributeName);
            }
            attrsAndValues.put(attributeName, vals);
        }
        add.setAttrSetAndValues(new MxAttrSet(attrsAndValues));
        return add;
    }

    private static MxModify transformModRequest(Request aSPMLRequest) throws Exception {
        MxModify modify = new MxModify();
        ModifyRequest request = (ModifyRequest)aSPMLRequest;
        String dn = request.getPsoID().getID();
        if (dn == null) {
            dn = "";
        }
        modify.setDn(dn);
        Modification[] modifications = request.getModifications();
        Vector<MVDModAttrValues> mvdMods = new Vector<MVDModAttrValues>();
        for (int i = 0; i < modifications.length; ++i) {
            Modification mod = modifications[i];
            OpenContentElement[] contents = mod.getOpenContentElements();
            for (int counter = 0; counter < contents.length; ++counter) {
                OpenContentElement content = contents[counter];
                if (!(content instanceof DSMLModification)) continue;
                DSMLModification dsmlMod = (DSMLModification)content;
                int mvdOperMode = MxSPMLv2_DSMLTranformUtil.getMVDOperationMode(dsmlMod.getOperation());
                String attr = dsmlMod.getName();
                DSMLValue[] values = dsmlMod.getValues();
                MVDModAttrValues modification = new MVDModAttrValues();
                if (MxSPMLv2_DSMLTranformUtil.containsMxDashAttrs(attr)) {
                    MVDLogger.Debug("Attribute name before patching " + attr);
                    attr = MVDUtil.replace(attr, "-", "_");
                    attr = MVDUtil.replace(attr, "&#95", "_");
                    MVDLogger.Debug("Attribute name after patching " + attr);
                }
                modification.setAttrName(attr);
                modification.setModType(mvdOperMode);
                for (int valCounter = 0; valCounter < values.length; ++valCounter) {
                    DSMLValue value = values[valCounter];
                    String tmpvalue = DSMLUtil.ReverseMapIllegalXMLChars(value.getValue());
                    modification.add(tmpvalue);
                }
                mvdMods.add(modification);
            }
        }
        modify.setAttrAndModValues(mvdMods);
        return modify;
    }

    private static int getMVDOperationMode(ModificationMode aMode) {
        if (aMode == ModificationMode.ADD) {
            return 0;
        }
        if (aMode == ModificationMode.DELETE) {
            return 1;
        }
        return 2;
    }

    private static MxDelete transformDelRequest(Request aSPMLRequest) throws Exception {
        MxDelete delete = new MxDelete();
        DeleteRequest request = (DeleteRequest)aSPMLRequest;
        String dn = request.getPsoID().getID();
        if (dn == null) {
            dn = "";
        }
        delete.setDn(dn);
        return delete;
    }

    public static Object ResponseTransform(MxResponse[] aResponses, Object aOrgReq, Object aSessionGlobals, MxRequest[] aRequests) {
        HashMap sessionGlobals = (HashMap)aSessionGlobals;
        if (sessionGlobals.containsKey("TRANSFORMATIONERROR")) {
            return "TRANSFORMATIONERROR_SPMLv2";
        }
        Vector values = (Vector)sessionGlobals.get(aOrgReq);
        values = (Vector)values.get(1);
        String response = "";
        MxResponse respons = null;
        try {
            for (int i = 0; i < aResponses.length; ++i) {
                Object reqObj = values.get(i);
                try {
                    respons = aResponses[i];
                    Response spmlV2Response = MxSPMLv2_DSMLTranformUtil.ResponseTransform(respons, aOrgReq, reqObj, aRequests[i]);
                    ObjectFactory.getInstance().register((ObjectFactory.ProfileRegistrar)new DSMLProfileRegistrar());
                    ReflectiveXMLMarshaller xmlMarshaller = new ReflectiveXMLMarshaller();
                    response = spmlV2Response.toXML((XMLMarshaller)xmlMarshaller);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return MxSPMLv2_DSMLTranformUtil.createErrorResponse((String)reqObj, ErrorCode.MALFORMED_REQUEST, e.getMessage());
                }
            }
            sessionGlobals.remove(aResponses);
        }
        catch (Exception e) {
            e.printStackTrace();
            MVDLogger.Debug("Error transforming response");
            return null;
        }
        return response;
    }

    private static Response ResponseTransform(MxResponse aResponse, Object aOrgReq, Object aReqObj, MxRequest aRequest) throws Exception {
        Response response = null;
        if (aReqObj instanceof Vector) {
            Vector reqAttr = (Vector)aReqObj;
            if (reqAttr.size() == 1) {
                reqAttr = new Vector();
            }
            response = MxSPMLv2_DSMLTranformUtil.transformSearchRespons(aResponse, reqAttr);
        } else {
            String reqTypeName = (String)aReqObj;
            response = reqTypeName.equalsIgnoreCase("MxSearch") ? MxSPMLv2_DSMLTranformUtil.transformSearchRespons(aResponse, new Vector()) : MxSPMLv2_DSMLTranformUtil.transformResponse(aResponse, reqTypeName, aRequest);
        }
        return response;
    }

    private static Response createErrorResponse(String aRequestType, ErrorCode aErroCode, String aErrorMsg) {
        DeleteResponse spmlResp = null;
        if (aRequestType.equalsIgnoreCase("MxDelete")) {
            spmlResp = new DeleteResponse();
        } else if (aRequestType.equalsIgnoreCase("MxModify")) {
            spmlResp = new ModifyResponse();
        } else if (aRequestType.equalsIgnoreCase("MxAdd")) {
            spmlResp = new AddResponse();
        }
        spmlResp.setError(aErroCode);
        spmlResp.setStatus(StatusCode.FAILURE);
        if (aErrorMsg != null && aErrorMsg.length() > 0) {
            spmlResp.addErrorMessage(aErrorMsg);
        }
        return spmlResp;
    }

    private static Response transformResponse(MxResponse aRespons, String aRequestType, MxRequest aRequest) throws Exception {
        DeleteResponse spmlResp = null;
        if (aRequestType.equalsIgnoreCase("MxDelete")) {
            spmlResp = new DeleteResponse();
        } else if (aRequestType.equalsIgnoreCase("MxModify")) {
            spmlResp = new ModifyResponse();
        } else {
            spmlResp = new AddResponse();
            String dn = ((MxAdd)aRequest).getDn();
            PSOIdentifier identifier = new PSOIdentifier();
            identifier.setID(dn);
            PSO pso = new PSO();
            pso.setPsoID(identifier);
            ((AddResponse)spmlResp).setPso(pso);
        }
        if (!aRespons.isOK()) {
            spmlResp.setStatus(StatusCode.FAILURE);
            if (aRespons.getMessage() != null) {
                spmlResp.addErrorMessage(aRespons.getMessage());
            } else {
                spmlResp.addErrorMessage("No errormessage supplied");
            }
            int errorCode = aRespons.getCode();
            switch (errorCode) {
                case 68: {
                    spmlResp.setError(ErrorCode.ALREADY_EXISTS);
                    break;
                }
                case 32: {
                    spmlResp.setError(ErrorCode.NO_SUCH_IDENTIFIER);
                    break;
                }
                case 4: {
                    spmlResp.setError(ErrorCode.RESULT_SET_TOO_LARGE);
                    break;
                }
                default: {
                    spmlResp.setError(ErrorCode.CUSTOM_ERROR);
                    break;
                }
            }
        } else {
            spmlResp.setStatus(StatusCode.SUCCESS);
        }
        for (int entryCounter = 0; entryCounter < aRespons.size(); ++entryCounter) {
            MxEntry entry = aRespons.getEntry(entryCounter);
            spmlResp.setRequestID(entry.getDn());
        }
        return spmlResp;
    }

    private static Response transformSearchRespons(MxResponse aRespons, Vector aReqAttrs) throws Exception {
        SearchResponse spmlResp = new SearchResponse();
        int errorCode = aRespons.getCode();
        if (!aRespons.isOK()) {
            spmlResp.setStatus(StatusCode.FAILURE);
            if (aRespons.getMessage() != null) {
                spmlResp.addErrorMessage(aRespons.getMessage());
            } else {
                spmlResp.addErrorMessage("No errormessage supplied");
            }
            switch (errorCode) {
                case 68: {
                    spmlResp.setError(ErrorCode.ALREADY_EXISTS);
                    break;
                }
                case 32: {
                    spmlResp.setError(ErrorCode.NO_SUCH_IDENTIFIER);
                    break;
                }
                default: {
                    spmlResp.setError(ErrorCode.CUSTOM_ERROR);
                }
            }
            return spmlResp;
        }
        if (errorCode == 4) {
            spmlResp.setStatus(StatusCode.FAILURE);
            spmlResp.setError(ErrorCode.RESULT_SET_TOO_LARGE);
        } else {
            spmlResp.setStatus(StatusCode.SUCCESS);
        }
        for (int entryCounter = 0; entryCounter < aRespons.size(); ++entryCounter) {
            MxEntry entry = aRespons.getEntry(entryCounter);
            PSOIdentifier identifier = new PSOIdentifier();
            identifier.setID(entry.getDn());
            PSO pso = new PSO();
            pso.setPsoID(identifier);
            HashMap returnedAttrs = entry.getAttrAndValues();
            if (returnedAttrs != null && !returnedAttrs.isEmpty()) {
                String key;
                Extensible data = new Extensible();
                if (aReqAttrs != null && !aReqAttrs.isEmpty()) {
                    for (int attrCounter = 0; attrCounter < aReqAttrs.size(); ++attrCounter) {
                        key = aReqAttrs.get(attrCounter).toString();
                        if (!returnedAttrs.containsKey(key)) continue;
                        Vector returnedValues = (Vector)returnedAttrs.get(key);
                        if (MxSPMLv2_DSMLTranformUtil.containsMxUnderlineAttrs(key)) {
                            MVDLogger.Debug("Attribute name before patching " + key);
                            key = MVDUtil.replace(key, "_", "-");
                            key = MVDUtil.replace(key, "_", "&#95");
                            MVDLogger.Debug("Attribute name after patching " + key);
                        }
                        DSMLValue[] values = new DSMLValue[returnedValues.size()];
                        if (returnedValues.isEmpty()) continue;
                        DSMLAttr attr = null;
                        if (returnedValues.size() == 0) {
                            attr = new DSMLAttr(key, "");
                        } else if (returnedValues.size() == 1) {
                            attr = new DSMLAttr(key, returnedValues.elementAt(0).toString());
                        } else {
                            for (int valueCount = 0; valueCount < returnedValues.size(); ++valueCount) {
                                String val = (String)returnedValues.get(valueCount);
                                if (val.length() == 0) {
                                    val = "-empty-string-";
                                }
                                if (attr == null) {
                                    attr = new DSMLAttr(key, val);
                                    continue;
                                }
                                attr.addValue(new DSMLValue(val));
                            }
                        }
                        data.addOpenContentElement((OpenContentElement)attr);
                    }
                    pso.setData(data);
                } else {
                    Iterator attrCounter = returnedAttrs.keySet().iterator();
                    while (attrCounter.hasNext()) {
                        key = attrCounter.next().toString();
                        if (!returnedAttrs.containsKey(key)) continue;
                        Vector vals = (Vector)returnedAttrs.get(key);
                        if (MxSPMLv2_DSMLTranformUtil.containsMxUnderlineAttrs(key)) {
                            MVDLogger.Debug("Attribute name before patching " + key);
                            key = MVDUtil.replace(key, "_", "-");
                            key = MVDUtil.replace(key, "_", "&#95");
                            MVDLogger.Debug("Attribute name after patching " + key);
                        }
                        DSMLAttr attr = null;
                        if (vals.size() == 0) {
                            attr = new DSMLAttr(key, "");
                        } else if (vals.size() == 1) {
                            attr = new DSMLAttr(key, vals.elementAt(0).toString());
                        } else {
                            for (int valueCount = 0; valueCount < vals.size(); ++valueCount) {
                                String val = (String)vals.get(valueCount);
                                if (val.length() == 0) {
                                    val = "-empty-string-";
                                }
                                if (attr == null) {
                                    attr = new DSMLAttr(key, val);
                                    continue;
                                }
                                attr.addValue(new DSMLValue(val));
                            }
                        }
                        data.addOpenContentElement((OpenContentElement)attr);
                    }
                    pso.setData(data);
                }
            }
            spmlResp.addPSO(pso);
        }
        return spmlResp;
    }
}

