/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.filter.MVDFilter;
import com.sap.idm.vds.filter.MVDFilterUtilities;
import com.sap.idm.vds.util.MxSPMLv2_Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openspml.v2.msg.spml.ModificationMode;
import org.openspml.v2.profiles.dsml.AttributeDescription;
import org.openspml.v2.profiles.dsml.AttributeDescriptions;
import org.openspml.v2.profiles.dsml.DSMLAttr;
import org.openspml.v2.profiles.dsml.DSMLModification;
import org.openspml.v2.profiles.dsml.DSMLValue;
import org.openspml.v2.profiles.dsml.Filter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MxMVD_DSML {
    private Document mRequest = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    private Element mReqRoot = this.mRequest.createElement("dsml:batchRequest");

    public MxMVD_DSML() throws Exception {
        this.mReqRoot.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        this.mReqRoot.setAttribute("xmlns:dsml", "urn:oasis:names:tc:DSML:2:0:core");
        this.mRequest.appendChild(this.mReqRoot);
    }

    public String search_ToDSML(String aStartingPoint, int aScope, String aFilter, Vector aAttributes) throws Exception {
        String attr;
        Element reqElem = this.mRequest.createElement("searchRequest");
        reqElem.setAttribute("dn", aStartingPoint);
        reqElem.setAttribute("derefAliases", "neverDerefAliases");
        String scope = "wholeSubtree";
        if (aScope == 0) {
            scope = "baseObject";
        } else if (aScope == 1) {
            scope = "singleLevel";
        }
        reqElem.setAttribute("scope", scope);
        MVDFilter aMVDFilter = MVDFilterUtilities.constructFilter(aFilter);
        Filter dsmlFilter = MxSPMLv2_Util.convertMVDFilterToSPMLv2Filter(aMVDFilter);
        aFilter = dsmlFilter.toXML();
        Node filter = MVDUtilities.ConvertFromStringToDOM(aFilter).getDocumentElement();
        filter = this.mRequest.importNode(filter, true);
        reqElem.appendChild(filter);
        AttributeDescription[] attrsDescs = new AttributeDescription[aAttributes.size()];
        for (int i = 0; i < aAttributes.size() && (attr = (String)aAttributes.get(i)) != null && !attr.equalsIgnoreCase("") && !attr.equalsIgnoreCase("*"); ++i) {
            attrsDescs[i] = new AttributeDescription(attr);
        }
        AttributeDescriptions attrRoot = new AttributeDescriptions();
        if (attrsDescs != null && attrsDescs.length > 0) {
            new AttributeDescriptions(attrsDescs);
        }
        Node attributes = MVDUtilities.ConvertFromStringToDOM(attrRoot.toXML()).getDocumentElement();
        attributes = this.mRequest.importNode(attributes, true);
        reqElem.appendChild(attributes);
        this.mReqRoot.appendChild(reqElem);
        return this.stripOfRoot();
    }

    private String stripOfRoot() {
        String dsmlRequest = MVDUtilities.ConvertFromDOMToString(this.mRequest);
        String stripOf = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        dsmlRequest = dsmlRequest.substring(dsmlRequest.indexOf(stripOf) + stripOf.length());
        return dsmlRequest;
    }

    public Object toMVD(String aDSMLResponse) throws Exception {
        Document DSMLRequestAsDOM = MVDUtilities.ConvertFromStringToDOM(aDSMLResponse);
        Element batchRoot = DSMLRequestAsDOM.getDocumentElement();
        String nodeName = null;
        nodeName = batchRoot.getLocalName();
        while (!nodeName.equalsIgnoreCase("batchResponse")) {
            batchRoot = (Element)batchRoot.getFirstChild();
            nodeName = batchRoot.getLocalName();
        }
        NodeList nl = batchRoot.getChildNodes();
        boolean isSearch = this.isSearch(nl);
        if (nl == null || nl.getLength() == 0) {
            return null;
        }
        int i = 0;
        Node childNode = nl.item(i);
        while (childNode.getNodeType() == 3) {
            childNode = childNode.getNextSibling();
        }
        batchRoot = (Element)childNode;
        nl = batchRoot.getChildNodes();
        String code = null;
        String desc = null;
        String message = null;
        if (!isSearch) {
            MVDOperationResult response = new MVDOperationResult();
            for (i = 0; i < nl.getLength(); ++i) {
                childNode = nl.item(i);
                if (childNode.getNodeType() == 3 || !(nodeName = childNode.getLocalName()).equalsIgnoreCase("resultCode")) continue;
                code = ((Element)childNode).getAttribute("code");
                desc = ((Element)childNode).getAttribute("desc");
                NodeList messages = childNode.getChildNodes();
                for (int messCounter = 0; messCounter < messages.getLength(); ++messCounter) {
                    Node messNode = messages.item(messCounter);
                    if (messNode.getNodeType() == 3 || !messNode.getLocalName().equalsIgnoreCase("errorMessage")) continue;
                    message = messNode.getFirstChild().getNodeValue();
                    response.setError(message);
                }
            }
            response.setOK(Integer.parseInt(code), desc);
            if (code.equalsIgnoreCase("0")) {
                response.setOK();
            }
            return response;
        }
        MVDSearchResults response = new MVDSearchResults();
        for (i = 0; i < nl.getLength(); ++i) {
            childNode = nl.item(i);
            if (childNode.getNodeType() == 3) continue;
            nodeName = childNode.getNodeName();
            if (nodeName.equalsIgnoreCase("searchResultDone")) {
                NodeList results = childNode.getChildNodes();
                for (int resCounter = 0; resCounter < results.getLength(); ++resCounter) {
                    Node result = results.item(resCounter);
                    if (result.getNodeType() == 3) continue;
                    String resultName = result.getNodeName();
                    if (resultName.equalsIgnoreCase("resultCode")) {
                        code = ((Element)result).getAttribute("code");
                        desc = ((Element)result).getAttribute("desc");
                        continue;
                    }
                    if (!resultName.equalsIgnoreCase("errorMessage")) continue;
                    message = result.getFirstChild().getNodeValue();
                }
                continue;
            }
            if (!nodeName.equalsIgnoreCase("searchResultEntry")) continue;
            MVDSearchResultEntry entry = new MVDSearchResultEntry();
            String dn = ((Element)childNode).getAttribute("dn");
            entry.setDn(dn);
            NodeList attrs = childNode.getChildNodes();
            for (int attrCounter = 0; attrCounter < attrs.getLength(); ++attrCounter) {
                String attrName;
                Node attr = attrs.item(attrCounter);
                if (attr.getNodeType() == 3 || !(attrName = attr.getLocalName()).equalsIgnoreCase("attr")) continue;
                attrName = ((Element)attr).getAttribute("name");
                NodeList values = attr.getChildNodes();
                Vector<String> mvdValues = new Vector<String>();
                for (int valueCounter = 0; valueCounter < values.getLength(); ++valueCounter) {
                    Node value = values.item(valueCounter);
                    if (value == null || value.getNodeType() == 3 || value.getFirstChild() == null) continue;
                    mvdValues.add(value.getFirstChild().getNodeValue());
                }
                entry.setAttrValue(attrName, true, mvdValues);
            }
            response.add(entry);
        }
        response.setOK(Integer.parseInt(code), desc);
        if (code.equalsIgnoreCase("0")) {
            response.setOK();
        }
        return response;
    }

    private boolean isSearch(NodeList aBatchRootChilds) {
        for (int i = 0; i < aBatchRootChilds.getLength(); ++i) {
            String batchRootChildName;
            Node batchRootChild = aBatchRootChilds.item(i);
            if (batchRootChild.getNodeType() == 3 || !(batchRootChildName = batchRootChild.getLocalName()).equalsIgnoreCase("searchResponse")) continue;
            return true;
        }
        return false;
    }

    public String add_ToDSML(String aDN, HashMap aAttrNamesAndValues) throws Exception {
        Element reqElem = this.mRequest.createElement("addRequest");
        reqElem.setAttribute("dn", aDN);
        Iterator iter = aAttrNamesAndValues.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            String key = (String)element.getKey();
            Object valObject = element.getValue();
            DSMLAttr attr = null;
            if (valObject instanceof Vector) {
                Vector vals = (Vector)valObject;
                if (vals.size() == 0) {
                    attr = new DSMLAttr(key, "");
                } else if (vals.size() == 1) {
                    attr = new DSMLAttr(key, (String)vals.elementAt(0));
                } else {
                    attr = new DSMLAttr(key, (String)vals.elementAt(0));
                    for (int valueCount = 1; valueCount < vals.size(); ++valueCount) {
                        String val = (String)vals.get(valueCount);
                        attr.addValue(new DSMLValue(val));
                    }
                }
            } else {
                attr = new DSMLAttr(key, valObject.toString());
            }
            Node attrElem = MVDUtilities.ConvertFromStringToDOM(attr.toXML()).getDocumentElement();
            if ((attrElem = this.mRequest.importNode(attrElem, true)).hasAttribute("xmlns:dsml")) {
                ((Element)attrElem).removeAttribute("xmlns:dsml");
            }
            reqElem.appendChild(attrElem);
        }
        this.mReqRoot.appendChild(reqElem);
        return this.stripOfRoot();
    }

    public String parseModify(String aDN, Vector aModAndValues) throws Exception {
        Element reqElem = this.mRequest.createElement("modifyRequest");
        reqElem.setAttribute("dn", aDN);
        Iterator iter = aModAndValues.iterator();
        while (iter.hasNext()) {
            MVDModAttrValues modVal = (MVDModAttrValues)iter.next();
            String attrName = modVal.getAttrName();
            ModificationMode mode = ModificationMode.REPLACE;
            if (modVal.getModType() == 0) {
                mode = ModificationMode.ADD;
            } else if (modVal.getModType() == 1) {
                mode = ModificationMode.DELETE;
            }
            DSMLModification dsmlMod = null;
            if (modVal == null) continue;
            dsmlMod = new DSMLModification(attrName, (String)modVal.get(0), mode);
            for (int i = 1; i < modVal.size(); ++i) {
                dsmlMod.addValue(new DSMLValue((String)modVal.get(i)));
            }
            Node modElem = MVDUtilities.ConvertFromStringToDOM(dsmlMod.toXML()).getDocumentElement();
            if ((modElem = this.mRequest.importNode(modElem, true)).hasAttribute("xmlns:dsml")) {
                ((Element)modElem).removeAttribute("xmlns:dsml");
            }
            reqElem.appendChild(modElem);
        }
        this.mReqRoot.appendChild(reqElem);
        return this.stripOfRoot();
    }

    public String parseDelete(String aDN) {
        Element reqElem = this.mRequest.createElement("delRequest");
        reqElem.setAttribute("dn", aDN);
        this.mReqRoot.appendChild(reqElem);
        return this.stripOfRoot();
    }

    public String parseCompare(String aDN, String aAttr, String aValue) throws Exception {
        Element reqElem = this.mRequest.createElement("compareRequest");
        reqElem.setAttribute("dn", aDN);
        Element compareElem = this.mRequest.createElement("assertion");
        compareElem.setAttribute("name", aAttr);
        Element value = this.mRequest.createElement("value");
        value.appendChild(this.mRequest.createTextNode(aValue));
        compareElem.appendChild(value);
        reqElem.appendChild(compareElem);
        this.mRequest.appendChild(reqElem);
        return this.stripOfRoot();
    }
}

