/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.MVDAttributeFixInterface;
import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.config.MVDRule;
import com.sap.idm.vds.config.SyntaxMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.LimitExceededException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.ReferralException;
import javax.naming.ServiceUnavailableException;
import javax.naming.SizeLimitExceededException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SchemaViolationException;

public class MVDOpUtilities {
    private static final String stringPlusReplacer = "<aStringPlus>";
    private static Class[] argClass = new Class[1];
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$HashMap;

    public static Vector ConvertAttributes(Vector tmpReqAttr, HashMap AttrMapping) {
        if (tmpReqAttr == null || tmpReqAttr.size() == 0) {
            return new Vector();
        }
        if (AttrMapping == null) {
            return new Vector(tmpReqAttr);
        }
        int ls = tmpReqAttr.size();
        Vector<String> toBeReturned = new Vector<String>(ls, 5);
        for (int x = 0; x < ls; ++x) {
            String origV = (String)tmpReqAttr.elementAt(x);
            String mapTo = (String)AttrMapping.get(origV);
            if (mapTo == null) {
                mapTo = origV;
            }
            toBeReturned.addElement(mapTo);
        }
        return toBeReturned;
    }

    public static void ConvertMODAttributes(Vector tmpReqAttr, HashMap AttrMapping) {
        if (tmpReqAttr == null || tmpReqAttr.size() == 0) {
            return;
        }
        if (AttrMapping == null) {
            return;
        }
        int ls = tmpReqAttr.size();
        for (int x = 0; x < ls; ++x) {
            MVDModAttrValues mvdmod = (MVDModAttrValues)tmpReqAttr.elementAt(x);
            String origV = mvdmod.getAttrName();
            String mapTo = (String)AttrMapping.get(origV);
            if (mapTo == null) continue;
            mvdmod.setAttrName(mapTo);
        }
    }

    public static HashMap ConvertAttributes(HashMap tmpResAttrAndValues, HashMap AttrMapping) {
        if (tmpResAttrAndValues == null || tmpResAttrAndValues.size() == 0) {
            return new HashMap();
        }
        if (AttrMapping == null) {
            return new HashMap(tmpResAttrAndValues);
        }
        HashMap toBeReturned = new HashMap();
        Iterator itAttrs = tmpResAttrAndValues.keySet().iterator();
        while (itAttrs.hasNext()) {
            String toBeMapped = (String)itAttrs.next();
            String mapTo = (String)AttrMapping.get(toBeMapped);
            if (mapTo == null) {
                mapTo = toBeMapped;
            }
            toBeReturned.put(mapTo, tmpResAttrAndValues.get(toBeMapped));
        }
        return toBeReturned;
    }

    public static void ConstructAttributes(HashMap tmpResAttrAndValues, HashMap AttrConstruct, HashMap hIfExists) {
        if (AttrConstruct == null) {
            return;
        }
        HashMap toBeReturned = tmpResAttrAndValues;
        String constructPart = "";
        Vector origVal = null;
        boolean doLog = MVDLogger.IsLogging(2);
        Iterator itFrom = AttrConstruct.keySet().iterator();
        while (itFrom.hasNext()) {
            Vector vectorFrom;
            String valueFrom;
            Vector v;
            String constructFrom = (String)itFrom.next();
            String constructTo = (String)AttrConstruct.get(constructFrom);
            int doIfExists = 0;
            String igg = (String)hIfExists.get(constructTo);
            if (igg != null) {
                doIfExists = igg.equalsIgnoreCase("i") ? 0 : (igg.equalsIgnoreCase("o") ? 1 : 2);
            }
            if ((origVal = (Vector)tmpResAttrAndValues.get(constructTo)) != null && doIfExists == 0) continue;
            boolean containsStringPlus = false;
            if (constructFrom.indexOf("\\+") > 0) {
                constructFrom = MVDUtil.replace(constructFrom, "\\+", stringPlusReplacer);
                containsStringPlus = true;
                if (doLog) {
                    MVDLogger.Log("ConstructAttr: Contains plus as a constant string.", 0);
                }
            }
            if ((v = MVDUtil.splitString(constructFrom, "+")).size() == 1) {
                constructPart = ((String)v.elementAt(0)).trim();
                if (constructPart.startsWith("\"")) {
                    valueFrom = constructPart.substring(1, constructPart.length() - 1);
                } else {
                    vectorFrom = (Vector)tmpResAttrAndValues.get(constructPart);
                    if (vectorFrom == null) {
                        valueFrom = "";
                        if (doLog) {
                            MVDLogger.Log("ConstructAttr: Could not find " + constructPart, 2);
                        }
                    } else {
                        valueFrom = (String)vectorFrom.elementAt(0);
                    }
                }
            } else {
                valueFrom = "";
                for (int x = 0; x < v.size(); ++x) {
                    String tempVal;
                    constructPart = ((String)v.elementAt(x)).trim();
                    if (constructPart.startsWith("\"")) {
                        tempVal = constructPart.substring(1, constructPart.length() - 1);
                    } else {
                        vectorFrom = (Vector)tmpResAttrAndValues.get(constructPart);
                        if (vectorFrom == null) {
                            tempVal = "";
                            if (doLog) {
                                MVDLogger.Log("ConstructAttr: Could not find " + constructPart, 2);
                            }
                        } else {
                            tempVal = (String)vectorFrom.elementAt(0);
                        }
                    }
                    valueFrom = valueFrom + tempVal;
                }
            }
            if (valueFrom == null || valueFrom.length() <= 0) continue;
            if (containsStringPlus) {
                valueFrom = MVDUtil.replace(valueFrom, stringPlusReplacer, "+");
            }
            if (doIfExists == 1 || doIfExists == 0 || doIfExists == 2 && origVal == null) {
                Vector<String> rlt = new Vector<String>();
                rlt.add(valueFrom);
                toBeReturned.put(constructTo, rlt);
                continue;
            }
            origVal.add(valueFrom);
            toBeReturned.put(constructTo, origVal);
        }
    }

    public static void CleanREQAttributesByVector(Vector vAttr, Vector vCleanBy, boolean bKeepFields) {
        if (vCleanBy == null) {
            return;
        }
        if (bKeepFields) {
            boolean bSetBack = false;
            if (vAttr.contains("*")) {
                bSetBack = true;
            }
            vAttr.retainAll(vCleanBy);
            if (bSetBack && !vAttr.contains("*")) {
                vAttr.add("*");
            }
        } else {
            vAttr.removeAll(vCleanBy);
        }
    }

    public static void CleanREQAttributesByHash(Vector vAttr, HashMap hCleanBy, boolean bKeepFields) {
        if (hCleanBy == null) {
            return;
        }
        if (bKeepFields) {
            boolean bSetBack = false;
            if (vAttr.contains("*")) {
                bSetBack = true;
            }
            vAttr.retainAll(hCleanBy.keySet());
            if (bSetBack && !vAttr.contains("*")) {
                vAttr.add("*");
            }
        } else {
            vAttr.removeAll(hCleanBy.keySet());
        }
    }

    public static void CleanRESAttributesByVector(HashMap hAttr, Vector vCleanBy, boolean bKeepFields) {
        if (vCleanBy == null) {
            return;
        }
        if (vCleanBy.contains("*")) {
            return;
        }
        if (bKeepFields) {
            hAttr.keySet().retainAll(vCleanBy);
        } else {
            hAttr.keySet().removeAll(vCleanBy);
        }
    }

    public static void CleanRESAttributesByHash(HashMap hAttr, HashMap hCleanBy, boolean bKeepFields) {
        if (hCleanBy == null) {
            return;
        }
        if (hCleanBy.keySet().contains("*")) {
            return;
        }
        if (bKeepFields) {
            hAttr.keySet().retainAll(hCleanBy.keySet());
        } else {
            hAttr.keySet().removeAll(hCleanBy.keySet());
        }
    }

    public static void CleanMODAttributesByVector(Vector vAttr, Vector vCleanBy) {
        if (vCleanBy == null) {
            return;
        }
        if (vAttr == null || vAttr.size() == 0) {
            return;
        }
        int ls = vAttr.size();
        for (int x = 0; x < ls; ++x) {
            MVDModAttrValues mvdmod = (MVDModAttrValues)vAttr.elementAt(x);
            String origV = mvdmod.getAttrName();
            if (!vCleanBy.contains(origV)) continue;
            vAttr.remove(x);
            --x;
            --ls;
        }
    }

    public static void CleanMODAttributesByHash(Vector vAttr, HashMap hCleanBy) {
        if (hCleanBy == null) {
            return;
        }
        if (vAttr == null || vAttr.size() == 0) {
            return;
        }
        int ls = vAttr.size();
        for (int x = 0; x < ls; ++x) {
            MVDModAttrValues mvdmod = (MVDModAttrValues)vAttr.elementAt(x);
            String origV = mvdmod.getAttrName();
            if (hCleanBy.containsKey(origV)) continue;
            vAttr.remove(x);
            --x;
            --ls;
        }
    }

    public static void CleanRESEntriesAttributesByVector(MVDSearchResults aRes, Vector hCleanBy, boolean bKeepFields) {
        if (hCleanBy == null) {
            return;
        }
        try {
            MVDSearchResults vv = aRes;
            int ls = vv.size();
            for (int x = 0; x < ls; ++x) {
                HashMap aAttrValues = ((MVDSearchResultEntry)vv.elementAt(x)).getAttrAndValues();
                MVDOpUtilities.CleanRESAttributesByVector(aAttrValues, hCleanBy, bKeepFields);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void ConvertRESEntriesAttributes(MVDSearchResults aRes, HashMap hConvertBy) {
        if (hConvertBy == null) {
            return;
        }
        try {
            int ls = aRes.size();
            MVDSearchResults vEntries = aRes;
            for (int x = 0; x < ls; ++x) {
                MVDSearchResultEntry aSingleResult = (MVDSearchResultEntry)vEntries.elementAt(x);
                HashMap hAttr = MVDOpUtilities.ConvertAttributes(aSingleResult.getAttrAndValues(), hConvertBy);
                aSingleResult.setAttrAndValues(hAttr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void DeleteRESEntriesAttributes(MVDSearchResults aRes, HashMap hDeleteBy, boolean keepit) {
        if (hDeleteBy == null) {
            return;
        }
        try {
            int ls = aRes.size();
            MVDSearchResults vEntries = aRes;
            for (int x = 0; x < ls; ++x) {
                MVDSearchResultEntry aSingleResult = (MVDSearchResultEntry)vEntries.elementAt(x);
                MVDOpUtilities.CleanRESAttributesByHash(aSingleResult.getAttrAndValues(), hDeleteBy, keepit);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void ConstructRESEntriesAttributes(MVDSearchResults aRes, HashMap hConstructBy, HashMap hIfExists) {
        if (hConstructBy == null) {
            return;
        }
        MVDSearchResultEntry aSingleResult = null;
        try {
            int ls = aRes.size();
            MVDSearchResults vEntries = aRes;
            for (int x = 0; x < ls; ++x) {
                aSingleResult = (MVDSearchResultEntry)vEntries.elementAt(x);
                MVDOpUtilities.ConstructAttributes(aSingleResult.getAttrAndValues(), hConstructBy, hIfExists);
            }
        }
        catch (Exception e) {
            MVDLogger.Log("Construction of attributes failed" + (aSingleResult == null ? "" : " for " + aSingleResult.getDn()) + " : " + e, 2);
        }
    }

    public static HashMap FixAttributeValues(HashMap hIn, HashMap hFixBy, MVDAttributeFixInterface a) {
        if (hFixBy == null) {
            return hIn;
        }
        String[] scriptsDefinedFor = hFixBy.keySet().toArray(new String[0]);
        int ls = scriptsDefinedFor.length;
        Class[] aClass = new Class[1];
        Method aMethod = null;
        Object[] funcParams = new Object[1];
        for (int x = 0; x < ls; ++x) {
            Vector oldValues;
            String attrName = scriptsDefinedFor[x];
            String scriptForFix = (String)hFixBy.get(attrName);
            if (scriptForFix == null || (oldValues = (Vector)hIn.get(attrName)) == null) continue;
            aMethod = null;
            try {
                if (MVDProxy.IsBinaryAttribute(attrName)) {
                    aClass[0] = array$B == null ? MVDOpUtilities.class$("[B") : array$B;
                    aMethod = a.getClass().getMethod(scriptForFix, aClass);
                } else {
                    aClass[0] = class$java$lang$String == null ? MVDOpUtilities.class$("java.lang.String") : class$java$lang$String;
                    aMethod = a.getClass().getMethod(scriptForFix, aClass);
                }
            }
            catch (NoSuchMethodException e) {
                MVDLogger.Log("Function " + scriptForFix + " (" + aClass[0].getName() + ") couldn't be found " + "in the AttributeFix " + a.getClass().toString(), 7, e);
                continue;
            }
            int sz = oldValues.size();
            Vector<byte[]> newValues = new Vector<byte[]>(sz, 2);
            try {
                Object newVal;
                int y;
                if (MVDProxy.IsBinaryAttribute(attrName)) {
                    for (y = 0; y < sz; ++y) {
                        funcParams[0] = oldValues.elementAt(y);
                        newVal = (byte[])aMethod.invoke((Object)a, funcParams);
                        newValues.add((byte[])newVal);
                    }
                } else {
                    for (y = 0; y < sz; ++y) {
                        funcParams[0] = oldValues.elementAt(y);
                        newVal = (String)aMethod.invoke((Object)a, funcParams);
                        newValues.add((byte[])newVal);
                    }
                }
                hIn.put(attrName, newValues);
                continue;
            }
            catch (Exception iae) {
                MVDLogger.Log("Error invoking function " + scriptForFix + " from AttributeFix " + a.getClass().toString(), 7, iae);
            }
        }
        return hIn;
    }

    public static void FixMODAttributeValues(Vector vIn, HashMap hFixBy, MVDAttributeFixInterface a) {
        if (hFixBy == null) {
            return;
        }
        String[] scriptsDefinedFor = hFixBy.keySet().toArray(new String[0]);
        int ls = scriptsDefinedFor.length;
        Class[] aClass = new Class[1];
        Method aMethod = null;
        Object[] funcParams = new Object[1];
        for (int x = 0; x < ls; ++x) {
            String attrName = scriptsDefinedFor[x];
            String scriptForFix = (String)hFixBy.get(attrName);
            if (scriptForFix == null) continue;
            for (int modX = 0; modX < vIn.size(); ++modX) {
                MVDModAttrValues wantModification = (MVDModAttrValues)vIn.elementAt(modX);
                String wantAttrName = wantModification.getAttrName();
                if (!wantAttrName.equals(attrName)) continue;
                aMethod = null;
                try {
                    if (MVDProxy.IsBinaryAttribute(attrName)) {
                        aClass[0] = array$B == null ? MVDOpUtilities.class$("[B") : array$B;
                        aMethod = a.getClass().getMethod(scriptForFix, aClass);
                    } else {
                        aClass[0] = class$java$lang$String == null ? MVDOpUtilities.class$("java.lang.String") : class$java$lang$String;
                        aMethod = a.getClass().getMethod(scriptForFix, aClass);
                    }
                }
                catch (NoSuchMethodException e) {
                    MVDLogger.Log("Function " + scriptForFix + " (" + aClass[0].getName() + ") couldn't be found " + "in the AttributeFix " + a.getClass().toString(), 7, e);
                    continue;
                }
                int sz = wantModification.size();
                MVDModAttrValues newValues = new MVDModAttrValues();
                newValues.setAttrName(wantAttrName);
                try {
                    Object newVal;
                    int y;
                    if (MVDProxy.IsBinaryAttribute(attrName)) {
                        for (y = 0; y < sz; ++y) {
                            funcParams[0] = wantModification.elementAt(y);
                            newVal = (byte[])aMethod.invoke((Object)a, funcParams);
                            newValues.add(newVal);
                        }
                    } else {
                        for (y = 0; y < sz; ++y) {
                            funcParams[0] = wantModification.elementAt(y);
                            newVal = (String)aMethod.invoke((Object)a, funcParams);
                            newValues.add(newVal);
                        }
                    }
                    vIn.setElementAt(newValues, modX);
                    continue;
                }
                catch (Exception iae) {
                    MVDLogger.Log("Error invoking function " + scriptForFix + " from AttributeFix " + a.getClass().toString(), 7, iae);
                }
            }
        }
    }

    private static void AddAttributesAndValues(MVDSearchResultEntry aRes, String MethodName, MVDAttributeFixInterface a) {
        Method aMethod = null;
        Object[] funcParams = new Object[1];
        try {
            aMethod = a.getClass().getMethod(MethodName, argClass);
            funcParams[0] = aRes;
            aMethod.invoke((Object)a, funcParams);
        }
        catch (NoSuchMethodException e) {
            MVDLogger.Log("Error: Could not find method " + MethodName + " in AttributeFix " + a.getClass().toString(), 7, e);
        }
        catch (Throwable t) {
            MVDLogger.Log("Error invoking function " + MethodName + " from AttributeFix " + a.getClass().toString(), 7, t);
        }
    }

    public static void FixRESEntriesAttributeValues(MVDSearchResults aRes, HashMap hFixBy, MVDAttributeFixInterface o, boolean bRequiredEditAttrSet, String EditAttrMethod) {
        boolean bConvByScripts = false;
        if (o == null) {
            return;
        }
        if (hFixBy != null && hFixBy.size() > 0) {
            bConvByScripts = true;
        }
        if (!bConvByScripts && !bRequiredEditAttrSet) {
            return;
        }
        try {
            MVDSearchResults vv = aRes;
            int ls = vv.size();
            for (int x = 0; x < ls; ++x) {
                MVDSearchResultEntry aSingleResult = (MVDSearchResultEntry)vv.elementAt(x);
                if (bConvByScripts) {
                    HashMap hAttr = MVDOpUtilities.FixAttributeValues(aSingleResult.getAttrAndValues(), hFixBy, o);
                    aSingleResult.setAttrAndValues(hAttr);
                }
                if (!bRequiredEditAttrSet) continue;
                MVDOpUtilities.AddAttributesAndValues(aSingleResult, EditAttrMethod, o);
            }
            if (bRequiredEditAttrSet) {
                aRes.removeProhibitedEntries();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static final String reverseDN(String aString) {
        int fnuttIndex = aString.indexOf(34);
        int slashIndex = aString.indexOf(92);
        if (fnuttIndex >= 0 || slashIndex >= 0) {
            boolean isSlash = false;
            boolean isFnutt = false;
            Vector<String> v = new Vector<String>();
            int lastIndex = 0;
            for (int ind = 0; ind < aString.length(); ++ind) {
                char c = aString.charAt(ind);
                if (c == ',' && !isSlash && !isFnutt) {
                    String rdn = aString.substring(lastIndex, ind);
                    lastIndex = ind + 1;
                    v.addElement(rdn);
                    continue;
                }
                if (c == '\\') {
                    isSlash = !isSlash;
                    continue;
                }
                if (c == '\"') {
                    if (isSlash) continue;
                    isFnutt = !isFnutt;
                    continue;
                }
                isSlash = false;
            }
            String res = aString.substring(lastIndex, aString.length());
            int s = v.size();
            for (int i = v.size() - 1; i >= 0; --i) {
                res = res + "," + (String)v.elementAt(i);
            }
            return res;
        }
        Vector<String> result = new Vector<String>();
        StringTokenizer t = new StringTokenizer(aString, ",");
        while (t.hasMoreTokens()) {
            result.insertElementAt(t.nextToken(), 0);
        }
        return MVDUtil.joinStrings(result, ",");
    }

    public static String SimpleNiceDN(String inputDN) throws MVDException {
        if (inputDN.length() == 0) {
            return inputDN;
        }
        if (inputDN.equals("null")) {
            return "";
        }
        String s = inputDN;
        s = s.trim();
        s = MVDUtil.replace(s, ", ", ",");
        s = MVDUtil.replace(s, ", ", ",");
        s = MVDUtil.replace(s, ", ", ",");
        s = MVDUtil.replace(s, " ,", ",");
        s = MVDUtil.replace(s, " ,", ",");
        s = MVDUtil.replace(s, " ,", ",");
        s = MVDUtil.replace(s, "= ", "=");
        s = MVDUtil.replace(s, "= ", "=");
        s = MVDUtil.replace(s, "= ", "=");
        s = MVDUtil.replace(s, " =", "=");
        s = MVDUtil.replace(s, " =", "=");
        if ((s = MVDUtil.replace(s, " =", "=")).length() > 0 && s.indexOf(",,") >= 0) {
            throw new MVDException(-23);
        }
        s = MVDUtil.replace(s, ",,", ",");
        if ((s = MVDUtil.replace(s, ",,", ",")).startsWith(",")) {
            throw new MVDException(-23);
        }
        if (s.endsWith(",")) {
            throw new MVDException(-23);
        }
        return s;
    }

    public static int PickTheNamingExceptionCode(NamingException ne) {
        try {
            throw ne;
        }
        catch (CommunicationException a2) {
            return 2;
        }
        catch (TimeLimitExceededException a3) {
            return 3;
        }
        catch (SizeLimitExceededException a1) {
            return 4;
        }
        catch (AuthenticationNotSupportedException a1) {
            return 7;
        }
        catch (PartialResultException a1) {
            return 9;
        }
        catch (ReferralException a1) {
            return 10;
        }
        catch (LimitExceededException a1) {
            return 11;
        }
        catch (NoSuchAttributeException a1) {
            return 16;
        }
        catch (InvalidAttributeIdentifierException a1) {
            return 17;
        }
        catch (InvalidSearchFilterException a1) {
            return 18;
        }
        catch (InvalidAttributeValueException a1) {
            return 19;
        }
        catch (AttributeInUseException a1) {
            return 20;
        }
        catch (NameNotFoundException a1) {
            return 32;
        }
        catch (InvalidNameException a1) {
            return 34;
        }
        catch (AuthenticationException a1) {
            return 49;
        }
        catch (NoPermissionException a1) {
            return 50;
        }
        catch (ServiceUnavailableException a1) {
            return 52;
        }
        catch (OperationNotSupportedException a1) {
            return 53;
        }
        catch (SchemaViolationException a1) {
            return 65;
        }
        catch (ContextNotEmptyException a1) {
            return 66;
        }
        catch (NameAlreadyBoundException a1) {
            return 68;
        }
        catch (NamingException a1) {
            return 1;
        }
    }

    public static boolean IsOperationProhibited(MVDRule aRule, String what) {
        String ruleOperations = aRule.Operations();
        if (ruleOperations.equalsIgnoreCase("ALL")) {
            return false;
        }
        if (ruleOperations.indexOf(what) == -1) {
            return true;
        }
        return MVDProxy.ProhibitedOperations().indexOf(what) > -1;
    }

    public static void checkAttributeSyntax(String aDN, HashMap aAttributes, Vector aSyntaxRules, MVDAttributeFixInterface aAttrInterface) throws MVDException {
        Class<?> attrClass = aAttrInterface.getClass();
        Iterator iter = aSyntaxRules.iterator();
        while (iter.hasNext()) {
            SyntaxMethod synmeth = (SyntaxMethod)iter.next();
            String attrname = synmeth.getAttrName();
            Vector attrvalue = null;
            if (attrname.equalsIgnoreCase("mvd_dn")) {
                attrvalue = new Vector();
                attrvalue.add(aDN);
            } else {
                attrvalue = (Vector)aAttributes.get(attrname.toLowerCase());
            }
            String[] params = synmeth.getParameters();
            String methodname = synmeth.getMethodName();
            if (methodname == null || methodname.length() == 0 || methodname.equalsIgnoreCase("none")) continue;
            Class[] methodparameters = new Class[1 + (params != null ? params.length : 0)];
            methodparameters[0] = MVDProxy.IsBinaryAttribute(attrname) ? (array$B == null ? MVDOpUtilities.class$("[B") : array$B) : (class$java$lang$String == null ? MVDOpUtilities.class$("java.lang.String") : class$java$lang$String);
            for (int i = 1; i < methodparameters.length; ++i) {
                methodparameters[i] = class$java$lang$String == null ? MVDOpUtilities.class$("java.lang.String") : class$java$lang$String;
            }
            try {
                Method m = attrClass.getMethod(methodname, methodparameters);
                if (attrvalue == null) continue;
                Iterator iterator = attrvalue.iterator();
                while (iterator.hasNext()) {
                    Object val = iterator.next();
                    Object[] objParams = new Object[methodparameters.length];
                    objParams[0] = val;
                    for (int i = 1; i < objParams.length; ++i) {
                        objParams[i] = params[i - 1];
                    }
                    boolean result = (Boolean)m.invoke((Object)aAttrInterface, objParams);
                    if (synmeth.evaluate(result)) continue;
                    throw new MVDException(65, "Object class violation: " + attrname);
                }
            }
            catch (SecurityException e) {
                MVDLogger.Log("Unable to find method " + methodname, 6);
                throw new MVDException(65, "Object class violation");
            }
            catch (NoSuchMethodException e) {
                MVDLogger.Log("Unable to find method " + methodname, 6);
                throw new MVDException(65, "Object class violation");
            }
            catch (IllegalArgumentException e) {
                MVDLogger.Log("Unable to invoke method " + methodname, 6);
                throw new MVDException(65, "Object class violation");
            }
            catch (IllegalAccessException e) {
                MVDLogger.Log("Unable to invoke method " + methodname, 6);
                throw new MVDException(65, "Object class violation");
            }
            catch (InvocationTargetException e) {
                MVDLogger.Log("Unable to invoke method " + methodname, 6);
                throw new MVDException(65, "Object class violation");
            }
        }
    }

    public static void checkMODAttributeSyntax(String aDN, Vector aAttributes, Vector aSyntaxRules, MVDAttributeFixInterface aAttrInterface) throws MVDException {
        Class<?> attrClass = aAttrInterface.getClass();
        HashMap configuredAttributes = new HashMap();
        Vector<String> dnvector = new Vector<String>();
        dnvector.add(aDN);
        configuredAttributes.put("mvd_dn", dnvector);
        Iterator iter = aAttributes.iterator();
        while (iter.hasNext()) {
            MVDModAttrValues attrvalue = (MVDModAttrValues)iter.next();
            boolean appendval = false;
            switch (attrvalue.getModType()) {
                case 0: 
                case 2: {
                    appendval = true;
                    break;
                }
                case 1: {
                    appendval = false;
                }
            }
            if (!appendval) continue;
            Vector v = (Vector)configuredAttributes.get(attrvalue.getAttrName());
            if (v == null) {
                v = new Vector();
                configuredAttributes.put(attrvalue.getAttrName(), v);
            }
            v.addAll(attrvalue);
        }
        if (configuredAttributes.size() <= 0) {
            return;
        }
        iter = aSyntaxRules.iterator();
        while (iter.hasNext()) {
            SyntaxMethod synmeth = (SyntaxMethod)iter.next();
            String attrname = synmeth.getAttrName();
            Vector attrvalue = (Vector)configuredAttributes.get(attrname.toLowerCase());
            String[] params = synmeth.getParameters();
            String methodname = synmeth.getMethodName();
            if (methodname == null || methodname.length() == 0 || methodname.equalsIgnoreCase("none")) continue;
            Class[] methodparameters = new Class[1 + (params != null ? params.length : 0)];
            methodparameters[0] = MVDProxy.IsBinaryAttribute(attrname) ? (array$B == null ? MVDOpUtilities.class$("[B") : array$B) : (class$java$lang$String == null ? MVDOpUtilities.class$("java.lang.String") : class$java$lang$String);
            for (int i = 1; i < methodparameters.length; ++i) {
                methodparameters[i] = class$java$lang$String == null ? MVDOpUtilities.class$("java.lang.String") : class$java$lang$String;
            }
            try {
                Method m = attrClass.getMethod(methodname, methodparameters);
                if (attrvalue == null) continue;
                Iterator iterator = attrvalue.iterator();
                while (iterator.hasNext()) {
                    Object val = iterator.next();
                    Object[] objParams = new Object[methodparameters.length];
                    objParams[0] = val;
                    for (int i = 1; i < objParams.length; ++i) {
                        objParams[i] = params[i - 1];
                    }
                    boolean result = (Boolean)m.invoke((Object)aAttrInterface, objParams);
                    if (synmeth.evaluate(result)) continue;
                    throw new MVDException(65, "Object class violation: " + attrname);
                }
            }
            catch (SecurityException e) {
                MVDLogger.Log("Unable to find method " + methodname, 6);
                throw new MVDException(65, "Object class violation");
            }
            catch (NoSuchMethodException e) {
                MVDLogger.Log("Unable to find method " + methodname, 6);
                throw new MVDException(65, "Object class violation");
            }
            catch (IllegalArgumentException e) {
                MVDLogger.Log("Unable to invoke method " + methodname, 6);
                throw new MVDException(65, "Object class violation");
            }
            catch (IllegalAccessException e) {
                MVDLogger.Log("Unable to invoke method " + methodname, 6);
                throw new MVDException(65, "Object class violation");
            }
            catch (InvocationTargetException e) {
                MVDLogger.Log("Unable to invoke method " + methodname, 6);
                throw new MVDException(65, "Object class violation");
            }
        }
    }

    public static void checkAddAttributeSyntaxWholeSet(String aDN, HashMap aAttributes, Vector aSyntaxRules, MVDAttributeFixInterface aAttrInterface, String aMethodName) throws MVDException {
        try {
            HashMap<String, String> sendAttributes = new HashMap<String, String>(aAttributes);
            sendAttributes.put("mvd_dn", aDN);
            Class[] paramtypes = new Class[]{class$java$util$HashMap == null ? (class$java$util$HashMap = MVDOpUtilities.class$("java.util.HashMap")) : class$java$util$HashMap};
            Method attrsetm = aAttrInterface.getClass().getMethod(aMethodName, paramtypes);
            Object[] params = new Object[]{sendAttributes};
            boolean ok = (Boolean)attrsetm.invoke((Object)aAttrInterface, params);
            if (!ok) {
                throw new MVDException(65, "Object class violation");
            }
        }
        catch (SecurityException e) {
            MVDLogger.Log("Unable to find method " + aMethodName, 6);
            throw new MVDException(65, "Object class violation");
        }
        catch (NoSuchMethodException e) {
            MVDLogger.Log("Unable to find method " + aMethodName, 6);
            throw new MVDException(65, "Object class violation");
        }
        catch (IllegalArgumentException e) {
            MVDLogger.Log("Unable to invoke method " + aMethodName, 6);
            throw new MVDException(65, "Object class violation");
        }
        catch (IllegalAccessException e) {
            MVDLogger.Log("Unable to invoke method " + aMethodName, 6);
            throw new MVDException(65, "Object class violation");
        }
        catch (InvocationTargetException e) {
            MVDLogger.Log("Unable to invoke method " + aMethodName, 6);
            throw new MVDException(65, "Object class violation");
        }
    }

    public static void checkModAttributeSyntaxWholeSet(String aDN, Vector aAttributes, Vector aSyntaxRules, MVDAttributeFixInterface aAttrInterface, String aMethodName) throws MVDException {
        HashMap<String, Object> configuredAttributes = new HashMap<String, Object>();
        configuredAttributes.put("mvd_dn", aDN);
        Iterator iter = aAttributes.iterator();
        while (iter.hasNext()) {
            MVDModAttrValues attrvalue = (MVDModAttrValues)iter.next();
            boolean appendval = false;
            switch (attrvalue.getModType()) {
                case 0: 
                case 2: {
                    appendval = true;
                    break;
                }
                case 1: {
                    appendval = false;
                }
            }
            if (!appendval) continue;
            Vector v = (Vector)configuredAttributes.get(attrvalue.getAttrName());
            if (v == null) {
                v = new Vector();
                configuredAttributes.put(attrvalue.getAttrName(), v);
            }
            v.addAll(attrvalue);
        }
        if (configuredAttributes.size() <= 0) {
            return;
        }
        try {
            Class[] paramtypes = new Class[]{class$java$util$HashMap == null ? (class$java$util$HashMap = MVDOpUtilities.class$("java.util.HashMap")) : class$java$util$HashMap};
            Method attrsetm = aAttrInterface.getClass().getMethod(aMethodName, paramtypes);
            Object[] params = new Object[]{configuredAttributes};
            boolean ok = (Boolean)attrsetm.invoke((Object)aAttrInterface, params);
            if (!ok) {
                throw new MVDException(65, "Object class violation");
            }
        }
        catch (SecurityException e) {
            MVDLogger.Log("Unable to find method " + aMethodName, 6);
            throw new MVDException(65, "Object class violation");
        }
        catch (NoSuchMethodException e) {
            MVDLogger.Log("Unable to find method " + aMethodName, 6);
            throw new MVDException(65, "Object class violation");
        }
        catch (IllegalArgumentException e) {
            MVDLogger.Log("Unable to invoke method " + aMethodName, 6);
            throw new MVDException(65, "Object class violation");
        }
        catch (IllegalAccessException e) {
            MVDLogger.Log("Unable to invoke method " + aMethodName, 6);
            throw new MVDException(65, "Object class violation");
        }
        catch (InvocationTargetException e) {
            MVDLogger.Log("Unable to invoke method " + aMethodName, 6);
            throw new MVDException(65, "Object class violation");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MVDOpUtilities.argClass[0] = new MVDSearchResultEntry().getClass();
    }
}

