/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDDataSourceList;
import com.sap.idm.vds.util.HidedJDBCOperations;
import java.util.HashMap;
import java.util.Iterator;

public class JDBCUtil {
    public static boolean connect(String aMVDUniqueDataSourceName, String aReplaceUser, String aReplacePwd, String aUser, String aPassword) {
        MVDDataSource ds = MVDDataSourceList.getDSByUniqueName(aMVDUniqueDataSourceName);
        if (ds == null) {
            return false;
        }
        String conString = (String)ds.ParamFields().get("DS_DATABASE");
        conString = MVDUtil.replace(conString, aReplaceUser, aUser);
        conString = MVDUtil.replace(conString, aReplacePwd, aPassword);
        boolean res = JDBCUtil.connect(conString);
        return res;
    }

    public static boolean connect(String aDatabaseConnString) {
        HidedJDBCOperations hjdbco = new HidedJDBCOperations();
        MVDLogger.Log("Connecting : " + aDatabaseConnString, 2);
        return hjdbco.testConnection(aDatabaseConnString);
    }

    public static MVDSearchResults search(String aDatabaseConnString, String aQuery, String aAdditionalBinaryAttributes, boolean aCacheConnections) {
        HidedJDBCOperations hjdbco = new HidedJDBCOperations();
        return hjdbco.Search(aDatabaseConnString, aQuery, aAdditionalBinaryAttributes, aCacheConnections);
    }

    public static MVDSearchResults searchPrepared(String aDatabaseConnString, String aPrepStmtQuery, MVDHashMap aEngineGlobals, String aValue) {
        HidedJDBCOperations hjdbco = new HidedJDBCOperations();
        return hjdbco.PreparedSearch(aDatabaseConnString, aPrepStmtQuery, aEngineGlobals, aValue);
    }

    public static MVDSearchResults searchBase(String aMVDUniqueDataSourceName, String aDN, String aQuery, String aDNTemplate) {
        MVDDataSource ds = MVDDataSourceList.getDSByUniqueName(aMVDUniqueDataSourceName);
        if (ds == null) {
            return null;
        }
        HashMap tmpHashmap = new HashMap();
        String conString = (String)ds.ParamFields().get("DS_DATABASE");
        String strRes = MVDUtilities.matchBracketTemplate(aDN, aDNTemplate, tmpHashmap);
        if (!strRes.equals("OK")) {
            return null;
        }
        Iterator it = tmpHashmap.keySet().iterator();
        while (it.hasNext()) {
            String sss = (String)it.next();
            aQuery = MVDUtil.replace(aQuery, sss, (String)tmpHashmap.get(sss));
        }
        HidedJDBCOperations hjdbco = new HidedJDBCOperations();
        return hjdbco.Search(conString, aQuery, "", true);
    }

    public static MVDOperationResult modify(String aDatabaseConnString, String aQuery, boolean aCacheConnections) {
        HidedJDBCOperations hjdbco = new HidedJDBCOperations();
        return hjdbco.UpdateDB(aDatabaseConnString, aQuery, aCacheConnections);
    }

    public static MVDOperationResult add(String aDatabaseConnString, String aQuery, boolean aCacheConnections) {
        HidedJDBCOperations hjdbco = new HidedJDBCOperations();
        return hjdbco.UpdateDB(aDatabaseConnString, aQuery, aCacheConnections);
    }

    public static MVDOperationResult delete(String aDatabaseConnString, String aQuery, boolean aCacheConnections) {
        HidedJDBCOperations hjdbco = new HidedJDBCOperations();
        return hjdbco.UpdateDB(aDatabaseConnString, aQuery, aCacheConnections);
    }
}

