/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.MVDGlobals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.util.mic.MICUtilities;
import com.sap.idm.vds.util.mic.StoredProcedure;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class HidedIDStoreOperations {
    private MICUtilities micutil = new MICUtilities();
    private String mAdditionalUser = "";
    private String mAdditionalPassword = "";
    private String mConnStringRest = "";
    private boolean mCacheConnections = false;
    private Statement sqlStmt = null;
    private ResultSet sqlRs = null;
    private Connection sqlCon = null;
    public static String MSSQL_DB = "1";
    public static String ORACLE_DB = "2";
    public static String SOLID_DB = "3";
    private static boolean mLikeSolid;
    private static int mLargeAttributeLength;
    private static String mLargeAttributePrefix;
    private static String mDBInfo;
    public static final int MXIE_CREATE = 0;
    public static final int MXIE_GET_ID = 1;
    public static final int MXI_SETVALUE = 2;
    public static final int MXI_GETERROR = 3;
    public static final int MXI_XSETVALUE = 4;
    public static final int MXI_XGETVALUE = 5;
    public static final int MC_LOG = 6;
    public static final int MXIE_DELETE = 7;
    public static final int MXI_VALIDATE = 8;
    public static final int MXI_XSETATTRIBUTE = 9;
    public static final int MISAM_FAKE = 10;
    public static final int MXI_COMPARE = 11;
    public static final int ORACLE_MXI_XSETATTRIBUTE = 12;
    public static final int ORACLE_MXP_LIST_CONTAINER_ENTRIES = 13;
    public static final int MXP_LIST_CONTAINER_ENTRIES = 14;
    private static StoredProcedure[] StoredProcedures;
    public static final int IS_MULTIVALUED = 0;
    public static final int MISAV_FAKE = 1;
    public String[] Queries = new String[]{"select MULTIVALUE from mxiv_schema where (attrname='$aATTRNAME$') AND (IS_ID=$aISID$)"};

    public static StoredProcedure[] getStoredProcedures() {
        return StoredProcedures;
    }

    public String[] getQueries() {
        return this.Queries;
    }

    public Connection idstoreconnection() {
        return this.sqlCon;
    }

    public HidedIDStoreOperations(String aDatabaseConnString, boolean aCacheConnections) throws Exception {
        this.mCacheConnections = aCacheConnections;
        this.ExtractFakeUserPassword(aDatabaseConnString);
        this.sqlCon = this.getConnection(aDatabaseConnString);
        this.micutil.initMicUtil(this);
    }

    public HidedIDStoreOperations() {
    }

    public static boolean getLikeSolid() {
        return mLikeSolid;
    }

    public static void setLikeSolid(boolean b) {
        mLikeSolid = b;
    }

    public static String getDBInfo() {
        return mDBInfo;
    }

    public static void setDBInfo(String b) {
        mDBInfo = b;
        mLikeSolid = mDBInfo.equals(SOLID_DB);
    }

    public static int getLargeAttributeLength() {
        return mLargeAttributeLength;
    }

    public static void setLargeAttributeLength(int b) {
        mLargeAttributeLength = b;
    }

    public static String getLargeAttributePrefix() {
        return mLargeAttributePrefix;
    }

    public static void setLargeAttributeprefix(String b) {
        mLargeAttributePrefix = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MVDSearchResults Search(String aDatabaseConnString, String aQuery, boolean bBaseCollect, boolean aCacheConnections, int ISID) {
        MVDSearchResults mVDSearchResults;
        MVDSearchResults result;
        block21: {
            MVDSearchResults mVDSearchResults2;
            block20: {
                this.mCacheConnections = aCacheConnections;
                result = new MVDSearchResults();
                this.ExtractFakeUserPassword(aDatabaseConnString);
                this.sqlStmt = this.getStatement(aDatabaseConnString);
                if (this.sqlStmt == null && this.mCacheConnections) {
                    this.sqlStmt = this.getStatement(aDatabaseConnString);
                }
                if (this.sqlStmt == null) {
                    MVDLogger.Log("Couldn't create statement (connection ?)", 2);
                    result.setError(52, "Couldn't create statement - data source unavailable");
                    return result;
                }
                try {
                    try {
                        this.sqlRs = this.sqlStmt.executeQuery(aQuery);
                        String addRes = "";
                        addRes = bBaseCollect ? result.addIDStoreRecordSetBase(this.sqlRs, this, ISID) : result.addIDStoreRecordSetOneSub(this.sqlRs, this, ISID);
                        if (addRes.equals("OK")) {
                            result.setOK();
                            mVDSearchResults2 = result;
                            Object var10_12 = null;
                            break block20;
                        }
                        result.setError(addRes);
                        mVDSearchResults = result;
                        break block21;
                    }
                    catch (SQLException ex) {
                        MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                        result.setError("ERROR:" + ex.getMessage());
                        MVDSearchResults mVDSearchResults22 = result;
                        Object var10_14 = null;
                        try {
                            if (this.sqlRs != null) {
                                this.sqlRs.close();
                            }
                            if (this.sqlStmt != null) {
                                this.sqlStmt.close();
                            }
                            if (this.mCacheConnections) return mVDSearchResults22;
                            if (this.sqlCon == null) return mVDSearchResults22;
                            this.sqlCon.close();
                            this.sqlCon = null;
                            return mVDSearchResults22;
                        }
                        catch (SQLException ex2) {
                            MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
                            result.setError("ERROR:" + ex2.getMessage());
                            return result;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    try {}
                    catch (SQLException ex2) {
                        MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
                        result.setError("ERROR:" + ex2.getMessage());
                        return result;
                    }
                    if (this.sqlRs != null) {
                        this.sqlRs.close();
                    }
                    if (this.sqlStmt != null) {
                        this.sqlStmt.close();
                    }
                    if (this.mCacheConnections) throw throwable;
                    if (this.sqlCon == null) throw throwable;
                    this.sqlCon.close();
                    this.sqlCon = null;
                    throw throwable;
                }
            }
            try {}
            catch (SQLException ex2) {
                MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
                result.setError("ERROR:" + ex2.getMessage());
                return result;
            }
            if (this.sqlRs != null) {
                this.sqlRs.close();
            }
            if (this.sqlStmt != null) {
                this.sqlStmt.close();
            }
            if (this.mCacheConnections) return mVDSearchResults2;
            if (this.sqlCon == null) return mVDSearchResults2;
            this.sqlCon.close();
            this.sqlCon = null;
            return mVDSearchResults2;
        }
        Object var10_13 = null;
        try {}
        catch (SQLException ex2) {
            MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
            result.setError("ERROR:" + ex2.getMessage());
            return result;
        }
        if (this.sqlRs != null) {
            this.sqlRs.close();
        }
        if (this.sqlStmt != null) {
            this.sqlStmt.close();
        }
        if (this.mCacheConnections) return mVDSearchResults;
        if (this.sqlCon == null) return mVDSearchResults;
        this.sqlCon.close();
        this.sqlCon = null;
        return mVDSearchResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MVDSearchResults visibilitySearch(int mskey, int pidStore, String entryType, int searchMode, String searchFilter, int szLimit) throws Exception {
        MVDSearchResults result = new MVDSearchResults();
        boolean autoCommitWasOn = false;
        HashMap listSetIC = null;
        try {
            try {
                autoCommitWasOn = this.sqlCon.getAutoCommit();
                this.sqlCon.setAutoCommit(false);
                listSetIC = this.micutil.List_IS_Attribute(mskey, pidStore, entryType, searchMode, searchFilter, szLimit);
                if (listSetIC.size() > 0) {
                    Iterator iter = listSetIC.entrySet().iterator();
                    while (iter.hasNext()) {
                        MVDSearchResultEntry entry = null;
                        Map.Entry e = iter.next();
                        Vector icobject = (Vector)e.getValue();
                        entry = new MVDSearchResultEntry();
                        entry.setAttrValue("mskeyvalue", true, (String)icobject.get(0), "|");
                        result.add(entry);
                    }
                    result.setOK();
                }
                result.setOK();
            }
            catch (Exception ex) {
                MVDLogger.Log("Error visibilitySearch: " + ex.getMessage(), 7, ex);
                result.setError(2, "Protocol error for visibilitySearch: " + ex.toString());
                MVDSearchResults mVDSearchResults = result;
                Object var15_17 = null;
                try {
                    if (this.sqlRs != null) {
                        this.sqlRs.close();
                    }
                    if (this.sqlStmt != null) {
                        this.sqlStmt.close();
                    }
                    if (this.mCacheConnections) return mVDSearchResults;
                    if (this.sqlCon == null) return mVDSearchResults;
                    this.sqlCon.setAutoCommit(autoCommitWasOn);
                    this.sqlCon.close();
                    return mVDSearchResults;
                }
                catch (SQLException ex2) {
                    MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
                    result.setError("ERROR:" + ex2.getMessage());
                    return result;
                }
            }
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            try {}
            catch (SQLException ex2) {
                MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
                result.setError("ERROR:" + ex2.getMessage());
                return result;
            }
            if (this.sqlRs != null) {
                this.sqlRs.close();
            }
            if (this.sqlStmt != null) {
                this.sqlStmt.close();
            }
            if (this.mCacheConnections) throw throwable;
            if (this.sqlCon == null) throw throwable;
            this.sqlCon.setAutoCommit(autoCommitWasOn);
            this.sqlCon.close();
            throw throwable;
        }
        try {}
        catch (SQLException ex2) {
            MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
            result.setError("ERROR:" + ex2.getMessage());
            return result;
        }
        if (this.sqlRs != null) {
            this.sqlRs.close();
        }
        if (this.sqlStmt != null) {
            this.sqlStmt.close();
        }
        if (this.mCacheConnections) return result;
        if (this.sqlCon == null) return result;
        this.sqlCon.setAutoCommit(autoCommitWasOn);
        this.sqlCon.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MVDSearchResults oneSearch(String aQuery, boolean bBaseCollect, int aExpandRefs, String nodeDN, int ISID) throws Exception {
        MVDSearchResults mVDSearchResults;
        MVDSearchResults result;
        block21: {
            MVDSearchResults mVDSearchResults2;
            block20: {
                result = new MVDSearchResults();
                this.sqlStmt = this.idstoreconnection().createStatement();
                if (this.sqlStmt == null && this.mCacheConnections) {
                    this.sqlStmt = this.idstoreconnection().createStatement();
                }
                if (this.sqlStmt == null) {
                    MVDLogger.Log("Couldn't create statement (connection ?)", 2);
                    result.setError(52, "Couldn't create statement - data source unavailable");
                    return result;
                }
                try {
                    try {
                        this.sqlRs = this.sqlStmt.executeQuery(aQuery);
                        String addRes = "";
                        addRes = result.addIDSFromOneSearch(this.sqlRs, this, aExpandRefs, nodeDN, ISID);
                        if (addRes.equals("OK")) {
                            result.setOK();
                            mVDSearchResults2 = result;
                            Object var10_12 = null;
                            break block20;
                        }
                        result.setError(addRes);
                        mVDSearchResults = result;
                        break block21;
                    }
                    catch (Exception ex) {
                        MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                        result.setError("ERROR:" + ex.getMessage());
                        MVDSearchResults mVDSearchResults22 = result;
                        Object var10_14 = null;
                        try {
                            if (this.sqlRs != null) {
                                this.sqlRs.close();
                            }
                            if (this.sqlStmt != null) {
                                this.sqlStmt.close();
                            }
                            if (this.mCacheConnections) return mVDSearchResults22;
                            if (this.sqlCon == null) return mVDSearchResults22;
                            if (this.sqlCon.isClosed()) return mVDSearchResults22;
                            this.sqlCon.close();
                            this.sqlCon = null;
                            return mVDSearchResults22;
                        }
                        catch (SQLException ex2) {
                            MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
                            result.setError("ERROR:" + ex2.getMessage());
                            return result;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    try {}
                    catch (SQLException ex2) {
                        MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
                        result.setError("ERROR:" + ex2.getMessage());
                        return result;
                    }
                    if (this.sqlRs != null) {
                        this.sqlRs.close();
                    }
                    if (this.sqlStmt != null) {
                        this.sqlStmt.close();
                    }
                    if (this.mCacheConnections) throw throwable;
                    if (this.sqlCon == null) throw throwable;
                    if (this.sqlCon.isClosed()) throw throwable;
                    this.sqlCon.close();
                    this.sqlCon = null;
                    throw throwable;
                }
            }
            try {}
            catch (SQLException ex2) {
                MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
                result.setError("ERROR:" + ex2.getMessage());
                return result;
            }
            if (this.sqlRs != null) {
                this.sqlRs.close();
            }
            if (this.sqlStmt != null) {
                this.sqlStmt.close();
            }
            if (this.mCacheConnections) return mVDSearchResults2;
            if (this.sqlCon == null) return mVDSearchResults2;
            if (this.sqlCon.isClosed()) return mVDSearchResults2;
            this.sqlCon.close();
            this.sqlCon = null;
            return mVDSearchResults2;
        }
        Object var10_13 = null;
        try {}
        catch (SQLException ex2) {
            MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
            result.setError("ERROR:" + ex2.getMessage());
            return result;
        }
        if (this.sqlRs != null) {
            this.sqlRs.close();
        }
        if (this.sqlStmt != null) {
            this.sqlStmt.close();
        }
        if (this.mCacheConnections) return mVDSearchResults;
        if (this.sqlCon == null) return mVDSearchResults;
        if (this.sqlCon.isClosed()) return mVDSearchResults;
        this.sqlCon.close();
        this.sqlCon = null;
        return mVDSearchResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MVDSearchResults oneSearchPrepared(String aQuery, ArrayList aParams, boolean bBaseCollect, int aExpandRefs, String nodeDN) throws Exception {
        MVDSearchResults mVDSearchResults;
        ResultSet rs;
        PreparedStatement ps;
        MVDSearchResults result;
        block24: {
            block23: {
                result = new MVDSearchResults();
                ps = this.idstoreconnection().prepareStatement(aQuery);
                rs = null;
                if (ps == null && this.mCacheConnections) {
                    ps = this.idstoreconnection().prepareStatement(aQuery);
                }
                if (ps == null) {
                    MVDLogger.Log("Couldn't create statement (connection ?)", 2);
                    result.setError(52, "Couldn't create statement - data source unavailable");
                    return result;
                }
                int isid = 1;
                try {
                    try {
                        for (int i = 0; i < aParams.size(); ++i) {
                            Object o = aParams.get(i);
                            if (o instanceof Integer) {
                                Integer integer = (Integer)o;
                                ps.setInt(i + 1, integer);
                                if (i != 0) continue;
                                isid = integer;
                                continue;
                            }
                            if (o instanceof String) {
                                String string = (String)o;
                                ps.setString(i + 1, string);
                                continue;
                            }
                            ps.setString(i + 1, o.toString());
                        }
                        rs = ps.executeQuery();
                        String addRes = "";
                        addRes = result.addIDSFromOneSearch(rs, this, aExpandRefs, nodeDN, isid);
                        if (addRes.equals("OK")) {
                            result.setOK();
                            mVDSearchResults = result;
                            Object var14_16 = null;
                            break block23;
                        }
                        result.setError(addRes);
                        mVDSearchResults = result;
                        break block24;
                    }
                    catch (Exception ex) {
                        MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                        result.setError("ERROR:" + ex.getMessage());
                        MVDSearchResults mVDSearchResults2 = result;
                        Object var14_18 = null;
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            if (ps != null) {
                                ps.close();
                            }
                            if (this.mCacheConnections) return mVDSearchResults2;
                            if (this.sqlCon == null) return mVDSearchResults2;
                            if (this.sqlCon.isClosed()) return mVDSearchResults2;
                            this.sqlCon.close();
                            this.sqlCon = null;
                            return mVDSearchResults2;
                        }
                        catch (SQLException ex2) {
                            MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
                            result.setError("ERROR:" + ex2.getMessage());
                            return result;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var14_19 = null;
                    try {}
                    catch (SQLException ex2) {
                        MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
                        result.setError("ERROR:" + ex2.getMessage());
                        return result;
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (this.mCacheConnections) throw throwable;
                    if (this.sqlCon == null) throw throwable;
                    if (this.sqlCon.isClosed()) throw throwable;
                    this.sqlCon.close();
                    this.sqlCon = null;
                    throw throwable;
                }
            }
            try {}
            catch (SQLException ex2) {
                MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
                result.setError("ERROR:" + ex2.getMessage());
                return result;
            }
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (this.mCacheConnections) return mVDSearchResults;
            if (this.sqlCon == null) return mVDSearchResults;
            if (this.sqlCon.isClosed()) return mVDSearchResults;
            this.sqlCon.close();
            this.sqlCon = null;
            return mVDSearchResults;
        }
        Object var14_17 = null;
        try {}
        catch (SQLException ex2) {
            MVDLogger.Log("SQLException: " + ex2.getMessage(), 2);
            result.setError("ERROR:" + ex2.getMessage());
            return result;
        }
        if (rs != null) {
            rs.close();
        }
        if (ps != null) {
            ps.close();
        }
        if (this.mCacheConnections) return mVDSearchResults;
        if (this.sqlCon == null) return mVDSearchResults;
        if (this.sqlCon.isClosed()) return mVDSearchResults;
        this.sqlCon.close();
        this.sqlCon = null;
        return mVDSearchResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MVDOperationResult Add(String is_id, String aID, HashMap hMap) {
        int iIsId = Integer.parseInt(is_id);
        MVDOperationResult result = new MVDOperationResult();
        boolean autoCommitWasOn = false;
        try {
            try {
                autoCommitWasOn = this.sqlCon.getAutoCommit();
                this.sqlCon.setAutoCommit(false);
                int iMsKey = 0;
                try {
                    iMsKey = this.micutil.Create_Entry_ID(iIsId, aID);
                }
                catch (Exception e) {
                    this.sqlCon.rollback();
                    this.sqlCon.setAutoCommit(autoCommitWasOn);
                    result.setError(68, "Can not add entry to MIC:" + e.toString());
                    MVDOperationResult mVDOperationResult = result;
                    Object var15_16 = null;
                    try {
                        if (this.mCacheConnections) return mVDOperationResult;
                        if (this.sqlCon == null) return mVDOperationResult;
                        this.sqlCon.close();
                        this.sqlCon = null;
                        return mVDOperationResult;
                    }
                    catch (SQLException ex) {
                        MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                        result.setError("ERROR:" + ex.getMessage());
                        return result;
                    }
                }
                int validateNeeded = 0;
                String rejectedElement = "";
                String element = "mx_entrytype";
                String ares = "";
                int validate = 0;
                if (hMap.containsKey("mx_entrytype")) {
                    ares = this.micutil.Add_IS_AttributeValue(iMsKey, iIsId, element, hMap);
                    validate = Integer.parseInt(ares);
                    if (validate == 0 && validateNeeded != 2) {
                        validateNeeded = 1;
                    } else if (validate > 0) {
                        validateNeeded = 2;
                        if (rejectedElement.length() > 0) {
                            rejectedElement = rejectedElement + ",";
                        }
                        rejectedElement = rejectedElement + element;
                        MVDLogger.Log("Rollback (attribute rejection): " + element, 2);
                    }
                }
                Iterator iter = hMap.keySet().iterator();
                while (iter.hasNext()) {
                    element = (String)iter.next();
                    if (element.equalsIgnoreCase("mx_entrytype")) continue;
                    ares = this.micutil.Add_IS_AttributeValue(iMsKey, iIsId, element, hMap);
                    validate = Integer.parseInt(ares);
                    if (validate == 0 && validateNeeded != 2) {
                        validateNeeded = 1;
                        continue;
                    }
                    if (validate <= 0) continue;
                    validateNeeded = 2;
                    if (rejectedElement.length() > 0) {
                        rejectedElement = rejectedElement + ",";
                    }
                    rejectedElement = rejectedElement + element;
                    MVDLogger.Log("Rollback (attribute rejection): " + element, 2);
                }
                if (validateNeeded == 2) {
                    this.sqlCon.rollback();
                } else {
                    String res = this.micutil.ValidateOp(iMsKey, validateNeeded);
                    if (!res.equals("0")) {
                        this.sqlCon.rollback();
                        MVDLogger.Log("Rollback (entry rejection): ", 2);
                    } else {
                        this.sqlCon.commit();
                    }
                }
                this.sqlCon.setAutoCommit(autoCommitWasOn);
                if (validateNeeded == 2) {
                    result.setError(65, rejectedElement + " rejected");
                } else {
                    result.setOK();
                }
            }
            catch (Exception e) {
                try {
                    this.sqlCon.rollback();
                    this.sqlCon.setAutoCommit(autoCommitWasOn);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                e.printStackTrace();
                result.setError(82, "Can not add entry to MIC:" + e.toString());
                Object var15_18 = null;
                try {}
                catch (SQLException ex) {
                    MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                    result.setError("ERROR:" + ex.getMessage());
                    return result;
                }
                if (this.mCacheConnections) return result;
                if (this.sqlCon == null) return result;
                this.sqlCon.close();
                this.sqlCon = null;
                return result;
            }
            catch (Error t) {
                try {
                    this.sqlCon.rollback();
                    this.sqlCon.setAutoCommit(autoCommitWasOn);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                t.printStackTrace();
                result.setError(82, "ERROR Can not add entry to MIC:" + t.toString());
                Object var15_19 = null;
                try {}
                catch (SQLException ex) {
                    MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                    result.setError("ERROR:" + ex.getMessage());
                    return result;
                }
                if (this.mCacheConnections) return result;
                if (this.sqlCon == null) return result;
                this.sqlCon.close();
                this.sqlCon = null;
                return result;
            }
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            try {}
            catch (SQLException ex) {
                MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                result.setError("ERROR:" + ex.getMessage());
                return result;
            }
            if (this.mCacheConnections) throw throwable;
            if (this.sqlCon == null) throw throwable;
            this.sqlCon.close();
            this.sqlCon = null;
            throw throwable;
        }
        try {}
        catch (SQLException ex) {
            MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
            result.setError("ERROR:" + ex.getMessage());
            return result;
        }
        if (this.mCacheConnections) return result;
        if (this.sqlCon == null) return result;
        this.sqlCon.close();
        this.sqlCon = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MVDOperationResult Modify(String is_id, String aID, Vector attrNamesAndModValues) {
        int iIsId = Integer.parseInt(is_id);
        MVDOperationResult result = new MVDOperationResult();
        boolean autoCommitWasOn = false;
        try {
            try {
                autoCommitWasOn = this.sqlCon.getAutoCommit();
                this.sqlCon.setAutoCommit(false);
                int iMsKey = 0;
                try {
                    iMsKey = this.micutil.Get_Entry_ID(iIsId, aID);
                }
                catch (Exception e) {
                    this.sqlCon.rollback();
                    this.sqlCon.setAutoCommit(autoCommitWasOn);
                    result.setError(32, "Can not add entry to MIC:" + e.toString());
                    MVDOperationResult mVDOperationResult = result;
                    Object var18_16 = null;
                    try {
                        if (this.mCacheConnections) return mVDOperationResult;
                        if (this.sqlCon == null) return mVDOperationResult;
                        this.sqlCon.close();
                        this.sqlCon = null;
                        return mVDOperationResult;
                    }
                    catch (SQLException ex) {
                        MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                        result.setError("ERROR:" + ex.getMessage());
                        return result;
                    }
                }
                int validateNeeded = 0;
                int ls = attrNamesAndModValues.size();
                for (int i = 0; i < ls; ++i) {
                    String ares;
                    MVDModAttrValues oneMvdMod = (MVDModAttrValues)attrNamesAndModValues.elementAt(i);
                    String attrName = oneMvdMod.getAttrName();
                    int modType = oneMvdMod.getModType();
                    int idMod = 0;
                    if (modType == 0) {
                        idMod = 0;
                    } else if (modType == 1) {
                        if (oneMvdMod.size() == 0) {
                            idMod = 0;
                            ares = this.micutil.Set_IS_Attribute(iMsKey, iIsId, attrName, idMod, "");
                        } else {
                            idMod = 2;
                        }
                    } else {
                        idMod = 0;
                        ares = this.micutil.Set_IS_Attribute(iMsKey, iIsId, attrName, idMod, "");
                    }
                    ares = this.micutil.Modify_IS_AttributeValue(iMsKey, iIsId, attrName, idMod, oneMvdMod);
                    int validate = Integer.parseInt(ares);
                    if (validate == 0 && validateNeeded != 2) {
                        validateNeeded = 1;
                        continue;
                    }
                    if (validate <= 0) continue;
                    validateNeeded = 2;
                }
                boolean brollback = false;
                if (validateNeeded == 2) {
                    this.sqlCon.rollback();
                    brollback = true;
                } else {
                    String res = this.micutil.ValidateOp(iMsKey, validateNeeded);
                    if (!res.equals("0")) {
                        this.sqlCon.rollback();
                        brollback = true;
                    } else {
                        this.sqlCon.commit();
                    }
                }
                this.sqlCon.setAutoCommit(autoCommitWasOn);
                if (brollback) {
                    result.setError(82, "ERROR: Can not modify entry - rollback executed");
                } else {
                    result.setOK();
                }
            }
            catch (Exception e) {
                try {
                    this.sqlCon.rollback();
                    this.sqlCon.setAutoCommit(autoCommitWasOn);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                e.printStackTrace();
                result.setError(82, "Can not modify entry:" + e.toString());
                Object var18_18 = null;
                try {}
                catch (SQLException ex) {
                    MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                    result.setError("ERROR:" + ex.getMessage());
                    return result;
                }
                if (this.mCacheConnections) return result;
                if (this.sqlCon == null) return result;
                this.sqlCon.close();
                this.sqlCon = null;
                return result;
            }
            catch (Error t) {
                try {
                    this.sqlCon.rollback();
                    this.sqlCon.setAutoCommit(autoCommitWasOn);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                t.printStackTrace();
                result.setError(82, "ERROR Can not modify entry:" + t.toString());
                Object var18_19 = null;
                try {}
                catch (SQLException ex) {
                    MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                    result.setError("ERROR:" + ex.getMessage());
                    return result;
                }
                if (this.mCacheConnections) return result;
                if (this.sqlCon == null) return result;
                this.sqlCon.close();
                this.sqlCon = null;
                return result;
            }
            Object var18_17 = null;
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            try {}
            catch (SQLException ex) {
                MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                result.setError("ERROR:" + ex.getMessage());
                return result;
            }
            if (this.mCacheConnections) throw throwable;
            if (this.sqlCon == null) throw throwable;
            this.sqlCon.close();
            this.sqlCon = null;
            throw throwable;
        }
        try {}
        catch (SQLException ex) {
            MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
            result.setError("ERROR:" + ex.getMessage());
            return result;
        }
        if (this.mCacheConnections) return result;
        if (this.sqlCon == null) return result;
        this.sqlCon.close();
        this.sqlCon = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MVDOperationResult Delete(String is_id, String aID) {
        int iIsId = Integer.parseInt(is_id);
        MVDOperationResult result = new MVDOperationResult();
        boolean autoCommitWasOn = false;
        try {
            try {
                autoCommitWasOn = this.sqlCon.getAutoCommit();
                this.sqlCon.setAutoCommit(false);
                String ares = this.micutil.Delete_IS_Entry(iIsId, aID);
                this.sqlCon.commit();
                this.sqlCon.setAutoCommit(autoCommitWasOn);
                result.setOK();
            }
            catch (Exception e) {
                try {
                    this.sqlCon.rollback();
                    this.sqlCon.setAutoCommit(autoCommitWasOn);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                e.printStackTrace();
                result.setError(82, "Can not remove entry from MIC:" + e.toString());
                Object var9_10 = null;
                try {
                    if (this.mCacheConnections) return result;
                    if (this.sqlCon == null) return result;
                    this.sqlCon.close();
                    this.sqlCon = null;
                    return result;
                }
                catch (SQLException ex) {
                    MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                    result.setError("ERROR:" + ex.getMessage());
                    return result;
                }
            }
            catch (Error t) {
                try {
                    this.sqlCon.rollback();
                    this.sqlCon.setAutoCommit(autoCommitWasOn);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                t.printStackTrace();
                result.setError(82, "ERROR Can not remove entry from MIC:" + t.toString());
                Object var9_11 = null;
                try {}
                catch (SQLException ex) {
                    MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                    result.setError("ERROR:" + ex.getMessage());
                    return result;
                }
                if (this.mCacheConnections) return result;
                if (this.sqlCon == null) return result;
                this.sqlCon.close();
                this.sqlCon = null;
                return result;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {}
            catch (SQLException ex) {
                MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                result.setError("ERROR:" + ex.getMessage());
                return result;
            }
            if (this.mCacheConnections) throw throwable;
            if (this.sqlCon == null) throw throwable;
            this.sqlCon.close();
            this.sqlCon = null;
            throw throwable;
        }
        try {}
        catch (SQLException ex) {
            MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
            result.setError("ERROR:" + ex.getMessage());
            return result;
        }
        if (this.mCacheConnections) return result;
        if (this.sqlCon == null) return result;
        this.sqlCon.close();
        this.sqlCon = null;
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MVDOperationResult compare(String aIDStore, String aID, String aAttrName, String aAttrValue) throws Exception {
        MVDOperationResult mVDOperationResult;
        int mskey = -1;
        MVDOperationResult res = new MVDOperationResult();
        Statement stmt = null;
        try {
            int idstore = Integer.parseInt(aIDStore);
            mskey = this.micutil.Get_Entry_ID(idstore, aID);
            stmt = this.micutil.initStoredProcedure(11);
            stmt.setInt(1, mskey);
            stmt.setInt(2, 0);
            stmt.setString(3, aAttrName);
            stmt.setString(4, aAttrValue);
            stmt.registerOutParameter(5, 4);
            stmt.execute();
            int ok = stmt.getInt(5);
            stmt.close();
            stmt = null;
            if (ok == 1) {
                res.setOK();
            } else {
                res.setError();
            }
            mVDOperationResult = res;
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (this.mCacheConnections) throw throwable;
                if (this.sqlCon == null) throw throwable;
                this.sqlCon.close();
                this.sqlCon = null;
                throw throwable;
            }
            catch (SQLException ex) {
                MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
                res.setError("ERROR:" + ex.getMessage());
                return res;
            }
        }
        try {}
        catch (SQLException ex) {
            MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
            res.setError("ERROR:" + ex.getMessage());
            return res;
        }
        if (stmt != null) {
            stmt.close();
        }
        if (this.mCacheConnections) return mVDOperationResult;
        if (this.sqlCon == null) return mVDOperationResult;
        this.sqlCon.close();
        this.sqlCon = null;
        return mVDOperationResult;
    }

    public boolean bindToIDStore(String dbconnstring) {
        Connection sqlCon = null;
        this.ExtractFakeUserPassword(dbconnstring);
        try {
            sqlCon = this.mAdditionalUser.length() == 0 ? DriverManager.getConnection(dbconnstring) : DriverManager.getConnection(this.mConnStringRest, this.mAdditionalUser, this.mAdditionalPassword);
            return true;
        }
        catch (SQLException ex) {
            MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
            return false;
        }
    }

    private void ExtractFakeUserPassword(String wholeConnectionString) {
        String aName = "";
        String aValue = "";
        String theRest = "";
        int M = wholeConnectionString.indexOf("!!!");
        if (M > 0) {
            theRest = wholeConnectionString.substring(M + 3);
            this.mConnStringRest = wholeConnectionString.substring(0, M);
            Vector v = MVDUtil.splitString(theRest, ";");
            for (int x = 0; x < v.size(); ++x) {
                String a = (String)v.elementAt(x);
                Vector vv = MVDUtil.splitString(a, "=");
                aName = (String)vv.elementAt(0);
                aValue = (String)vv.elementAt(1);
                if (aName.equalsIgnoreCase("user")) {
                    this.mAdditionalUser = aValue;
                    continue;
                }
                if (!aName.equalsIgnoreCase("password")) continue;
                this.mAdditionalPassword = aValue;
            }
        }
    }

    private Connection getConnection(String dbconnstring) {
        Connection aSQLConn = null;
        try {
            if (this.mCacheConnections) {
                aSQLConn = (Connection)MVDGlobals.existingConnections.get(dbconnstring);
                if (aSQLConn == null) {
                    aSQLConn = this.mAdditionalUser.length() == 0 ? DriverManager.getConnection(dbconnstring) : DriverManager.getConnection(this.mConnStringRest, this.mAdditionalUser, this.mAdditionalPassword);
                    MVDGlobals.existingConnections.put(dbconnstring, aSQLConn);
                }
            } else {
                aSQLConn = this.mAdditionalUser.length() == 0 ? DriverManager.getConnection(dbconnstring) : DriverManager.getConnection(this.mConnStringRest, this.mAdditionalUser, this.mAdditionalPassword);
            }
            if (aSQLConn != null) {
                String dbName = aSQLConn.getMetaData().getDatabaseProductName();
                if (dbName.equalsIgnoreCase("Microsoft SQL Server")) {
                    mDBInfo = "1";
                } else if (dbName.equalsIgnoreCase("Oracle")) {
                    mDBInfo = "2";
                }
            }
            return aSQLConn;
        }
        catch (SQLException ex) {
            MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
            MVDGlobals.existingConnections.remove(dbconnstring);
            return null;
        }
    }

    private Statement getStatement(String dbconnstring) {
        try {
            Connection sq = this.getConnection(dbconnstring);
            if (sq != null) {
                Statement localSqlStmt = sq.createStatement();
                return localSqlStmt;
            }
            return null;
        }
        catch (SQLException ex) {
            MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
            return null;
        }
    }

    private Statement getPreparedStatement(String dbconnstring) {
        try {
            Connection sq = this.getConnection(dbconnstring);
            if (sq != null) {
                Statement localSqlStmt = sq.createStatement();
                return localSqlStmt;
            }
            return null;
        }
        catch (SQLException ex) {
            MVDLogger.Log("SQLException: " + ex.getMessage(), 2);
            return null;
        }
    }

    public String expandRef(String aDatatypeid, String avalue, HashMap aCache, int aExpRefs) {
        try {
            if (aCache != null && aCache.containsKey(avalue)) {
                return (String)aCache.get(avalue);
            }
            Statement s = this.idstoreconnection().createStatement();
            ResultSet rs = null;
            if (aDatatypeid.equalsIgnoreCase("5")) {
                rs = s.executeQuery("SELECT aValue FROM MXIV_ENTRIES WHERE mskey=" + avalue + " AND AttrName='MSKEYVALUE'");
            } else if (aDatatypeid.equalsIgnoreCase("6")) {
                rs = s.executeQuery("SELECT semaphorename FROM mxp_semaphore_names WHERE semaphoreid=" + avalue);
            } else {
                return avalue;
            }
            String retval = avalue;
            if (rs.next()) {
                retval = aExpRefs == 1 ? rs.getString(1) + " (" + retval + ")" : rs.getString(1);
            }
            rs.close();
            s.close();
            if (aCache != null) {
                aCache.put(avalue, retval);
            }
            return retval;
        }
        catch (Exception e) {
            return avalue;
        }
    }

    public String get_large_attribute(int ISID, int mskey, String attrName, String md5Value) throws Exception {
        return this.micutil.getLargeAttributeValue(ISID, mskey, attrName, md5Value);
    }

    static {
        mLargeAttributeLength = 2000;
        mLargeAttributePrefix = "!<MD5=";
        mDBInfo = "1";
        StoredProcedures = new StoredProcedure[]{new StoredProcedure("mxie_create", 2, 2), new StoredProcedure("mxie_get", 2, 2), new StoredProcedure("mxi_setvalue", 4, 2), new StoredProcedure("mxi_GetError", 1, 1), new StoredProcedure("mxi_xsetvalue", 4, 3), new StoredProcedure("mxi_xgetvalue", 3, 3), new StoredProcedure("mc_write_syslog", 5, 0), new StoredProcedure("mxie_delete", 2, 2), new StoredProcedure("mxi_validate", 2, 2), new StoredProcedure("mxi_xsetattribute", 7, 4), new StoredProcedure("misa_jokic", 1, 3), new StoredProcedure("mxi_compare", 4, 1), new StoredProcedure("MX_UTILSETATTRIBUTE.mxi_xsetattribute", 7, 4), new StoredProcedure("mxp_list_container_entries", 6, 1), new StoredProcedure("mxp_list_container_entries", 6, 0)};
    }
}

