/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.util;

import com.sap.idm.vds.MVDLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigUtil {
    public static HashMap readParams(Node aParamRecord, String aKeyPrefix, boolean aUpperCase) {
        HashMap<String, String> params = new HashMap<String, String>();
        NodeList nl = aParamRecord.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            NamedNodeMap nnm;
            Node n = nl.item(i);
            if (!(n instanceof Element) || (nnm = n.getAttributes()).getLength() <= 0) continue;
            String name = nnm.getNamedItem("name").getNodeValue();
            String value = nnm.getNamedItem("value").getNodeValue();
            String key = aKeyPrefix + name;
            if (aUpperCase) {
                key = key.toUpperCase();
            }
            params.put(key, value);
        }
        return params;
    }

    public static HashMap readParams(Node aParamRecord) {
        return ConfigUtil.readParams(aParamRecord, "", true);
    }

    public static HashMap readParams(Node aParamRecord, boolean aUpperCase) {
        return ConfigUtil.readParams(aParamRecord, "", aUpperCase);
    }

    public static void writeKKRFile(String aFileName, Throwable aThrowable) {
        try {
            String message = aThrowable == null ? "Reload configuration succeeded" : "Reload failed: " + aThrowable.getMessage();
            File f = new File(aFileName);
            FileWriter writer = new FileWriter(f);
            writer.write(message);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            MVDLogger.Log("Failed writing kkr file", 6, e);
        }
    }

    public static void printNode(Node aNode, OutputStream aOut) {
        block3: {
            Transformer serializer = null;
            try {
                Element root = aNode.getOwnerDocument().getDocumentElement();
                TransformerFactory tfactory = TransformerFactory.newInstance();
                serializer = tfactory.newTransformer();
                Properties oprops = new Properties();
                oprops.put("method", "XML");
                oprops.put("indent", "yes");
                oprops.put("omit-xml-declaration", "yes");
                serializer.setOutputProperties(oprops);
                DOMSource src = new DOMSource(aNode);
                StreamResult dest = new StreamResult(aOut);
                serializer.transform(src, dest);
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (serializer == null) break block3;
                Properties props = serializer.getOutputProperties();
                Enumeration<?> keys = props.propertyNames();
                while (keys.hasMoreElements()) {
                    String name = (String)keys.nextElement();
                }
            }
        }
    }
}

