/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.snmp;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.snmp.Asn1Integer;
import com.sap.idm.vds.snmp.Asn1Object;
import com.sap.idm.vds.snmp.Asn1ObjectId;
import com.sap.idm.vds.snmp.Asn1OctetString;
import com.sap.idm.vds.snmp.Asn1Sequence;
import com.sap.idm.vds.snmp.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;

public class SNMPTrap {
    private final int TRAP_GENERIC_TYPE = 6;
    private final int TRAP_SPECIFIC_TYPE = 2;
    private final String MAXWARE_ENTERPRISE_OID = "1.3.6.1.4.1.9331";
    public static final int DEFAULT_SNMP_TRAP_PORT = 162;
    private String mCommunity = "public";
    private long mStartTime = System.currentTimeMillis();
    private byte[] mMyAddress;
    private InetAddress mDestination;
    private int mPort;
    private DatagramSocket mSocket = null;

    public SNMPTrap() throws UnknownHostException {
        InetAddress localhost = InetAddress.getLocalHost();
        this.mMyAddress = localhost.getAddress();
        this.mDestination = localhost;
        this.mPort = 162;
    }

    public SNMPTrap(String aDestination) throws UnknownHostException {
        this();
        this.mDestination = InetAddress.getByName(aDestination);
    }

    public SNMPTrap(String aDestination, int aPort) throws UnknownHostException {
        this();
        this.mDestination = InetAddress.getByName(aDestination);
        this.mPort = aPort;
    }

    public boolean sendTrap(int aMessageType, String aMessage) {
        String msgOID = "1.3.6.1.4.1.9331.2." + aMessageType;
        String msg = "VDS: " + aMessage;
        return this.sendTrap("1.3.6.1.4.1.9331", 6, 2, msgOID, msg);
    }

    public boolean sendTrap(HashMap aTypeMessagePairs) {
        HashMap<String, String> aMsgOIDMessagePairs = new HashMap<String, String>();
        Iterator iter = aTypeMessagePairs.keySet().iterator();
        while (iter.hasNext()) {
            String aMessageType = (String)iter.next();
            String msgOID = "1.3.6.1.4.1.9331.2." + aMessageType;
            String aMessage = (String)aTypeMessagePairs.get(aMessageType);
            String msg = "VDS: " + aMessage;
            aMsgOIDMessagePairs.put(msgOID, msg);
        }
        return this.sendTrap("1.3.6.1.4.1.9331", 6, 2, aTypeMessagePairs);
    }

    public boolean sendTrap(String aEnterpriseOID, int aGenericType, int aSpecificType, String aMessageOID, String aMessage) {
        long timeTicks = (System.currentTimeMillis() - this.mStartTime) / 10L;
        try {
            ByteArrayOutputStream baos = this.EncodeSNMPTrap(this.mMyAddress, aEnterpriseOID, aGenericType, aSpecificType, timeTicks, aMessageOID, aMessage);
            if (this.mSocket == null) {
                this.mSocket = new DatagramSocket();
            }
            byte[] packet = baos.toByteArray();
            DatagramPacket pack = new DatagramPacket(packet, packet.length, this.mDestination, this.mPort);
            this.mSocket.send(pack);
        }
        catch (Exception e) {
            MVDLogger.Log("Error sending trap: " + e.toString(), 7, e);
            return false;
        }
        return true;
    }

    public boolean sendTrap(String aEnterpriseOID, int aGenericType, int aSpecificType, HashMap aOIDMessagePairs) {
        long timeTicks = (System.currentTimeMillis() - this.mStartTime) / 10L;
        try {
            ByteArrayOutputStream baos = this.EncodeSNMPTrap(this.mMyAddress, aEnterpriseOID, aGenericType, aSpecificType, timeTicks, aOIDMessagePairs);
            if (this.mSocket == null) {
                this.mSocket = new DatagramSocket();
            }
            byte[] packet = baos.toByteArray();
            DatagramPacket pack = new DatagramPacket(packet, packet.length, this.mDestination, this.mPort);
            this.mSocket.send(pack);
        }
        catch (Exception e) {
            MVDLogger.Log("Error sending trap: " + e.toString(), 7, e);
            return false;
        }
        return true;
    }

    private ByteArrayOutputStream EncodeSNMPTrap(byte[] aIPAddress, String aEnterpriseOID, int aGenericTrap, int aSpecificTrap, long aTimeTicks, String aMessageOID, String aMessage) throws IOException {
        Asn1Sequence asnTopSeq = new Asn1Sequence();
        asnTopSeq.add(new Asn1Integer(0L));
        asnTopSeq.add(new Asn1OctetString(this.mCommunity));
        Asn1Object asnPduObject = this.EncodeTrap1Pdu((byte)-92, aEnterpriseOID, aIPAddress, aGenericTrap, aSpecificTrap, aTimeTicks, aMessageOID, aMessage);
        asnTopSeq.add(asnPduObject);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        asnTopSeq.write(bout);
        return bout;
    }

    private ByteArrayOutputStream EncodeSNMPTrap(byte[] aIPAddress, String aEnterpriseOID, int aGenericTrap, int aSpecificTrap, long aTimeTicks, HashMap aOIDMessagePairs) throws IOException {
        Asn1Sequence asnTopSeq = new Asn1Sequence();
        asnTopSeq.add(new Asn1Integer(0L));
        asnTopSeq.add(new Asn1OctetString(this.mCommunity));
        Asn1Object asnPduObject = this.EncodeTrap1Pdu((byte)-92, aEnterpriseOID, aIPAddress, aGenericTrap, aSpecificTrap, aTimeTicks, aOIDMessagePairs);
        asnTopSeq.add(asnPduObject);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        asnTopSeq.write(bout);
        return bout;
    }

    private Asn1Object EncodeTrap1Pdu(byte aMsgType, String aEnterpriseOID, byte[] aIPAddress, int aGenericTrap, int aSpecificTrap, long aTimeTicks, String aMessageOID, String aMessage) throws IOException {
        if (aMessage.toLowerCase().indexOf("$date") >= 0) {
            aMessage = MVDUtil.replaceIgnoreCase(aMessage, "$date", Util.getDate());
        }
        Asn1Sequence asnPduObject = new Asn1Sequence(aMsgType);
        ((Asn1Object)asnPduObject).add(new Asn1ObjectId(aEnterpriseOID));
        ((Asn1Object)asnPduObject).add(new Asn1OctetString(aIPAddress, 64));
        ((Asn1Object)asnPduObject).add(new Asn1Integer(aGenericTrap));
        ((Asn1Object)asnPduObject).add(new Asn1Integer(aSpecificTrap));
        ((Asn1Object)asnPduObject).add(new Asn1Integer(aTimeTicks, 67));
        if (aMessageOID != null && aMessageOID.length() > 0) {
            Asn1Object asnVBLObject = ((Asn1Object)asnPduObject).add(new Asn1Sequence());
            Asn1Object asnVBObject = asnVBLObject.add(new Asn1Sequence());
            asnVBObject.add(new Asn1ObjectId(aMessageOID));
            asnVBObject.add(new Asn1OctetString(aMessage));
        }
        return asnPduObject;
    }

    private Asn1Object EncodeTrap1Pdu(byte aMsgType, String aEnterpriseOID, byte[] aIPAddress, int aGenericTrap, int aSpecificTrap, long aTimeTicks, HashMap aOIDMessagePairs) throws IOException {
        Asn1Sequence asnPduObject = new Asn1Sequence(aMsgType);
        ((Asn1Object)asnPduObject).add(new Asn1ObjectId(aEnterpriseOID));
        ((Asn1Object)asnPduObject).add(new Asn1OctetString(aIPAddress, 64));
        ((Asn1Object)asnPduObject).add(new Asn1Integer(aGenericTrap));
        ((Asn1Object)asnPduObject).add(new Asn1Integer(aSpecificTrap));
        ((Asn1Object)asnPduObject).add(new Asn1Integer(aTimeTicks, 67));
        Asn1Object asnVBLObject = ((Asn1Object)asnPduObject).add(new Asn1Sequence());
        Iterator iter = aOIDMessagePairs.keySet().iterator();
        while (iter.hasNext()) {
            String aMessageOID = (String)iter.next();
            Object obMessage = aOIDMessagePairs.get(aMessageOID);
            if (aMessageOID == null || aMessageOID.length() <= 0) continue;
            Asn1Object asnVBObject = asnVBLObject.add(new Asn1Sequence());
            asnVBObject.add(new Asn1ObjectId(aMessageOID));
            if (obMessage instanceof String) {
                String aMessage = (String)obMessage;
                if (aMessage.toLowerCase().indexOf("$date") >= 0) {
                    aMessage = MVDUtil.replaceIgnoreCase(aMessage, "$date", Util.getDate());
                }
                asnVBObject.add(new Asn1OctetString(aMessage));
                continue;
            }
            if (obMessage instanceof Integer) {
                asnVBObject.add(new Asn1Integer(((Integer)obMessage).intValue()));
                continue;
            }
            MVDLogger.Debug("Unknown SNMP Interface class " + obMessage.getClass(), 6);
        }
        return asnPduObject;
    }

    private static String dumpBytes(byte[] aBytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < aBytes.length; ++i) {
            String s;
            if (i % 32 == 0 && i != 0) {
                sb.append("\n");
            }
            if ((s = Integer.toHexString(aBytes[i])).length() < 2) {
                s = "0" + s;
            }
            if (s.length() > 2) {
                s = s.substring(s.length() - 2);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public String getCommunity() {
        return this.mCommunity;
    }

    public void setCommunity(String aCommunity) {
        this.mCommunity = aCommunity;
    }

    public InetAddress getDestination() {
        return this.mDestination;
    }

    public void setDestination(InetAddress aDestination) {
        this.mDestination = aDestination;
    }

    public int getDestinationPort() {
        return this.mPort;
    }

    public void setDestinationPort(int aPort) {
        this.mPort = aPort;
    }

    public static void main(String[] aArgs) throws UnknownHostException {
        SNMPTrap sender = new SNMPTrap();
        String mess = "123456789abcdef0";
        String enterpriseOID = "1.3.6.1.4.1.9331";
        int genericType = 6;
        int specificType = 2;
        String messageOID = "1.3.6.1.4.1.9331.2.1.4";
        sender.sendTrap(enterpriseOID, genericType, specificType, messageOID, mess);
    }
}

