/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.snmp;

import com.sap.idm.vds.snmp.Asn1Object;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Asn1ObjectId
extends Asn1Object {
    private long[] mValue = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 9331L, 1L, 4L};

    Asn1ObjectId() {
    }

    Asn1ObjectId(InputStream aInputStream, int aLength) throws IOException {
        int off;
        byte[] data = new byte[aLength];
        if (aLength != aInputStream.read(data, 0, aLength)) {
            throw new IOException("Asn1ObjectId(): Not enough data");
        }
        int sids = 1;
        for (off = 0; off < aLength; ++off) {
            if (data[off] < 0) continue;
            ++sids;
        }
        this.mValue = new long[sids];
        this.mValue[0] = data[0] / 40;
        this.mValue[1] = data[0] % 40;
        off = 1;
        for (int idx = 2; idx < this.mValue.length; ++idx) {
            long tval = 0L;
            do {
                tval <<= 7;
                tval |= (long)(data[off] & 0x7F);
            } while (data[off++] < 0);
            this.mValue[idx] = tval;
        }
    }

    public Asn1ObjectId(String aStringRepresentation) throws IllegalArgumentException {
        int count = 1;
        int pos = aStringRepresentation.indexOf(46);
        while (pos >= 0) {
            pos = aStringRepresentation.indexOf(46, pos + 1);
            ++count;
        }
        this.mValue = new long[count];
        int opos = 0;
        try {
            for (int n = 0; n < count; ++n) {
                pos = aStringRepresentation.indexOf(46, opos);
                String num = pos > 0 ? aStringRepresentation.substring(opos, pos) : aStringRepresentation.substring(opos);
                Long val = Long.valueOf(num);
                if (val < 0L || val > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Asn1ObjectId(): Bad OID " + aStringRepresentation + " a part of the OID was outside range");
                }
                this.mValue[n] = val;
                opos = pos + 1;
            }
        }
        catch (NumberFormatException exc) {
            throw new IllegalArgumentException("Asn1ObjectId(): Bad OID " + aStringRepresentation + " " + exc.getMessage());
        }
    }

    public boolean startsWith(Asn1ObjectId aPrefix) {
        boolean sw = true;
        if (aPrefix.mValue.length < this.mValue.length) {
            for (int pos = 0; pos < aPrefix.mValue.length && sw; ++pos) {
                sw = aPrefix.mValue[pos] == this.mValue[pos];
            }
        } else {
            sw = false;
        }
        return sw;
    }

    boolean same(Asn1ObjectId aCompareWith) {
        boolean result = false;
        if (this.mValue.length == aCompareWith.mValue.length) {
            int n = 0;
            for (n = 0; n < this.mValue.length && this.mValue[n] == aCompareWith.mValue[n]; ++n) {
            }
            result = n == this.mValue.length;
        }
        return result;
    }

    int size() {
        int len = this.getSIDLen(this.mValue[0] * 40L + this.mValue[1]);
        for (int idx = 2; idx < this.mValue.length; ++idx) {
            len += this.getSIDLen(this.mValue[idx]);
        }
        return len;
    }

    void write(OutputStream aOutputStream, int aPosition) throws IOException {
        this.Asn1BuildHeader(aOutputStream, (byte)6, this.size());
        this.EncodeSID(aOutputStream, this.mValue[0] * 40L + this.mValue[1]);
        for (int idx = 2; idx < this.mValue.length; ++idx) {
            this.EncodeSID(aOutputStream, this.mValue[idx]);
        }
    }

    private int getSIDLen(long aValue) {
        int count = 1;
        while ((aValue >>= 7) != 0L) {
            ++count;
        }
        return count;
    }

    private void EncodeSID(OutputStream aOutputStream, long aValue) throws IOException {
        int mask = 15;
        int count = 0;
        mask = 15;
        for (count = 28; count > 0 && (aValue >> count & (long)mask) == 0L; count -= 7) {
            mask = 127;
        }
        while (count >= 0) {
            aOutputStream.write((byte)(aValue >> count & (long)mask | (long)(count > 0 ? 128 : 0)));
            mask = 127;
            count -= 7;
        }
    }

    public String getValue() {
        return this.toString();
    }

    public String toString() {
        String result = "";
        for (int n = 0; n < this.mValue.length - 1; ++n) {
            result = result + this.mValue[n] + ".";
        }
        result = result + this.mValue[this.mValue.length - 1];
        return result;
    }

    public int getSize() {
        return this.mValue.length;
    }

    public synchronized long getElementAt(int aIndex) throws ArrayIndexOutOfBoundsException {
        if (aIndex >= this.mValue.length) {
            throw new ArrayIndexOutOfBoundsException(aIndex + " >= " + this.mValue.length);
        }
        try {
            return this.mValue[aIndex];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw new ArrayIndexOutOfBoundsException(aIndex + " < 0");
        }
    }
}

