/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.snmp;

import java.io.IOException;
import java.io.OutputStream;

public abstract class Asn1Object {
    public static final byte ASN1_BOOLEAN = 1;
    public static final byte ASN1_INTEGER = 2;
    static final byte ASN1_BITSTRING = 3;
    public static final byte ASN1_OCTETSTRING = 4;
    public static final byte ASN1_NULL = 5;
    public static final byte ASN1_OBJECT_IDENTIFIER = 6;
    public static final byte ASN1_OBJECT_DESCRIPTOR = 7;
    public static final byte ASN1_EXTERNAL = 8;
    public static final byte ASN1_REAL = 9;
    public static final byte ASN1_ENUMERATED = 10;
    public static final byte ASN1_SEQUENCE = 16;
    public static final byte ASN1_NUMERICSTRING = 18;
    public static final byte ASN1_PRINTABLESTRING = 19;
    public static final byte ASN1_TELETEXSTRING = 20;
    public static final byte ASN1_VIDEOTEXSTRING = 21;
    public static final byte ASN1_IA5STRING = 22;
    public static final byte ASN1_UTCTIME = 23;
    public static final byte ASN1_GENERALIZEDTIME = 24;
    public static final byte ASN1_GRAPHICSTRING = 25;
    public static final byte ASN1_VISIBLESTRING = 26;
    public static final byte ASN1_GENERALSTRING = 27;
    public static final byte ASN1_UNIVERSAL = 0;
    public static final byte ASN1_APPLICATION = 64;
    public static final byte ASN1_CONTEXT = -128;
    public static final byte ASN1_PRIVATE = -64;
    public static final byte ASN1_PRIMITIVE = 0;
    public static final byte ASN1_CONSTRUCTOR = 32;
    public static final byte ASN1_LONG_LEN = -128;
    private byte mTag;
    private int mStartPos = 0;
    private int mHeaderLength = 0;
    private int mContentsLength = 0;

    abstract void write(OutputStream var1, int var2) throws IOException;

    public abstract String toString();

    Asn1Object add(Asn1Object aChild) {
        return aChild;
    }

    void Asn1BuildHeader(OutputStream aOutputStream, byte aTag, int aLength) throws IOException {
        this.mTag = aTag;
        aOutputStream.write(this.mTag);
        int count = this.getLengthBytes(aLength);
        this.mHeaderLength = count + 1;
        this.mContentsLength = aLength;
        if (count > 1) {
            byte tmp = (byte)(0x80 | (byte)(--count));
            aOutputStream.write(tmp);
        }
        while (count != 0) {
            aOutputStream.write((byte)(aLength >> (--count << 3) & 0xFF));
        }
    }

    int size() {
        return 0;
    }

    int getLengthBytes(int aLength) {
        if (aLength < 128) {
            return 1;
        }
        int mask = -16777216;
        int count = 4;
        while ((aLength & mask) == 0) {
            mask >>= 8;
            --count;
        }
        return count + 1;
    }

    int getContentsPos() {
        return this.mStartPos + this.mHeaderLength;
    }

    protected int getContentsLength() {
        return this.mContentsLength;
    }

    protected byte getTag() {
        return this.mTag;
    }

    protected void setTag(byte aTag) {
        this.mTag = aTag;
    }

    protected int getStartPos() {
        return this.mStartPos;
    }

    protected void setStartPos(int aStartPos) {
        this.mStartPos = aStartPos;
    }

    protected int getHeaderLength() {
        return this.mHeaderLength;
    }
}

