/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.snmp;

import com.sap.idm.vds.snmp.Asn1Object;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Asn1Integer
extends Asn1Object {
    private long mValue;

    public Asn1Integer(long aValue) {
        this(aValue, 2);
    }

    public Asn1Integer(long aValue, byte aTag) {
        this.mValue = aValue;
        this.setTag(aTag);
    }

    public Asn1Integer(InputStream aInputStream, int aLength) throws IOException {
        long val;
        byte[] data = new byte[aLength];
        if (aLength != aInputStream.read(data, 0, aLength)) {
            throw new IOException("Asn1Integer(): Not enough data");
        }
        this.mValue = val = this.bytesToLong(data);
    }

    public long getValue() {
        return this.mValue;
    }

    public String toString() {
        return String.valueOf(this.mValue);
    }

    int size() {
        int count;
        int empty = 0;
        int sign = 0;
        if (this.mValue < 0L) {
            empty = 255;
            sign = 128;
        }
        for (count = 24; count > 0 && (this.mValue >> count & 0xFFL) == (long)empty; count -= 8) {
        }
        if ((this.mValue >> count & 0x80L) != (long)sign) {
            count += 8;
        }
        return (count >> 3) + 1;
    }

    void write(OutputStream aOutputStream, int aPosition) throws IOException {
        int count;
        int empty = 0;
        int sign = 0;
        if (this.mValue < 0L) {
            empty = 255;
            sign = 128;
        }
        for (count = 24; count > 0 && (this.mValue >> count & 0xFFL) == (long)empty; count -= 8) {
        }
        if ((this.mValue >> count & 0x80L) != (long)sign) {
            count += 8;
        }
        this.Asn1BuildHeader(aOutputStream, this.getTag(), (count >> 3) + 1);
        while (count >= 0) {
            aOutputStream.write((byte)(this.mValue >> count & 0xFFL));
            count -= 8;
        }
    }

    private long bytesToLong(byte[] aData) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(aData));
        long val = 0L;
        int size = aData.length;
        for (int n = 0; n < size; ++n) {
            val = (val << 8) + (long)dis.readUnsignedByte();
        }
        return val;
    }
}

