/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.sldreg.common;

import java.io.OutputStream;
import java.net.HttpURLConnection;

public abstract class SLDInfoUploaderBase {
    private static final String ENCODING = "UTF-8";
    private static final String DESTINATION_URL_PATH = "sld/ds";

    protected abstract HttpURLConnection getSLDConnection() throws Exception;

    public void sendXMLToSLD(String xmlForSLD) throws Exception {
        HttpURLConnection sldConnection = this.getSLDConnection();
        sldConnection.setRequestMethod("POST");
        sldConnection.setRequestProperty("dsxmlversion", "2.0");
        sldConnection.setRequestProperty("Content-Type", "application/xml; charset=utf-8");
        sldConnection.setRequestProperty("Content-Length", Integer.toString(xmlForSLD.length()));
        OutputStream stream = sldConnection.getOutputStream();
        stream.write(xmlForSLD.getBytes(ENCODING));
        sldConnection.connect();
        if (sldConnection.getResponseCode() != 200) {
            throw new Exception("HTTP connection to SLD failed with HTTP response code " + sldConnection.getResponseCode());
        }
    }

    protected String appendSLDPathToURL(String originalURL) {
        if (originalURL.endsWith(DESTINATION_URL_PATH)) {
            return originalURL;
        }
        String url = originalURL;
        if (!url.endsWith("/")) {
            url = url + '/';
        }
        return url + DESTINATION_URL_PATH;
    }
}

