/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.sldreg;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDVersion;
import com.sap.idm.vds.sldreg.VDSSLDReg;
import com.sap.idm.vds.sldreg.common.SLDInfoUploaderForASJava;
import com.sap.idm.vds.sldreg.common.SoftwareComponentVersion;
import com.sap.idm.vds.sldreg.common.Util;
import com.sap.idm.vds.sldreg.vds.deployed.SLDInfoForDeployedVDS;
import com.sap.idm.vds.sldreg.vds.deployed.SLDInfoForVDSSPMLEndPoint;
import java.net.InetAddress;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;

public class VDSSLDRegDeployed
extends VDSSLDReg {
    private static final String TEMPLATE_XML_VDS_SPML_URL = "com/sap/idm/vds/sldreg/vds/deployed/template_vds_spml_endpoint.xml";
    static SLDInfoForDeployedVDS vdsInfo = null;
    static InetAddress mHost = null;
    static Integer mHttpPort = null;
    static Integer mHttpsPort = null;
    static String xmlForSLD = "";
    static Vector sldReportedEndPoints = null;
    static boolean mIsConfigured = false;

    public static boolean isConfigured() {
        return mIsConfigured;
    }

    public static void doConfigure(Vector endPoints) {
        mIsConfigured = false;
        MVDLogger.Log("SLD doConfigure - endPoints -> " + endPoints, 2);
        try {
            if (sldReportedEndPoints != null && sldReportedEndPoints.size() == endPoints.size() && sldReportedEndPoints.containsAll(endPoints)) {
                return;
            }
            String verinfo = MVDVersion.getVersionInfo();
            verinfo = verinfo.substring(0, verinfo.indexOf("Copyright"));
            MVDLogger.Log("SLD doConfigure - VersionInfo -> " + verinfo, 2);
            VDSSLDRegDeployed.obtainNWLocalProperties();
            SLDInfoForVDSSPMLEndPoint[] locEndPoints = new SLDInfoForVDSSPMLEndPoint[endPoints.size()];
            for (int i = 0; i < endPoints.size(); ++i) {
                locEndPoints[i] = new SLDInfoForVDSSPMLEndPoint(mHost, mHttpPort, mHttpsPort, (String)endPoints.elementAt(i));
            }
            try {
                vdsInfo = new SLDInfoForDeployedVDS(InetAddress.getLocalHost(), locEndPoints, SoftwareComponentVersion.VDS_71, 2, verinfo);
            }
            catch (Exception e) {
                MVDLogger.Log("Error while creating SLDInfoForDeployedVDS:" + e, 7);
            }
            try {
                xmlForSLD = VDSSLDRegDeployed.generateXMLForSLD(vdsInfo);
            }
            catch (Exception e) {
                MVDLogger.Log("Error while creating data for SLD:" + e, 7);
                return;
            }
            mIsConfigured = true;
        }
        catch (Exception exc) {
            MVDLogger.Log("Error while creating configuration for SLD:" + exc, 7);
        }
    }

    public static void doPublish() {
        try {
            if (mIsConfigured) {
                MVDLogger.Log("SLD doPublish", 2);
                SLDInfoUploaderForASJava.getInstance().sendXMLToSLD(xmlForSLD);
            }
        }
        catch (Exception exc) {
            MVDLogger.Log("Error while publishing SLD info:" + exc, 7);
            return;
        }
    }

    private static String generateXMLForSLD(SLDInfoForDeployedVDS vdsInfo) throws Exception {
        String cimSystemInstanceName = "VDSSystem.SystemHome." + vdsInfo._host.getHostName() + ".SAP_ApplicationSystemHTTPServicePort." + vdsInfo._lowestPort;
        StringBuffer xmlFragmentForSPMLURLs = new StringBuffer();
        if (vdsInfo._spmlEndPoints != null && vdsInfo._spmlEndPoints.length > 0) {
            String xmlTemplateForDispatcher = Util.readXMLTemplate(TEMPLATE_XML_VDS_SPML_URL);
            for (int i = 0; i < vdsInfo._spmlEndPoints.length; ++i) {
                SLDInfoForVDSSPMLEndPoint spmlEndPoint = vdsInfo._spmlEndPoints[i];
                Properties endPointVariables = new Properties();
                endPointVariables.setProperty("VDS_CIM_SYSTEM_INSTANCE_NAME", cimSystemInstanceName);
                endPointVariables.setProperty("VDS_HOSTNAME_WITHOUT_DOMAIN", vdsInfo._host.getHostName());
                endPointVariables.setProperty("VDS_SPML_ENDPOINT_INDEX", Integer.toString(i));
                endPointVariables.setProperty("VDS_SPML_URL_HTTP", spmlEndPoint._httpURL);
                endPointVariables.setProperty("VDS_SPML_URL_HTTPS", spmlEndPoint._httpsURL);
                xmlFragmentForSPMLURLs.append(Util.processTemplate(xmlTemplateForDispatcher, endPointVariables));
            }
        }
        return VDSSLDRegDeployed.generateMainXMLForSLD(vdsInfo, cimSystemInstanceName, xmlFragmentForSPMLURLs.toString());
    }

    private static void obtainNWLocalProperties() {
        try {
            InitialContext ctx = new InitialContext();
            MVDLogger.Log("SLD obtainNWLocalProperties - ctx -> " + ctx, 2);
            MBeanServer mbs = (MBeanServer)ctx.lookup("jmx");
            MVDLogger.Log("SLD obtainNWLocalProperties - mbs -> " + mbs, 2);
            ObjectName localInstancePattern = new ObjectName("*:j2eeType=SAP_J2EEInstance,name=local,*");
            MVDLogger.Log("SLD obtainNWLocalProperties - localInstancePattern -> " + localInstancePattern, 2);
            Set<ObjectName> result = mbs.queryNames(localInstancePattern, null);
            MVDLogger.Log("SLD obtainNWLocalProperties - result -> " + result, 2);
            if (result.isEmpty()) {
                MVDLogger.Log("Did not find local instance MBean. Cannot determine local hostname and HTTP(S) port numbers.", 2);
                return;
            }
            ObjectName localInstanceON = result.iterator().next();
            MVDLogger.Log("SLD obtainNWLocalProperties - localInstanceON -> " + localInstanceON, 2);
            String hostName = (String)mbs.getAttribute(localInstanceON, "Host");
            mHttpPort = (Integer)mbs.getAttribute(localInstanceON, "HttpPort");
            mHttpsPort = (Integer)mbs.getAttribute(localInstanceON, "HttpsPort");
            mHost = InetAddress.getByName(hostName);
            MVDLogger.Log("SLD obtainNWLocalProperties - hostName -> " + hostName + ", mHttpPort -> " + mHttpPort + ", mHttpPort -> " + mHttpsPort + ", mHttpsPort -> " + mHttpPort + ", mHost -> " + mHost, 2);
        }
        catch (Exception exc) {
            MVDLogger.Log("Error while obtaining local NW properties: " + exc, 2);
            return;
        }
    }
}

