/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.queue;

import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.queue.QueueClass;
import com.sap.idm.vds.queue.QueueClassCallable;
import java.util.HashMap;

public class QueueClassConfig {
    private HashMap mParams = new HashMap();
    private String mClassName = "None";

    public QueueClassConfig() {
    }

    public QueueClassConfig(String aClassname, HashMap aParams) throws MVDConfigException {
        this.mParams = aParams == null ? new HashMap() : aParams;
        this.mClassName = aClassname;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public void setClassName(String className) {
        this.mClassName = className;
    }

    public HashMap getParams() {
        return this.mParams;
    }

    public void setParams(HashMap params) {
        this.mParams = params;
    }

    public void prepareClass() throws MVDConfigException {
        Globals.AddExternalClass(this.mClassName);
    }

    public QueueClassCallable getExecutable() {
        return this.instantiateClass();
    }

    private QueueClassCallable instantiateClass() {
        try {
            HashMap params = new HashMap(this.mParams);
            Class classss = (Class)Globals.GetExternalClass(this.mClassName);
            QueueClass evact = (QueueClass)classss.newInstance();
            QueueClassCallable callable = new QueueClassCallable(evact, params);
            return callable;
        }
        catch (Exception e) {
            MVDLogger.Log("Unable to instantiate class: " + this.mClassName, 7, e);
            return null;
        }
        catch (Throwable e) {
            MVDLogger.Log("Unable to instantiate class: " + this.mClassName, 7, e);
            return null;
        }
    }
}

