/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.protocols.ldap;

import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.ldapv3.AddRequest;
import com.sap.idm.vds.ldapv3.AttributeDescriptionList;
import com.sap.idm.vds.ldapv3.AttributeList;
import com.sap.idm.vds.ldapv3.AttributeListSeq;
import com.sap.idm.vds.ldapv3.AttributeTypeAndValues;
import com.sap.idm.vds.ldapv3.AttributeValueAssertion;
import com.sap.idm.vds.ldapv3.AuthenticationChoice;
import com.sap.idm.vds.ldapv3.BindRequest;
import com.sap.idm.vds.ldapv3.CompareRequest;
import com.sap.idm.vds.ldapv3.DelRequest;
import com.sap.idm.vds.ldapv3.Filter;
import com.sap.idm.vds.ldapv3.LDAPMessage;
import com.sap.idm.vds.ldapv3.ModifyRequest;
import com.sap.idm.vds.ldapv3.ModifyRequestSeqOf;
import com.sap.idm.vds.ldapv3.ModifyRequestSeqOfSeq;
import com.sap.idm.vds.ldapv3.SearchRequest;
import com.sap.idm.vds.message.MxAbandon;
import com.sap.idm.vds.message.MxAdd;
import com.sap.idm.vds.message.MxBind;
import com.sap.idm.vds.message.MxCompare;
import com.sap.idm.vds.message.MxDelete;
import com.sap.idm.vds.message.MxModify;
import com.sap.idm.vds.message.MxRename;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.message.MxSearch;
import com.sap.idm.vds.message.MxUnbind;
import com.sap.idm.vds.protocols.ldap.MxLdapResponse;
import java.util.Enumeration;
import java.util.Vector;

public class MxLdapTransform {
    public static MxLdapResponse transformback(LDAPMessage request, MxResponse resp) throws Exception {
        MxLdapResponse responseStruct = new MxLdapResponse(true);
        responseStruct.setMessageID(request.messageID);
        if (resp.size() > 0) {
            if (request.protocolOp.choiceId != 3) {
                // empty if block
            }
            responseStruct.setEntriesResult(responseStruct.SendSearchResults(request.protocolOp.searchRequest.typesOnly, resp));
        }
        LDAPMessage doneResult = null;
        if (request.protocolOp.choiceId == 0) {
            int i;
            String concatenatedStr = resp.getMessage();
            int iAdditionalCode = 0;
            if (concatenatedStr.startsWith("[") && (i = (concatenatedStr = concatenatedStr.substring(1)).indexOf("]")) > 0) {
                String tmp = concatenatedStr.substring(0, i);
                concatenatedStr = concatenatedStr.substring(i + 1);
                iAdditionalCode = Integer.parseInt(tmp);
            }
            doneResult = responseStruct.CreateBindResponse(resp.getCode(), iAdditionalCode, concatenatedStr);
        } else {
            int iOutboundType = 0;
            if (request.protocolOp.choiceId == 3) {
                iOutboundType = 5;
            } else if (request.protocolOp.choiceId == 6) {
                iOutboundType = 7;
            } else if (request.protocolOp.choiceId == 8) {
                iOutboundType = 9;
            } else if (request.protocolOp.choiceId == 10) {
                iOutboundType = 11;
            } else if (request.protocolOp.choiceId == 14) {
                iOutboundType = 15;
            } else if (request.protocolOp.choiceId == 12) {
                iOutboundType = 13;
            }
            if (request.protocolOp.choiceId == 2) {
                iOutboundType = 2;
            }
            doneResult = responseStruct.CreateDoneResult(resp.getCode(), resp.getMessage(), iOutboundType);
        }
        responseStruct.setDoneResult(doneResult);
        return responseStruct;
    }

    public static MxRequest transform(LDAPMessage request) {
        switch (request.protocolOp.choiceId) {
            case 0: {
                return MxLdapTransform.doBindTransform(request);
            }
            case 3: {
                return MxLdapTransform.doSearchTransform(request);
            }
            case 6: {
                return MxLdapTransform.doModifyTransform(request);
            }
            case 8: {
                return MxLdapTransform.doAddTransform(request);
            }
            case 10: {
                return MxLdapTransform.doDeleteTransform(request);
            }
            case 12: {
                return MxLdapTransform.doRenameTransform(request);
            }
            case 14: {
                return MxLdapTransform.doCompareTransform(request);
            }
            case 16: {
                return MxLdapTransform.doAbandonTransform(request);
            }
            case 2: {
                return MxLdapTransform.doUnbindTransform(request);
            }
        }
        return null;
    }

    private static MxSearch doSearchTransform(LDAPMessage lReq) {
        try {
            MxSearch transformed = new MxSearch();
            String s = "";
            byte[] dn = null;
            SearchRequest req = lReq.protocolOp.searchRequest;
            dn = req.baseObject;
            s = dn != null ? MVDUtil.FromUTF8(dn) : "";
            transformed.setStartingPoint(s);
            transformed.setOperationScope(req.scope.value);
            transformed.setTypesOnly(req.typesOnly);
            transformed.setRequestedStructFilter(new Filter(req.filter));
            AttributeDescriptionList vv = req.attributes;
            int ls = vv.size();
            Vector<String> tmpvector = new Vector<String>();
            for (int x = 0; x < ls; ++x) {
                String oneAttr = MVDUtil.FromUTF8((byte[])vv.elementAt(x));
                tmpvector.addElement(oneAttr.trim().toLowerCase());
            }
            transformed.setRequestedAttributes(tmpvector);
            transformed.setSizeLimit(req.sizeLimit.intValue());
            transformed.setTimeLimit(req.timeLimit.intValue());
            return transformed;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MxDelete doDeleteTransform(LDAPMessage lReq) {
        MxDelete transformed = new MxDelete();
        String s = "";
        byte[] dn = null;
        DelRequest req = lReq.protocolOp.delRequest;
        dn = req.value;
        s = dn != null ? MVDUtil.FromUTF8(dn) : "";
        transformed.setDn(s);
        return transformed;
    }

    private static MxCompare doCompareTransform(LDAPMessage lReq) {
        try {
            MxCompare transformed = new MxCompare();
            String s = "";
            byte[] dn = null;
            CompareRequest req = lReq.protocolOp.compareRequest;
            dn = req.entry;
            s = dn != null ? MVDUtil.FromUTF8(dn) : "";
            transformed.setStartingPoint(s);
            AttributeValueAssertion aaval = req.ava;
            transformed.setCompValue(MVDUtil.FromUTF8(aaval.assertionValue));
            transformed.setCompAttr(MVDUtil.FromUTF8(aaval.attributeDesc));
            return transformed;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MxRename doRenameTransform(LDAPMessage lReq) {
        MxRename transformed = new MxRename();
        return transformed;
    }

    private static MxAbandon doAbandonTransform(LDAPMessage lReq) {
        MxAbandon transformed = new MxAbandon();
        return transformed;
    }

    private static MxUnbind doUnbindTransform(LDAPMessage lReq) {
        MxUnbind transformed = new MxUnbind();
        return transformed;
    }

    private static MxBind doBindTransform(LDAPMessage lReq) {
        try {
            MxBind transformed = new MxBind();
            BindRequest req = lReq.protocolOp.bindRequest;
            AuthenticationChoice ac = req.authentication;
            transformed.setVersion(req.version.intValue());
            String aBindName = "";
            String aBindPwd = "";
            if (ac.choiceId == 0) {
                transformed.setAuthType(0);
                aBindName = MVDUtil.FromUTF8(req.name);
                aBindPwd = MVDUtil.FromUTF8(ac.simple);
            } else if (ac.choiceId == 10) {
                transformed.setAuthType(10);
                aBindName = "";
                aBindPwd = "";
            } else {
                transformed.setAuthType(999);
                aBindName = "";
                aBindPwd = "";
            }
            transformed.setUserName(aBindName);
            transformed.setPassword(aBindPwd);
            return transformed;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MxAdd doAddTransform(LDAPMessage lReq) {
        try {
            MxAdd transformed = new MxAdd();
            AddRequest req = lReq.protocolOp.addRequest;
            String s = "";
            byte[] dn = null;
            dn = req.entry;
            s = dn != null ? MVDUtil.FromUTF8(dn) : "";
            transformed.setDn(s);
            AttributeList attrList = req.attributes;
            Enumeration enumAttr = attrList.elements();
            while (enumAttr.hasMoreElements()) {
                byte[] thisVal;
                Enumeration enumVal;
                AttributeListSeq als = (AttributeListSeq)enumAttr.nextElement();
                String attrName = MVDUtil.FromUTF8(als.type);
                attrName = attrName.trim().toLowerCase();
                Vector<Object> attrValues = transformed.getAttrSetAndValues().getAttrValues(attrName);
                boolean bFirst = false;
                if (attrValues == null) {
                    attrValues = new Vector<Object>();
                    bFirst = true;
                }
                if (MVDProxy.IsBinaryAttribute(attrName)) {
                    enumVal = als.vals.elements();
                    while (enumVal.hasMoreElements()) {
                        thisVal = (byte[])enumVal.nextElement();
                        int z = thisVal.length;
                        if (z <= 0) continue;
                        byte[] b = new byte[z];
                        System.arraycopy(thisVal, 0, b, 0, z);
                        attrValues.addElement(b);
                    }
                } else {
                    enumVal = als.vals.elements();
                    while (enumVal.hasMoreElements()) {
                        thisVal = (byte[])enumVal.nextElement();
                        String attrVal = MVDUtil.FromUTF8(thisVal);
                        if (attrVal.length() <= 0) continue;
                        attrValues.addElement(attrVal);
                    }
                }
                if (attrValues.size() <= 0 || !bFirst) continue;
                transformed.getAttrSetAndValues().setAttrValue(attrName, true, attrValues);
            }
            return transformed;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MxModify doModifyTransform(LDAPMessage lReq) {
        try {
            MxModify transformed = new MxModify();
            ModifyRequest req = lReq.protocolOp.modifyRequest;
            String s = "";
            byte[] dn = null;
            dn = req.object;
            s = dn != null ? MVDUtil.FromUTF8(dn) : "";
            transformed.setDn(s);
            ModifyRequestSeqOf modList = req.modification;
            Enumeration enumMods = modList.elements();
            while (enumMods.hasMoreElements()) {
                byte[] thisVal;
                Enumeration enumVal;
                ModifyRequestSeqOfSeq oneMod = (ModifyRequestSeqOfSeq)enumMods.nextElement();
                int modType = oneMod.operation.value;
                AttributeTypeAndValues modification = oneMod.modification;
                String attrName = MVDUtil.FromUTF8(modification.type);
                MVDModAttrValues attrValues = new MVDModAttrValues();
                attrValues.setModType(modType);
                attrValues.setAttrName(attrName.trim().toLowerCase());
                if (MVDProxy.IsBinaryAttribute(attrName)) {
                    enumVal = modification.vals.elements();
                    while (enumVal.hasMoreElements()) {
                        thisVal = (byte[])enumVal.nextElement();
                        int z = thisVal.length;
                        if (z <= 0) continue;
                        byte[] b = new byte[z];
                        System.arraycopy(thisVal, 0, b, 0, z);
                        attrValues.addElement(b);
                    }
                } else {
                    enumVal = modification.vals.elements();
                    while (enumVal.hasMoreElements()) {
                        thisVal = (byte[])enumVal.nextElement();
                        String attrVal = MVDUtil.FromUTF8(thisVal);
                        if (attrVal.length() <= 0) continue;
                        attrValues.addElement(attrVal);
                    }
                }
                transformed.getAttrAndModValues().add(attrValues);
            }
            return transformed;
        }
        catch (Exception e) {
            return null;
        }
    }
}

