/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.protocols.ldap;

import com.sap.idm.vds.Engine;
import com.sap.idm.vds.MVDGlobalStatistics;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.config.MVDLDAPDeploymentList;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.ldapv3.LDAPMessage;
import com.sap.idm.vds.message.MxBind;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.protocols.ldap.MxLdapMessageHandler;
import com.sap.idm.vds.protocols.ldap.MxLdapResponse;
import com.sap.idm.vds.protocols.ldap.MxLdapTransform;
import com.sap.idm.vds.queue.MVDCandidateGoSync;
import com.sap.idm.vds.queue.MVDPriorityQueue;
import java.net.Socket;
import java.util.HashMap;

public class MxLdapSession
extends Thread {
    private MVDPriorityQueue mCandQueue = null;
    private MxLdapMessageHandler mMsgHandler = null;
    private String mSessionName;
    private static int numberOfUnbinds = 0;
    private static int numberOfBinds = 0;
    private static int numberOfSearches = 0;
    private static int numberOfRests = 0;

    public MxLdapSession(Socket client, String sessionName, ThreadGroup aGroup, MVDPriorityQueue aMVDQueue) throws Exception {
        super(aGroup, sessionName);
        this.mCandQueue = aMVDQueue;
        this.mSessionName = sessionName;
        MVDLogger.Log("LDAP Session: Creating new one, id=" + sessionName, 0);
        client.setTcpNoDelay(true);
        client.setSoTimeout(MVDProxy.SessionTimeout() * 1000);
        MVDLogger.Log("LDAP Session=" + sessionName + ": uses client " + client.getLocalPort() + " " + client.getPort(), 0);
        this.mMsgHandler = new MxLdapMessageHandler(client, sessionName);
        MVDLogger.Log("LDAP Session: Created id=" + sessionName, 0);
    }

    private synchronized int calculateBucket(MxRequest aReq, HashMap additionalMap) {
        int priority = this.mCandQueue.getCallable().execute(aReq, additionalMap, this.mCandQueue.getNumberofPriorityLevels());
        return priority;
    }

    private MxResponse informBusy(int aChoiceId) {
        if (aChoiceId == 2 || aChoiceId == 16) {
            return null;
        }
        MVDSearchResults mxresp = new MVDSearchResults();
        mxresp.setError(this.mCandQueue.getBusyLDAPCode(), this.mCandQueue.getBusyMessage());
        return mxresp;
    }

    public void run() {
        try {
            this.setPriority(3);
            boolean continueSession = true;
            String aThreadAndMessageID = "";
            boolean bFreeToExecute = true;
            boolean bPassThrougRequest = true;
            while (continueSession) {
                LDAPMessage request = this.mMsgHandler.getNextRequest();
                Engine xx = this.mMsgHandler.getEngine();
                if (xx == null) {
                    MxResponse negativeResponse = new MxResponse();
                    negativeResponse.setError(52, "Engine limit reached");
                    MxLdapResponse finalResult = MxLdapTransform.transformback(request, negativeResponse);
                    if (finalResult != null) {
                        finalResult.sendMessageStruct(this.mMsgHandler);
                        continueSession = false;
                        continue;
                    }
                }
                this.mMsgHandler.getEngine().getEngineData().MvdDebit().startOperation();
                if (request != null) {
                    block48: {
                        MxLdapTransform trans = new MxLdapTransform();
                        MxRequest mx = MxLdapTransform.transform(request);
                        if (mx.getChoiceID() == 0) {
                            ((MxBind)mx).setClientIP(this.mMsgHandler.getConnection().getClient().getInetAddress().getHostAddress());
                            if (MVDLDAPDeploymentList.getMainLDAPDeployment().getSecureServer() && MVDLDAPDeploymentList.getMainLDAPDeployment().getClientAuthentication()) {
                                ((MxBind)mx).setClientCertificates(this.mMsgHandler.getConnection().getClientCertificates());
                            }
                        }
                        try {
                            MxResponse mxresp = null;
                            aThreadAndMessageID = "[" + this.getName() + "_" + request.messageID.toString() + "]";
                            if (this.mCandQueue != null) {
                                bFreeToExecute = false;
                                bPassThrougRequest = false;
                                HashMap<String, String> additionalInfoForPrio = new HashMap<String, String>();
                                additionalInfoForPrio.put("USERNAME", this.mMsgHandler.getEngine().getEngineData().MvdDebit().UserName());
                                additionalInfoForPrio.put("USERGROUP", this.mMsgHandler.getEngine().getEngineData().MvdDebit().UserGroup());
                                additionalInfoForPrio.put("CLIENTIP", this.mMsgHandler.getEngine().getEngineData().MvdDebit().ClientIPAddress());
                                MVDCandidateGoSync mySync = new MVDCandidateGoSync(this.mCandQueue);
                                int bucket = 0;
                                if (this.mCandQueue.getCallable() != null) {
                                    bucket = this.calculateBucket(mx, additionalInfoForPrio);
                                }
                                MVDLogger.Log("Thread " + aThreadAndMessageID + " about to be processed", 0);
                                int aChoiceId = mx.getChoiceID();
                                if (aChoiceId == 2 || aChoiceId == 16) {
                                    MVDGlobalStatistics.setStatistic("UNBINDs", "" + ++numberOfUnbinds);
                                    bPassThrougRequest = true;
                                } else {
                                    if (aChoiceId == 0) {
                                        MVDGlobalStatistics.setStatistic("BINDs", "" + ++numberOfBinds);
                                    } else if (aChoiceId == 3) {
                                        MVDGlobalStatistics.setStatistic("SEARCHes", "" + ++numberOfSearches);
                                    } else {
                                        MVDGlobalStatistics.setStatistic("RESTs", "" + ++numberOfRests);
                                    }
                                    MVDLogger.Log("Thread " + aThreadAndMessageID + " gets permission to execute", 0);
                                    int addStatus = mySync.getPermission2Execute(aThreadAndMessageID, bucket);
                                    if (addStatus == 2222) {
                                        bFreeToExecute = true;
                                    } else if (addStatus == 3333) {
                                        boolean isSelectedToRun = this.mCandQueue.removeCandidate(aThreadAndMessageID, bucket, mySync);
                                        if (!isSelectedToRun) {
                                            MVDLogger.Log("Thread " + aThreadAndMessageID + " leaves - system is too BUSY", 2);
                                            mxresp = this.informBusy(aChoiceId);
                                        } else {
                                            bFreeToExecute = true;
                                        }
                                    } else if (addStatus == 4444 || addStatus == 5555) {
                                        MVDLogger.Log("Thread " + aThreadAndMessageID + " leaves - system is too BUSY", 2);
                                        mxresp = this.informBusy(aChoiceId);
                                    }
                                }
                            }
                            if (bFreeToExecute || bPassThrougRequest) {
                                String ip = this.mMsgHandler.getConnection().getClient().getInetAddress().getHostAddress();
                                mxresp = this.mMsgHandler.getEngine().answerRequest(mx, ip);
                                if (this.mCandQueue != null && bFreeToExecute) {
                                    this.mCandQueue.signalThatCandidateIsDone(aThreadAndMessageID);
                                    MVDLogger.Log("Thread; " + aThreadAndMessageID + " reported DONE", 0);
                                }
                            }
                            if (mxresp != null && mxresp.getCode() == 99999) {
                                try {
                                    this.mMsgHandler.sendRawResponse(mxresp.getTransBytes());
                                    continueSession = mxresp.getSessionDestiny();
                                    if (continueSession) {
                                        MVDLogger.Log("As a result of trans. auth, session will continue", 0);
                                        break block48;
                                    }
                                    MVDLogger.Log("invalid trans. auth, session will be stopped", 0);
                                }
                                catch (Exception e) {
                                    continueSession = false;
                                }
                                break block48;
                            }
                            if (mxresp == null) {
                                continueSession = false;
                            } else {
                                MxLdapResponse finalResult = MxLdapTransform.transformback(request, mxresp);
                                if (finalResult != null) {
                                    try {
                                        finalResult.sendMessageStruct(this.mMsgHandler);
                                        continueSession = finalResult.getContinueAfterMe();
                                    }
                                    catch (Exception e) {
                                        continueSession = false;
                                    }
                                } else {
                                    MVDLogger.Log("Unrecognized statement on " + request.messageID, 0);
                                    continueSession = false;
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (this.mCandQueue != null) {
                                this.mCandQueue.signalThatCandidateIsDone(aThreadAndMessageID);
                                MVDLogger.Log("Thread; " + aThreadAndMessageID + " reported ERROR", 0);
                            }
                            continueSession = false;
                        }
                    }
                    if (!continueSession) {
                        MVDLogger.Log("VDS ends the LDAP session", 2);
                    } else {
                        MVDLogger.Log("LDAP Session continues ... ", 2);
                    }
                    request = null;
                    continue;
                }
                continueSession = false;
            }
            this.setPriority(4);
            this.closeMsgHandler();
            MVDLogger.Log("LDAP Session (" + this.mSessionName + "): Ended", 0);
        }
        catch (Exception e) {
            MVDLogger.Log("LDAP Session (" + this.mSessionName + "): Failed session: " + e.getMessage(), 7, e);
            try {
                this.closeMsgHandler();
            }
            catch (Exception ee) {}
        }
        catch (VirtualMachineError t) {
            System.out.println("Throwable:" + t);
            MVDLogger.Log("Throwable:" + t, 7);
            try {
                this.closeMsgHandler();
            }
            catch (Exception ee) {
                // empty catch block
            }
            System.out.println("FATAL error - shutting down");
            MVDLogger.Log("FATAL error - shutting down", 7);
            System.exit(1);
        }
        catch (Throwable tr) {
            System.out.println("Throwable:" + tr);
            MVDLogger.Log("Throwable:" + tr, 7);
            try {
                this.closeMsgHandler();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void close() {
        this.closeMsgHandler();
    }

    public void closeMsgHandler() {
        if (this.mMsgHandler != null) {
            this.mMsgHandler.close();
            this.mMsgHandler = null;
        }
    }
}

