/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.protocols.ldap;

import com.sap.idm.vds.MVDError;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.ldapv3.AddResponse;
import com.sap.idm.vds.ldapv3.BindResponse;
import com.sap.idm.vds.ldapv3.CompareResponse;
import com.sap.idm.vds.ldapv3.DelResponse;
import com.sap.idm.vds.ldapv3.LDAPMessage;
import com.sap.idm.vds.ldapv3.LDAPMessageChoice;
import com.sap.idm.vds.ldapv3.LDAPResult;
import com.sap.idm.vds.ldapv3.LDAPResultEnum;
import com.sap.idm.vds.ldapv3.ModifyDNResponse;
import com.sap.idm.vds.ldapv3.ModifyResponse;
import com.sap.idm.vds.ldapv3.PartialAttributeList;
import com.sap.idm.vds.ldapv3.SearchResultDone;
import com.sap.idm.vds.ldapv3.SearchResultEntry;
import com.sap.idm.vds.protocols.ldap.MxLdapMessageHandler;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class MxLdapResponse {
    boolean mContinueAfterMe = false;
    private BigInteger mMessageID;
    private Vector mEntriesResult = new Vector();
    private LDAPMessage mDoneResult = null;

    public MxLdapResponse() {
    }

    public MxLdapResponse(boolean b) {
        this.mContinueAfterMe = b;
    }

    public MxLdapResponse(Vector resultsToBeSent, LDAPMessage doneResult) {
        this.mEntriesResult = resultsToBeSent;
        this.mDoneResult = doneResult;
    }

    public void setDoneResult(LDAPMessage m) {
        this.mDoneResult = m;
    }

    public void setEntriesResult(Vector v) {
        this.mEntriesResult = v;
    }

    public void setMessageID(BigInteger b) {
        this.mMessageID = b;
    }

    public void setContinueAfterMe(boolean b) {
        this.mContinueAfterMe = b;
    }

    public boolean getContinueAfterMe() {
        return this.mContinueAfterMe;
    }

    public void sendMessageStruct(MxLdapMessageHandler ee) throws Exception {
        try {
            if (this.mEntriesResult != null && this.mEntriesResult.size() > 0) {
                MVDLogger.Log("Sending search result entries", 1);
                for (int x = 0; x < this.mEntriesResult.size(); ++x) {
                    LDAPMessage rp = (LDAPMessage)this.mEntriesResult.elementAt(x);
                    rp.messageID = this.mMessageID;
                    ee.sendResponse(rp);
                }
            }
        }
        catch (Exception de) {
            MVDLogger.Log("Error sending results" + de.getMessage(), 2);
            throw new Exception("Engine (" + this.mMessageID + "): Error Communicating with Client: " + de.getMessage());
        }
        try {
            if (this.mDoneResult != null) {
                MVDLogger.Log("Sending operation result", 1);
                this.mDoneResult.messageID = this.mMessageID;
                ee.sendResponse(this.mDoneResult);
            }
        }
        catch (Exception dee) {
            MVDLogger.Log("Error sending operation result" + dee.getMessage(), 2);
            throw new Exception("Engine (" + this.mMessageID + "): Error Communicating with Client: " + dee.getMessage());
        }
    }

    public void sendRawResponse(MxLdapMessageHandler ee) throws Exception {
        try {
            if (this.mDoneResult != null) {
                MVDLogger.Log("Sending raw response", 1);
                this.mDoneResult.messageID = this.mMessageID;
                ee.getConnection().sendResponse(this.mDoneResult);
            }
        }
        catch (Exception dee) {
            MVDLogger.Log("Error sending raw response" + dee.getMessage(), 2);
            throw new Exception("Engine (" + this.mMessageID + "): Error Communicating with Client: " + dee.getMessage());
        }
    }

    public LDAPMessage CreateDoneResult(int aCode, String am, int iDoneId) {
        LDAPMessage doneResult = new LDAPMessage();
        LDAPMessageChoice op = new LDAPMessageChoice();
        LDAPResult srd = null;
        if (iDoneId == 5) {
            srd = new SearchResultDone();
        } else if (iDoneId == 11) {
            srd = new DelResponse();
        } else if (iDoneId == 9) {
            srd = new AddResponse();
        } else if (iDoneId == 7) {
            srd = new ModifyResponse();
        } else if (iDoneId == 13) {
            srd = new ModifyDNResponse();
        } else if (iDoneId == 15) {
            srd = new CompareResponse();
        }
        srd.resultCode = new LDAPResultEnum(aCode);
        srd.matchedDN = new byte[0];
        srd.errorMessage = am != null && am.length() > 0 ? MVDUtil.ToUTF8(am) : new byte[0];
        srd.referral = null;
        op.choiceId = iDoneId;
        if (iDoneId == 5) {
            op.searchResDone = srd;
        } else if (iDoneId == 11) {
            op.delResponse = (DelResponse)srd;
        } else if (iDoneId == 9) {
            op.addResponse = (AddResponse)srd;
        } else if (iDoneId == 7) {
            op.modifyResponse = (ModifyResponse)srd;
        } else if (iDoneId == 13) {
            op.modDNResponse = (ModifyDNResponse)srd;
        } else if (iDoneId == 15) {
            op.compareResponse = (CompareResponse)srd;
        }
        doneResult.protocolOp = op;
        return doneResult;
    }

    public LDAPMessage CreateBindResponse(int aCode, int aAdditionalCode, String aMessage) {
        LDAPMessage bindResult = new LDAPMessage();
        LDAPMessageChoice op = new LDAPMessageChoice();
        BindResponse bindResponse = new BindResponse();
        bindResponse.matchedDN = new byte[0];
        bindResponse.errorMessage = new byte[0];
        bindResponse.referral = null;
        bindResponse.serverSaslCreds = null;
        op.choiceId = 1;
        op.bindResponse = bindResponse;
        bindResult.protocolOp = op;
        String aNewMessage = "";
        int aNewCode = 0;
        switch (aCode) {
            case -1056: 
            case -1053: 
            case -1052: 
            case -1051: 
            case -1044: 
            case -1013: {
                aNewCode = MVDError.GetMapping(aCode);
                aNewMessage = MVDError.GetAdditionalInfo(aCode);
                break;
            }
            case 0: {
                aNewCode = 0;
                aNewMessage = "";
                break;
            }
            case -1054: {
                if (aAdditionalCode == 0) {
                    aNewCode = MVDError.GetMapping(aCode);
                    aNewMessage = MVDError.GetAdditionalInfo(aCode);
                    break;
                }
                aNewCode = aAdditionalCode;
                aNewMessage = aMessage;
                break;
            }
            default: {
                aNewCode = aCode;
                aNewMessage = aMessage;
            }
        }
        bindResponse.resultCode = new LDAPResultEnum(aNewCode);
        if (aNewMessage == null) {
            aNewMessage = "";
        }
        bindResponse.errorMessage = MVDUtil.ToUTF8(aNewMessage);
        return bindResult;
    }

    public static PartialAttributeList attributeListFromGeneralEntry(HashMap si, boolean typesOnly) {
        if (si.size() == 0) {
            return new PartialAttributeList(si);
        }
        if (!typesOnly) {
            return new PartialAttributeList(si);
        }
        return new PartialAttributeList(si, true);
    }

    public Vector SendSearchResults(boolean typesOnly, Vector sendMe) throws Exception {
        Vector<LDAPMessage> allResponses = new Vector<LDAPMessage>();
        if (sendMe.size() == 0) {
            return allResponses;
        }
        Enumeration aEnum = sendMe.elements();
        while (aEnum.hasMoreElements()) {
            LDAPMessage response = new LDAPMessage();
            LDAPMessageChoice op = new LDAPMessageChoice();
            op.choiceId = 4;
            SearchResultEntry sre = new SearchResultEntry();
            MVDSearchResultEntry entryToSend = (MVDSearchResultEntry)aEnum.nextElement();
            String nm = entryToSend.getDn();
            sre.objectName = MVDUtil.ToUTF8(nm);
            sre.attributes = MxLdapResponse.attributeListFromGeneralEntry(entryToSend.getAttrAndValues(), typesOnly);
            op.searchResEntry = sre;
            response.protocolOp = op;
            allResponses.add(response);
        }
        return allResponses;
    }
}

